/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.lang.NonNull;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.builders.ExternalDocumentationBuilder;
import springfox.documentation.builders.ResourceListingBuilder;
import springfox.documentation.builders.ServerBuilder;
import springfox.documentation.common.ExternalDocumentation;
import springfox.documentation.service.ApiListing;
import springfox.documentation.service.Documentation;
import springfox.documentation.service.ResourceListing;
import springfox.documentation.service.Tag;
import springfox.documentation.service.Tags;
import springfox.documentation.service.VendorExtension;

public class DocumentationBuilder {
    private final Map<String, List<ApiListing>> apiListings = new TreeMap(Comparator.naturalOrder());
    private final Set<Tag> tags = new TreeSet<Tag>(Tags.tagComparator());
    private final Set<String> produces = new TreeSet<String>();
    private final Set<String> consumes = new TreeSet<String>();
    private final Set<String> schemes = new TreeSet<String>();
    private final List<VendorExtension> vendorExtensions = new ArrayList<VendorExtension>();
    private final Map<String, ServerBuilder> servers = new TreeMap<String, ServerBuilder>();
    private ResourceListing resourceListing;
    private String groupName;
    private String basePath;
    private String host;
    private ExternalDocumentation externalDocumentation;

    public DocumentationBuilder name(String groupName) {
        this.groupName = BuilderDefaults.defaultIfAbsent(groupName, this.groupName);
        return this;
    }

    public DocumentationBuilder apiListingsByResourceGroupName(Map<String, List<ApiListing>> apiListings) {
        BuilderDefaults.nullToEmptyMultimap(apiListings).forEach((key, value) -> {
            List<Object> list;
            if (this.apiListings.containsKey(key)) {
                list = this.apiListings.get(key);
                list.addAll((Collection<Object>)value);
            } else {
                list = new ArrayList(value);
                this.apiListings.put((String)key, (List<ApiListing>)list);
            }
            list.sort(DocumentationBuilder.byListingPosition());
        });
        return this;
    }

    @Deprecated
    public DocumentationBuilder resourceListing(ResourceListing resourceListing) {
        this.resourceListing = BuilderDefaults.defaultIfAbsent(resourceListing, this.resourceListing);
        return this;
    }

    public DocumentationBuilder resourceListing(@NonNull Consumer<ResourceListingBuilder> consumer) {
        ResourceListingBuilder builder = new ResourceListingBuilder();
        consumer.accept(builder);
        this.resourceListing = BuilderDefaults.defaultIfAbsent(builder.build(), this.resourceListing);
        return this;
    }

    public DocumentationBuilder tags(Set<Tag> tags) {
        this.tags.addAll(BuilderDefaults.nullToEmptySet(tags).stream().filter(Objects::nonNull).collect(Collectors.toSet()));
        return this;
    }

    public DocumentationBuilder produces(Set<String> mediaTypes) {
        this.produces.addAll(BuilderDefaults.nullToEmptySet(mediaTypes).stream().filter(Objects::nonNull).collect(Collectors.toSet()));
        return this;
    }

    public DocumentationBuilder consumes(Set<String> mediaTypes) {
        this.consumes.addAll(BuilderDefaults.nullToEmptySet(mediaTypes).stream().filter(Objects::nonNull).collect(Collectors.toSet()));
        return this;
    }

    public DocumentationBuilder host(String host) {
        this.host = BuilderDefaults.defaultIfAbsent(host, this.host);
        return this;
    }

    public DocumentationBuilder schemes(Set<String> schemes) {
        this.schemes.addAll(BuilderDefaults.nullToEmptySet(schemes).stream().filter(Objects::nonNull).collect(Collectors.toSet()));
        return this;
    }

    public DocumentationBuilder basePath(String basePath) {
        this.basePath = BuilderDefaults.defaultIfAbsent(basePath, this.basePath);
        return this;
    }

    public DocumentationBuilder extensions(List<VendorExtension> extensions) {
        this.vendorExtensions.addAll(BuilderDefaults.nullToEmptyList(extensions));
        return this;
    }

    public Function<Consumer<ServerBuilder>, DocumentationBuilder> server(String name) {
        return consumer -> {
            consumer.accept(this.servers.computeIfAbsent(name, n -> new ServerBuilder().name((String)n)));
            return this;
        };
    }

    public DocumentationBuilder externalDocumentation(@NonNull Consumer<ExternalDocumentationBuilder> consumer) {
        ExternalDocumentationBuilder builder = new ExternalDocumentationBuilder();
        consumer.accept(builder);
        this.externalDocumentation = BuilderDefaults.defaultIfAbsent(builder.build(), this.externalDocumentation);
        return this;
    }

    public static Comparator<ApiListing> byListingPosition() {
        return Comparator.comparingInt(ApiListing::getPosition);
    }

    public Documentation build() {
        return new Documentation(this.groupName, this.basePath, this.tags, this.apiListings, this.resourceListing, this.produces, this.consumes, this.host, this.schemes, this.servers.values().stream().map(ServerBuilder::build).collect(Collectors.toList()), this.externalDocumentation, this.vendorExtensions);
    }
}

