/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema;

import java.util.Objects;
import java.util.StringJoiner;
import springfox.documentation.builders.ElementFacetBuilder;
import springfox.documentation.builders.StringElementFacetBuilder;
import springfox.documentation.schema.ElementFacet;

public class StringElementFacet
implements ElementFacet {
    private final Integer maxLength;
    private final Integer minLength;
    private final String pattern;

    public StringElementFacet(Integer maxLength, Integer minLength, String pattern) {
        this.maxLength = maxLength;
        this.minLength = minLength;
        this.pattern = pattern;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public String getPattern() {
        return this.pattern;
    }

    @Override
    public Class<? extends ElementFacetBuilder> facetBuilder() {
        return StringElementFacetBuilder.class;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringElementFacet that = (StringElementFacet)o;
        return Objects.equals(this.maxLength, that.maxLength) && Objects.equals(this.minLength, that.minLength) && Objects.equals(this.pattern, that.pattern);
    }

    public int hashCode() {
        return Objects.hash(this.maxLength, this.minLength, this.pattern);
    }

    public String toString() {
        return new StringJoiner(", ", StringElementFacet.class.getSimpleName() + "[", "]").add("maxLength=" + this.maxLength).add("minLength=" + this.minLength).add("pattern='" + this.pattern + "'").toString();
    }
}

