/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.measure;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.measure.Angle;
import org.geotools.measure.Latitude;
import org.geotools.measure.Longitude;
import org.geotools.metadata.i18n.Errors;
import org.geotools.metadata.math.XMath;
import org.geotools.util.Classes;
import org.geotools.util.Utilities;
import org.geotools.util.logging.LoggedFormat;

public class AngleFormat
extends Format {
    private static final long serialVersionUID = 4320403817210439764L;
    private static final char NORTH = 'N';
    private static final char SOUTH = 'S';
    private static final char EAST = 'E';
    private static final char WEST = 'W';
    static final int LONGITUDE = 0;
    static final int LATITUDE = 1;
    static final int ALTITUDE = 2;
    private static final int PREFIX_FIELD = -1;
    public static final int DEGREES_FIELD = 0;
    public static final int MINUTES_FIELD = 1;
    public static final int SECONDS_FIELD = 2;
    public static final int HEMISPHERE_FIELD = 3;
    private static final char[] SYMBOLS = new char[]{'D', 'M', 'S'};
    private int width0 = 1;
    private int width1 = 2;
    private int width2 = 0;
    private int widthDecimal = 0;
    private String prefix = null;
    private String suffix0 = "\u00b0";
    private String suffix1 = "'";
    private String suffix2 = "\"";
    private boolean decimalSeparator = true;
    private final DecimalFormat numberFormat;
    private transient FieldPosition dummy = new FieldPosition(0);
    public static final RoundingMethod DEFAULT_ROUNDING_METHOD;
    private static RoundingMethod defaultRoundingMethod;
    private RoundingMethod instanceRoundingMethod = defaultRoundingMethod;

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.dummy = new FieldPosition(0);
    }

    private int getWidth(int index) {
        switch (index) {
            case 0: {
                return this.width0;
            }
            case 1: {
                return this.width1;
            }
            case 2: {
                return this.width2;
            }
        }
        return 0;
    }

    private void setWidth(int index, int width) {
        switch (index) {
            case 0: {
                this.width0 = width;
                width = 0;
            }
            case 1: {
                this.width1 = width;
                width = 0;
            }
            case 2: {
                this.width2 = width;
            }
        }
    }

    private String getSuffix(int index) {
        switch (index) {
            case -1: {
                return this.prefix;
            }
            case 0: {
                return this.suffix0;
            }
            case 1: {
                return this.suffix1;
            }
            case 2: {
                return this.suffix2;
            }
        }
        return null;
    }

    private void setSuffix(int index, String s) {
        switch (index) {
            case -1: {
                this.prefix = s;
                s = "\u00b0";
            }
            case 0: {
                this.suffix0 = s;
                s = "'";
            }
            case 1: {
                this.suffix1 = s;
                s = "\"";
            }
            case 2: {
                this.suffix2 = s;
            }
        }
    }

    public static AngleFormat getInstance(Locale locale) {
        return new AngleFormat("D\u00b0MM.m'", locale);
    }

    public static synchronized void setDefaultRoundingMethod(RoundingMethod method) {
        defaultRoundingMethod = method;
    }

    public static synchronized RoundingMethod getDefaultRoundingMethod() {
        return defaultRoundingMethod;
    }

    public synchronized void setRoundingMethod(RoundingMethod method) {
        this.instanceRoundingMethod = method;
    }

    public static synchronized RoundingMethod getRoundingMethod() {
        return defaultRoundingMethod;
    }

    private synchronized double doRounding(double value, int precision) {
        double eps;
        double scale = XMath.pow10((int)precision);
        double scaledValue = scale * (value + (eps = XMath.pow10((int)(-precision - 2))));
        if (Double.compare(scaledValue, 9.223372036854776E18) < 0) {
            RoundingMethod rm = this.instanceRoundingMethod;
            if (rm == RoundingMethod.ROUND_HALF_EVEN) {
                double d = scaledValue / 10.0;
                boolean even = (int)((d - (double)((int)d)) * 10.0) % 2 == 0;
                rm = even ? RoundingMethod.ROUND_HALF_DOWN : RoundingMethod.ROUND_HALF_UP;
            }
            switch (rm) {
                case ROUND_HALF_DOWN: {
                    long rounded = Math.round(scaledValue - 0.5);
                    return (double)rounded / scale;
                }
                case ROUND_HALF_UP: {
                    long rounded = Math.round(scaledValue);
                    return (double)rounded / scale;
                }
            }
        }
        Logger logger = Logger.getLogger(AngleFormat.class.getName());
        logger.log(Level.WARNING, String.format("Can't round the value %s to the given precision %d", String.valueOf(value), precision));
        return value;
    }

    private boolean isOverflow(double value, int field, boolean last) {
        boolean overflow = false;
        if (last) {
            value = this.doRounding(value, this.widthDecimal);
        }
        if (field != 0 && value == 60.0) {
            overflow = true;
        }
        if (field == 0 && value >= 360.0) {
            overflow = true;
        }
        return overflow;
    }

    public AngleFormat() {
        this("D\u00b0MM.m'");
    }

    public AngleFormat(String pattern) throws IllegalArgumentException {
        this(pattern, new DecimalFormatSymbols());
    }

    public AngleFormat(String pattern, Locale locale) throws IllegalArgumentException {
        this(pattern, new DecimalFormatSymbols(locale));
    }

    public AngleFormat(String pattern, DecimalFormatSymbols symbols) {
        this.numberFormat = new DecimalFormat("#0", symbols);
        this.applyPattern(pattern);
    }

    public synchronized void applyPattern(String pattern) throws IllegalArgumentException {
        this.widthDecimal = 0;
        this.decimalSeparator = true;
        int startPrefix = 0;
        int symbolIndex = 0;
        boolean parseFinished = false;
        int length = pattern.length();
        block4: for (int i = 0; i < length; ++i) {
            char c = pattern.charAt(i);
            char upperCaseC = Character.toUpperCase(c);
            for (int field = 0; field < SYMBOLS.length; ++field) {
                int w;
                if (upperCaseC != SYMBOLS[field]) continue;
                if (c == upperCaseC) {
                    ++symbolIndex;
                }
                if (field != symbolIndex - 1 || parseFinished) {
                    this.setWidth(0, 1);
                    this.setSuffix(-1, null);
                    this.widthDecimal = 0;
                    this.decimalSeparator = true;
                    throw new IllegalArgumentException(Errors.format((int)56, (Object)pattern));
                }
                if (c == upperCaseC) {
                    this.setSuffix(field - 1, i > startPrefix ? pattern.substring(startPrefix, i) : null);
                    w = 1;
                    while (++i < length && pattern.charAt(i) == c) {
                        ++w;
                    }
                    this.setWidth(field, w);
                } else {
                    switch (i - startPrefix) {
                        case 0: {
                            this.decimalSeparator = false;
                            break;
                        }
                        case 1: {
                            if (pattern.charAt(startPrefix) == '.') {
                                this.decimalSeparator = true;
                                break;
                            }
                        }
                        default: {
                            throw new IllegalArgumentException(Errors.format((int)56, (Object)pattern));
                        }
                    }
                    w = 1;
                    while (++i < length && pattern.charAt(i) == c) {
                        ++w;
                    }
                    this.widthDecimal = w;
                    parseFinished = true;
                }
                startPrefix = i--;
                continue block4;
            }
        }
        this.setSuffix(symbolIndex - 1, startPrefix < length ? pattern.substring(startPrefix) : null);
    }

    public synchronized String toPattern() {
        char symbol = '#';
        StringBuilder buffer = new StringBuilder();
        for (int field = 0; field <= SYMBOLS.length; ++field) {
            String previousSuffix = this.getSuffix(field - 1);
            int w = this.getWidth(field);
            if (w > 0) {
                if (previousSuffix != null) {
                    buffer.append(previousSuffix);
                }
                symbol = SYMBOLS[field];
                do {
                    buffer.append(symbol);
                } while (--w > 0);
                continue;
            }
            w = this.widthDecimal;
            if (w > 0) {
                if (this.decimalSeparator) {
                    buffer.append('.');
                }
                symbol = Character.toLowerCase(symbol);
                do {
                    buffer.append(symbol);
                } while (--w > 0);
            }
            if (previousSuffix == null) break;
            buffer.append(previousSuffix);
            break;
        }
        return buffer.toString();
    }

    public final String format(double angle) {
        return this.format(angle, new StringBuffer(), (FieldPosition)null).toString();
    }

    public synchronized StringBuffer format(double angle, StringBuffer toAppendTo, FieldPosition pos) {
        int field;
        if (Double.isNaN(angle) || Double.isInfinite(angle)) {
            return this.numberFormat.format(angle, toAppendTo, pos != null ? pos : new FieldPosition(0));
        }
        double degrees = angle;
        double minutes = Double.NaN;
        double secondes = Double.NaN;
        if (this.width1 != 0 && !Double.isNaN(angle)) {
            int tmp = (int)degrees;
            minutes = Math.abs(degrees - (double)tmp) * 60.0;
            degrees = tmp;
            if (minutes < 0.0 || minutes > 60.0) {
                throw new IllegalArgumentException(Errors.format((int)4, (Object)angle));
            }
            if (this.width2 != 0) {
                tmp = (int)minutes;
                secondes = (minutes - (double)tmp) * 60.0;
                minutes = tmp;
                if (secondes < 0.0 || secondes > 60.0) {
                    throw new IllegalArgumentException(Errors.format((int)4, (Object)angle));
                }
                tmp = (int)(secondes / 60.0);
                secondes -= (double)(60 * tmp);
                minutes += (double)tmp;
            }
            tmp = (int)(minutes / 60.0);
            minutes -= (double)(60 * tmp);
            degrees += (double)tmp;
        }
        if (this.prefix != null) {
            toAppendTo.append(this.prefix);
        }
        if (pos != null) {
            field = pos.getField();
            pos.setBeginIndex(0);
            pos.setEndIndex(0);
        } else {
            field = -1;
        }
        if (!Double.isNaN(secondes) && this.isOverflow(secondes, 2, true)) {
            secondes = 0.0;
            minutes += 1.0;
        }
        if (!Double.isNaN(minutes) && this.isOverflow(minutes, 1, this.width2 == 0)) {
            minutes = 0.0;
            degrees += 1.0;
        }
        if (this.isOverflow(degrees, 0, this.width1 == 0)) {
            degrees -= 360.0;
        }
        toAppendTo = this.formatField(degrees, toAppendTo, field == 0 ? pos : null, this.width0, this.width1 == 0, this.suffix0);
        if (!Double.isNaN(minutes)) {
            toAppendTo = this.formatField(minutes, toAppendTo, field == 1 ? pos : null, this.width1, this.width2 == 0, this.suffix1);
        }
        if (!Double.isNaN(secondes)) {
            toAppendTo = this.formatField(secondes, toAppendTo, field == 2 ? pos : null, this.width2, true, this.suffix2);
        }
        return toAppendTo;
    }

    private StringBuffer formatField(double value, StringBuffer toAppendTo, FieldPosition pos, int w, boolean last, String s) {
        int startPosition = toAppendTo.length();
        if (!last) {
            this.numberFormat.setMinimumIntegerDigits(w);
            this.numberFormat.setMaximumFractionDigits(0);
            toAppendTo = this.numberFormat.format(value, toAppendTo, this.dummy);
        } else {
            value = this.doRounding(value, this.widthDecimal);
            if (this.decimalSeparator) {
                this.numberFormat.setMinimumIntegerDigits(w);
                this.numberFormat.setMinimumFractionDigits(this.widthDecimal);
                this.numberFormat.setMaximumFractionDigits(this.widthDecimal);
                toAppendTo = this.numberFormat.format(value, toAppendTo, this.dummy);
            } else {
                this.numberFormat.setMaximumFractionDigits(0);
                this.numberFormat.setMinimumIntegerDigits(w + this.widthDecimal);
                toAppendTo = this.numberFormat.format(value *= XMath.pow10((int)this.widthDecimal), toAppendTo, this.dummy);
            }
        }
        if (s != null) {
            toAppendTo.append(s);
        }
        if (pos != null) {
            pos.setBeginIndex(startPosition);
            pos.setEndIndex(toAppendTo.length() - 1);
        }
        return toAppendTo;
    }

    @Override
    public synchronized StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) throws IllegalArgumentException {
        if (obj instanceof Latitude) {
            return this.format(((Latitude)obj).degrees(), toAppendTo, pos, 'N', 'S');
        }
        if (obj instanceof Longitude) {
            return this.format(((Longitude)obj).degrees(), toAppendTo, pos, 'E', 'W');
        }
        if (obj instanceof Angle) {
            return this.format(((Angle)obj).degrees(), toAppendTo, pos);
        }
        if (obj instanceof Number) {
            this.numberFormat.setMinimumIntegerDigits(1);
            this.numberFormat.setMinimumFractionDigits(0);
            this.numberFormat.setMaximumFractionDigits(2);
            return this.numberFormat.format(obj, toAppendTo, pos != null ? pos : this.dummy);
        }
        throw new IllegalArgumentException(Errors.format((int)119, (Object)Classes.getClass((Object)obj)));
    }

    synchronized StringBuffer format(double number, int type, StringBuffer toAppendTo, FieldPosition pos) {
        switch (type) {
            default: {
                throw new IllegalArgumentException(Integer.toString(type));
            }
            case 1: {
                return this.format(number, toAppendTo, pos, 'N', 'S');
            }
            case 0: {
                return this.format(number, toAppendTo, pos, 'E', 'W');
            }
            case 2: 
        }
        this.numberFormat.setMinimumIntegerDigits(1);
        this.numberFormat.setMinimumFractionDigits(0);
        this.numberFormat.setMaximumFractionDigits(2);
        return this.numberFormat.format(number, toAppendTo, pos != null ? pos : this.dummy);
    }

    private StringBuffer format(double angle, StringBuffer toAppendTo, FieldPosition pos, char north, char south) {
        toAppendTo = this.format(Math.abs(angle), toAppendTo, pos);
        int start = toAppendTo.length();
        toAppendTo.append(angle < 0.0 ? south : north);
        if (pos != null && pos.getField() == 3) {
            pos.setBeginIndex(start);
            pos.setEndIndex(toAppendTo.length() - 1);
        }
        return toAppendTo;
    }

    private int skipSuffix(String source, ParsePosition pos, int field) {
        char c;
        int length = source.length();
        int start = pos.getIndex();
        for (int j = SYMBOLS.length; j >= 0; --j) {
            int index = start;
            String toSkip = this.getSuffix(field);
            if (toSkip != null) {
                int toSkipLength = toSkip.length();
                do {
                    if (!source.regionMatches(index, toSkip, 0, toSkipLength)) continue;
                    pos.setIndex(index + toSkipLength);
                    return field;
                } while (index < length && Character.isSpaceChar(source.charAt(index++)));
            }
            if (++field < SYMBOLS.length) continue;
            field = -1;
        }
        do {
            if (start < length) continue;
            return SYMBOLS.length;
        } while (Character.isSpaceChar(c = source.charAt(start++)));
        switch (c) {
            case '\u00b0': {
                pos.setIndex(start);
                return 0;
            }
            case '\'': {
                pos.setIndex(start);
                return 1;
            }
            case '\"': {
                pos.setIndex(start);
                return 2;
            }
        }
        return SYMBOLS.length;
    }

    public Angle parse(String source, ParsePosition pos) {
        return this.parse(source, pos, false);
    }

    private synchronized Angle parse(String source, ParsePosition pos, boolean spaceAsSeparator) {
        double degrees = Double.NaN;
        double minutes = Double.NaN;
        double secondes = Double.NaN;
        int length = source.length();
        int indexStart = pos.getIndex();
        int index = this.skipSuffix(source, pos, -1);
        if (index >= 0 && index < SYMBOLS.length) {
            pos.setErrorIndex(indexStart);
            pos.setIndex(indexStart);
            return null;
        }
        for (index = pos.getIndex(); index < length && Character.isSpaceChar(source.charAt(index)); ++index) {
        }
        pos.setIndex(index);
        Number fieldObject = this.numberFormat.parse(source, pos);
        if (fieldObject == null) {
            pos.setIndex(indexStart);
            if (pos.getErrorIndex() < indexStart) {
                pos.setErrorIndex(index);
            }
            return null;
        }
        degrees = fieldObject.doubleValue();
        int indexEndField = pos.getIndex();
        boolean swapDM = true;
        block0 : switch (this.skipSuffix(source, pos, 0)) {
            case -1: {
                pos.setIndex(indexEndField);
                break;
            }
            case 2: {
                secondes = degrees;
                degrees = Double.NaN;
                break;
            }
            default: {
                if (this.width1 == 0 || !spaceAsSeparator) break;
            }
            case 0: {
                int indexStartField = index = pos.getIndex();
                while (index < length && Character.isSpaceChar(source.charAt(index))) {
                    ++index;
                }
                if (!spaceAsSeparator && index != indexStartField) break;
                pos.setIndex(index);
                fieldObject = this.numberFormat.parse(source, pos);
                if (fieldObject == null) {
                    pos.setIndex(indexStartField);
                    break;
                }
                indexEndField = pos.getIndex();
                minutes = fieldObject.doubleValue();
                switch (this.skipSuffix(source, pos, this.width1 != 0 ? 1 : -1)) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        secondes = minutes;
                        minutes = Double.NaN;
                        break block0;
                    }
                    default: {
                        if (this.width1 != 0) break;
                    }
                    case 0: {
                        pos.setIndex(indexStartField);
                        minutes = Double.NaN;
                        break block0;
                    }
                    case -1: {
                        pos.setIndex(indexEndField);
                        break block0;
                    }
                }
                swapDM = false;
            }
            case 1: {
                if (swapDM) {
                    minutes = degrees;
                    degrees = Double.NaN;
                }
                int indexStartField = index = pos.getIndex();
                while (index < length && Character.isSpaceChar(source.charAt(index))) {
                    ++index;
                }
                if (!spaceAsSeparator && index != indexStartField) break;
                pos.setIndex(index);
                fieldObject = this.numberFormat.parse(source, pos);
                if (fieldObject == null) {
                    pos.setIndex(indexStartField);
                    break;
                }
                indexEndField = pos.getIndex();
                secondes = fieldObject.doubleValue();
                switch (this.skipSuffix(source, pos, this.width2 != 0 ? 1 : -1)) {
                    case 2: {
                        break block0;
                    }
                    default: {
                        if (this.width2 != 0) break block0;
                    }
                    case 0: 
                    case 1: {
                        pos.setIndex(indexStartField);
                        secondes = Double.NaN;
                        break block0;
                    }
                    case -1: {
                        pos.setIndex(indexEndField);
                        break block0;
                    }
                }
            }
        }
        if (minutes < 0.0) {
            secondes = -secondes;
        }
        if (degrees < 0.0) {
            minutes = -minutes;
            secondes = -secondes;
        }
        if (!this.decimalSeparator) {
            double facteur = XMath.pow10((int)this.widthDecimal);
            if (this.width2 != 0) {
                if (this.suffix1 == null && Double.isNaN(secondes)) {
                    if (this.suffix0 == null && Double.isNaN(minutes)) {
                        degrees /= facteur;
                    } else {
                        minutes /= facteur;
                    }
                } else {
                    secondes /= facteur;
                }
            } else if (Double.isNaN(secondes)) {
                if (this.width1 != 0) {
                    if (this.suffix0 == null && Double.isNaN(minutes)) {
                        degrees /= facteur;
                    } else {
                        minutes /= facteur;
                    }
                } else if (Double.isNaN(minutes)) {
                    degrees /= facteur;
                }
            }
        }
        if (this.suffix1 == null && this.width2 != 0 && Double.isNaN(secondes)) {
            double facteur = XMath.pow10((int)this.width2);
            if (this.suffix0 == null && this.width1 != 0 && Double.isNaN(minutes)) {
                secondes = degrees;
                minutes = (int)(degrees / facteur);
                secondes -= minutes * facteur;
                facteur = XMath.pow10((int)this.width1);
                degrees = (int)(minutes / facteur);
                minutes -= degrees * facteur;
            } else {
                secondes = minutes;
                minutes = (int)(minutes / facteur);
                secondes -= minutes * facteur;
            }
        } else if (this.suffix0 == null && this.width1 != 0 && Double.isNaN(minutes)) {
            double facteur = XMath.pow10((int)this.width1);
            minutes = degrees;
            degrees = (int)(degrees / facteur);
            minutes -= degrees * facteur;
        }
        pos.setErrorIndex(-1);
        if (Double.isNaN(degrees)) {
            degrees = 0.0;
        }
        if (!Double.isNaN(minutes)) {
            degrees += minutes / 60.0;
        }
        if (!Double.isNaN(secondes)) {
            degrees += secondes / 3600.0;
        }
        for (int index2 = pos.getIndex(); index2 < length; ++index2) {
            char c = source.charAt(index2);
            switch (Character.toUpperCase(c)) {
                case 'N': {
                    pos.setIndex(index2 + 1);
                    return new Latitude(degrees);
                }
                case 'S': {
                    pos.setIndex(index2 + 1);
                    return new Latitude(-degrees);
                }
                case 'E': {
                    pos.setIndex(index2 + 1);
                    return new Longitude(degrees);
                }
                case 'W': {
                    pos.setIndex(index2 + 1);
                    return new Longitude(-degrees);
                }
            }
            if (!Character.isSpaceChar(c)) break;
        }
        return new Angle(degrees);
    }

    public Angle parse(String source) throws ParseException {
        int origin;
        ParsePosition pos = new ParsePosition(0);
        Angle angle = this.parse(source, pos, true);
        int length = source.length();
        for (int index = origin = pos.getIndex(); index < length; ++index) {
            if (Character.isWhitespace(source.charAt(index))) continue;
            index = Math.max(origin, pos.getErrorIndex());
            throw new ParseException(LoggedFormat.formatUnparsable((String)source, (int)0, (int)index, null), index);
        }
        return angle;
    }

    @Override
    public Angle parseObject(String source, ParsePosition pos) {
        return this.parse(source, pos);
    }

    @Override
    public Angle parseObject(String source) throws ParseException {
        return this.parse(source);
    }

    final Number parseNumber(String source, ParsePosition pos) {
        return this.numberFormat.parse(source, pos);
    }

    public synchronized int hashCode() {
        int c = 78236951;
        if (this.decimalSeparator) {
            c ^= 0xFF;
        }
        if (this.prefix != null) {
            c ^= this.prefix.hashCode();
        }
        if (this.suffix0 != null) {
            c = c * 37 + this.suffix0.hashCode();
        }
        if (this.suffix1 != null) {
            c ^= c * 37 + this.suffix1.hashCode();
        }
        if (this.suffix2 != null) {
            c ^= c * 37 + this.suffix2.hashCode();
        }
        return c ^ ((this.width0 << 8 ^ this.width1) << 8 ^ this.width2) << 8 ^ this.widthDecimal;
    }

    public synchronized boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && this.getClass().equals(obj.getClass())) {
            AngleFormat cast = (AngleFormat)obj;
            return this.width0 == cast.width0 && this.width1 == cast.width1 && this.width2 == cast.width2 && this.widthDecimal == cast.widthDecimal && this.decimalSeparator == cast.decimalSeparator && Utilities.equals((Object)this.prefix, (Object)cast.prefix) && Utilities.equals((Object)this.suffix0, (Object)cast.suffix0) && Utilities.equals((Object)this.suffix1, (Object)cast.suffix1) && Utilities.equals((Object)this.suffix2, (Object)cast.suffix2) && Utilities.equals((Object)this.numberFormat.getDecimalFormatSymbols(), (Object)cast.numberFormat.getDecimalFormatSymbols());
        }
        return false;
    }

    public String toString() {
        return Classes.getShortClassName((Object)this) + '[' + this.toPattern() + ']';
    }

    static {
        defaultRoundingMethod = DEFAULT_ROUNDING_METHOD = RoundingMethod.ROUND_HALF_EVEN;
    }

    public static enum RoundingMethod {
        ROUND_HALF_EVEN,
        ROUND_HALF_UP,
        ROUND_HALF_DOWN;

    }
}

