/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.roleMaptool.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.roleMaptool.entity.RoleMaptool;
import org.jeecg.modules.roleMaptool.mapper.RoleMaptoolMapper;
import org.jeecg.modules.roleMaptool.service.IRoleMaptoolService;
import org.springframework.stereotype.Service;

@Service
public class RoleMaptoolServiceImpl
extends ServiceImpl<RoleMaptoolMapper, RoleMaptool>
implements IRoleMaptoolService {
    @Override
    public void saveRolePermission(String roleId, String maptoolIds) {
        String[] arr;
        LambdaQueryWrapper query = (LambdaQueryWrapper)new QueryWrapper().lambda().eq(RoleMaptool::getRoleId, (Object)roleId);
        this.remove((Wrapper)query);
        ArrayList<RoleMaptool> list = new ArrayList<RoleMaptool>();
        for (String maptoolId : arr = maptoolIds.split(",")) {
            if (!oConvertUtils.isNotEmpty((Object)maptoolId)) continue;
            RoleMaptool roleMaptool = new RoleMaptool();
            roleMaptool.setRoleId(roleId);
            roleMaptool.setMaptoolId(maptoolId);
            this.save(roleMaptool);
            list.add(roleMaptool);
        }
        this.saveBatch(list);
    }

    @Override
    public void saveRolePermission(String roleId, String maptoolIds, String lastMaptoolIds) {
        List<String> delete;
        List<String> addList = this.getDiff(lastMaptoolIds, maptoolIds);
        if (addList != null && addList.size() > 0) {
            ArrayList<RoleMaptool> list = new ArrayList<RoleMaptool>();
            for (String maptoolId : addList) {
                if (!oConvertUtils.isNotEmpty((Object)maptoolId)) continue;
                RoleMaptool roleMaptool = new RoleMaptool();
                roleMaptool.setRoleId(roleId);
                roleMaptool.setMaptoolId(maptoolId);
                list.add(roleMaptool);
            }
            this.saveBatch(list);
        }
        if ((delete = this.getDiff(maptoolIds, lastMaptoolIds)) != null && delete.size() > 0) {
            for (String catalogId : delete) {
                this.remove((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(RoleMaptool::getRoleId, (Object)roleId)).eq(RoleMaptool::getMaptoolId, (Object)catalogId));
            }
        }
    }

    private List<String> getDiff(String main, String diff) {
        if (oConvertUtils.isEmpty((Object)diff)) {
            return null;
        }
        if (oConvertUtils.isEmpty((Object)main)) {
            return Arrays.asList(diff.split(","));
        }
        String[] mainArr = main.split(",");
        String[] diffArr = diff.split(",");
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (String string : mainArr) {
            map.put(string, 1);
        }
        ArrayList<String> res = new ArrayList<String>();
        for (String key : diffArr) {
            if (!oConvertUtils.isNotEmpty((Object)key) || map.containsKey(key)) continue;
            res.add(key);
        }
        return res;
    }
}

