/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.dingtalk.api.base;

import com.alibaba.fastjson.JSONObject;
import com.jeecg.dingtalk.api.core.util.ApiUrls;
import com.jeecg.dingtalk.api.core.util.HttpUtil;
import com.jeecg.dingtalk.api.core.vo.AccessToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdtBaseAPI {
    private static final Logger logger = LoggerFactory.getLogger(JdtBaseAPI.class);

    public static AccessToken getAccessToken(String appKey, String appSecret) {
        AccessToken accessToken = null;
        String url = ApiUrls.get("https://oapi.dingtalk.com/gettoken?appkey=%s&appsecret=%s", appKey, appSecret);
        JSONObject response = HttpUtil.sendGet(url);
        if (response != null) {
            try {
                String access_token = response.getString("access_token");
                int expires_in = response.getIntValue("expires_in");
                accessToken = new AccessToken(access_token, expires_in);
                logger.info("[ACCESS_TOKEN] \u83b7\u53d6ACCESS_TOKEN\u6210\u529f:{}", new Object[]{accessToken});
            }
            catch (Exception e) {
                int errcode = response.getIntValue("errcode");
                String errmsg = response.getString("errmsg");
                logger.info("[ACCESS_TOKEN] \u83b7\u53d6ACCESS_TOKEN\u5931\u8d25 errcode:{} errmsg:{}", new Object[]{errcode, errmsg});
            }
        }
        return accessToken;
    }
}

