/*
 * Decompiled with CFR 0.152.
 */
package com.xkcoding.justauth.autoconfigure;

import com.xkcoding.justauth.AuthRequestFactory;
import com.xkcoding.justauth.autoconfigure.JustAuthProperties;
import com.xkcoding.justauth.autoconfigure.JustAuthStateCacheConfiguration;
import me.zhyd.oauth.cache.AuthStateCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@EnableConfigurationProperties(value={JustAuthProperties.class})
public class JustAuthAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(JustAuthAutoConfiguration.class);

    @Bean
    @ConditionalOnProperty(prefix="justauth", value={"enabled"}, havingValue="true", matchIfMissing=true)
    public AuthRequestFactory authRequestFactory(JustAuthProperties properties, AuthStateCache authStateCache) {
        return new AuthRequestFactory(properties, authStateCache);
    }

    @Configuration
    @Import(value={JustAuthStateCacheConfiguration.Default.class, JustAuthStateCacheConfiguration.Redis.class, JustAuthStateCacheConfiguration.Custom.class})
    protected static class AuthStateCacheAutoConfiguration {
        protected AuthStateCacheAutoConfiguration() {
        }
    }
}

