/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.http.MediaType;
import springfox.documentation.builders.RepresentationBuilder;
import springfox.documentation.service.ContentSpecification;
import springfox.documentation.service.Representation;

public class ContentSpecificationBuilder {
    private final Map<MediaType, RepresentationBuilder> representations = new HashMap<MediaType, RepresentationBuilder>();
    private boolean requestBody = false;

    private ContentSpecificationBuilder representations(Collection<Representation> representations) {
        this.representations.putAll(representations.stream().collect(Collectors.toMap(Representation::getMediaType, r -> this.representationBuilderFor(r.getMediaType()).copyOf((Representation)r))));
        return this;
    }

    private RepresentationBuilder representationBuilderFor(MediaType mediaType) {
        return this.representations.computeIfAbsent(mediaType, m -> new RepresentationBuilder().mediaType((MediaType)m));
    }

    public Function<Consumer<RepresentationBuilder>, ContentSpecificationBuilder> representation(MediaType mediaType) {
        return content -> {
            content.accept(this.representationBuilderFor(mediaType));
            return this;
        };
    }

    public ContentSpecificationBuilder requestBody(boolean requestBody) {
        this.requestBody = requestBody;
        return this;
    }

    ContentSpecification build() {
        return new ContentSpecification(this.requestBody, this.representations.values().stream().map(RepresentationBuilder::build).collect(Collectors.toSet()));
    }

    public ContentSpecificationBuilder copyOf(ContentSpecification contentParameter) {
        if (contentParameter != null) {
            this.representations(contentParameter.getRepresentations()).requestBody(contentParameter.isRequestBody());
        }
        return this;
    }
}

