/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.poi.excel.export.base;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.jeecgframework.poi.excel.entity.enmus.ExcelType;
import org.jeecgframework.poi.excel.entity.params.ExcelExportEntity;
import org.jeecgframework.poi.excel.export.base.ExportBase;
import org.jeecgframework.poi.excel.export.styler.IExcelExportStyler;
import org.jeecgframework.poi.exception.excel.ExcelExportException;
import org.jeecgframework.poi.exception.excel.enums.ExcelExportEnum;
import org.jeecgframework.poi.util.MyX509TrustManager;
import org.jeecgframework.poi.util.PoiMergeCellUtil;
import org.jeecgframework.poi.util.PoiPublicUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExcelExportBase
extends ExportBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelExportBase.class);
    private int currentIndex = 0;
    protected ExcelType type = ExcelType.HSSF;
    private Map<Integer, Double> statistics = new HashMap<Integer, Double>();
    private static final DecimalFormat DOUBLE_FORMAT = new DecimalFormat("######0.00");
    private IExcelExportStyler excelExportStyler;

    public int createCells(Drawing patriarch, int index, Object t, List<ExcelExportEntity> excelParams, Sheet sheet, Workbook workbook, short rowHeight) throws Exception {
        ExcelExportEntity entity;
        int k;
        Row row = sheet.createRow(index);
        row.setHeight(rowHeight);
        int maxHeight = 1;
        int cellNum = 0;
        int indexKey = this.createIndexCell(row, index, excelParams.get(0));
        cellNum += indexKey;
        int paramSize = excelParams.size();
        for (k = indexKey; k < paramSize; ++k) {
            entity = excelParams.get(k);
            if (entity.isSubColumn()) continue;
            if (entity.isMergeColumn()) {
                HashMap<String, Object> subColumnMap = new HashMap<String, Object>();
                List<String> mapKeys = entity.getSubColumnList();
                for (String subKey : mapKeys) {
                    Object subKeyValue = null;
                    subKeyValue = t instanceof Map ? ((Map)t).get(subKey) : PoiPublicUtil.getParamsValue(subKey, t);
                    subColumnMap.put(subKey, subKeyValue);
                }
                this.createListCells(patriarch, index, cellNum, subColumnMap, entity.getList(), sheet, workbook);
                cellNum += entity.getSubColumnList().size();
                continue;
            }
            if (entity.getList() != null) {
                Collection<?> list = this.getListCellValue(entity, t);
                int listC = 0;
                for (String obj : list) {
                    this.createListCells(patriarch, index + listC, cellNum, obj, entity.getList(), sheet, workbook);
                    ++listC;
                }
                cellNum += entity.getList().size();
                if (list == null || list.size() <= maxHeight) continue;
                maxHeight = list.size();
                continue;
            }
            Object value = this.getCellValue(entity, t);
            if (entity.getType() == 1) {
                this.createStringCell(row, cellNum++, value == null ? "" : value.toString(), index % 2 == 0 ? this.getStyles(false, entity) : this.getStyles(true, entity), entity);
                continue;
            }
            if (entity.getType() == 4) {
                this.createNumericCell(row, cellNum++, value == null ? "" : value.toString(), index % 2 == 0 ? this.getStyles(false, entity) : this.getStyles(true, entity), entity);
                continue;
            }
            this.createImageCell(patriarch, entity, row, cellNum++, value == null ? "" : value.toString(), t);
        }
        cellNum = 0;
        paramSize = excelParams.size();
        for (k = indexKey; k < paramSize; ++k) {
            entity = excelParams.get(k);
            if (entity.getList() != null) {
                cellNum += entity.getList().size();
                continue;
            }
            if (!entity.isNeedMerge()) continue;
            for (int i = index + 1; i < index + maxHeight; ++i) {
                sheet.getRow(i).createCell(cellNum);
                sheet.getRow(i).getCell(cellNum).setCellStyle(this.getStyles(false, entity));
            }
            try {
                sheet.addMergedRegion(new CellRangeAddress(index, index + maxHeight - 1, cellNum, cellNum));
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("\u5408\u5e76\u5355\u5143\u683c\u9519\u8bef\u65e5\u5fd7\uff1a" + e.getMessage());
                e.fillInStackTrace();
            }
            ++cellNum;
        }
        return maxHeight;
    }

    private byte[] getImageDataByHttps(String imagePath) throws Exception {
        SSLContext sslcontext = SSLContext.getInstance("SSL", "SunJSSE");
        sslcontext.init(null, new TrustManager[]{new MyX509TrustManager()}, new SecureRandom());
        URL url = new URL(imagePath);
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        conn.setSSLSocketFactory(sslcontext.getSocketFactory());
        conn.setRequestMethod("GET");
        conn.setConnectTimeout(5000);
        InputStream inStream = conn.getInputStream();
        byte[] value = this.readInputStream(inStream);
        return value;
    }

    private byte[] getImageDataByHttp(String imagePath) throws Exception {
        URL url = new URL(imagePath);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setConnectTimeout(5000);
        InputStream inStream = conn.getInputStream();
        byte[] value = this.readInputStream(inStream);
        return value;
    }

    public void createImageCell(Drawing patriarch, ExcelExportEntity entity, Row row, int i, String imagePath, Object obj) throws Exception {
        byte[] value;
        Object anchor;
        block16: {
            row.setHeight((short)(50.0 * entity.getHeight()));
            row.createCell(i);
            anchor = this.type.equals((Object)ExcelType.HSSF) ? new HSSFClientAnchor(0, 0, 0, 0, (short)i, row.getRowNum(), (short)(i + 1), row.getRowNum() + 1) : new XSSFClientAnchor(0, 0, 0, 0, (int)((short)i), row.getRowNum(), (int)((short)(i + 1)), row.getRowNum() + 1);
            if (StringUtils.isEmpty((CharSequence)imagePath)) {
                return;
            }
            int imageType = entity.getExportImageType();
            value = null;
            if (imageType == 2) {
                value = (byte[])(entity.getMethods() != null ? this.getFieldBySomeMethod(entity.getMethods(), obj) : entity.getMethod().invoke(obj, new Object[0]));
            } else if (imageType == 4 || imagePath.startsWith("http")) {
                try {
                    if (imagePath.indexOf(",") != -1) {
                        if (imagePath.startsWith(",")) {
                            imagePath = imagePath.substring(1);
                        }
                        String[] images = imagePath.split(",");
                        imagePath = images[0];
                    }
                    if (imagePath.startsWith("https")) {
                        value = this.getImageDataByHttps(imagePath);
                        break block16;
                    }
                    value = this.getImageDataByHttp(imagePath);
                }
                catch (Exception exception) {
                    LOGGER.warn(exception.getMessage());
                }
            } else {
                ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
                String path = null;
                if (imageType == 1) {
                    path = PoiPublicUtil.getWebRootPath(imagePath);
                    LOGGER.debug("--- createImageCell getWebRootPath ----filePath--- " + path);
                    path = path.replace("WEB-INF/classes/", "");
                    path = path.replace("file:/", "");
                } else if (imageType == 3) {
                    path = StringUtils.isNotBlank((CharSequence)entity.getImageBasePath()) ? (!entity.getImageBasePath().endsWith(File.separator) && !imagePath.startsWith(File.separator) ? entity.getImageBasePath() + File.separator + imagePath : entity.getImageBasePath() + imagePath) : imagePath;
                }
                try {
                    BufferedImage bufferImg = ImageIO.read(new File(path));
                    ImageIO.write((RenderedImage)bufferImg, imagePath.substring(imagePath.lastIndexOf(".") + 1, imagePath.length()), byteArrayOut);
                    value = byteArrayOut.toByteArray();
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage());
                }
            }
        }
        if (value != null) {
            patriarch.createPicture((ClientAnchor)anchor, row.getSheet().getWorkbook().addPicture(value, this.getImageType(value)));
        }
    }

    private byte[] readInputStream(InputStream inStream) throws Exception {
        if (inStream == null) {
            return null;
        }
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int len = 0;
        while ((len = inStream.read(buffer)) != -1) {
            outStream.write(buffer, 0, len);
        }
        inStream.close();
        return outStream.toByteArray();
    }

    private int createIndexCell(Row row, int index, ExcelExportEntity excelExportEntity) {
        if (excelExportEntity.getName().equals("\u5e8f\u53f7") && "isAddIndex".equals(excelExportEntity.getFormat())) {
            this.createStringCell(row, 0, this.currentIndex + "", index % 2 == 0 ? this.getStyles(false, null) : this.getStyles(true, null), null);
            ++this.currentIndex;
            return 1;
        }
        return 0;
    }

    public void createListCells(Drawing patriarch, int index, int cellNum, Object obj, List<ExcelExportEntity> excelParams, Sheet sheet, Workbook workbook) throws Exception {
        Row row;
        if (sheet.getRow(index) == null) {
            row = sheet.createRow(index);
            row.setHeight(this.getRowHeight(excelParams));
        } else {
            row = sheet.getRow(index);
        }
        int paramSize = excelParams.size();
        for (int k = 0; k < paramSize; ++k) {
            ExcelExportEntity entity = excelParams.get(k);
            Object value = this.getCellValue(entity, obj);
            if (entity.getType() == 1) {
                this.createStringCell(row, cellNum++, value == null ? "" : value.toString(), row.getRowNum() % 2 == 0 ? this.getStyles(false, entity) : this.getStyles(true, entity), entity);
                continue;
            }
            if (entity.getType() == 4) {
                this.createNumericCell(row, cellNum++, value == null ? "" : value.toString(), index % 2 == 0 ? this.getStyles(false, entity) : this.getStyles(true, entity), entity);
                continue;
            }
            this.createImageCell(patriarch, entity, row, cellNum++, value == null ? "" : value.toString(), obj);
        }
    }

    public void createNumericCell(Row row, int index, String text, CellStyle style, ExcelExportEntity entity) {
        Cell cell = row.createCell(index);
        if (StringUtils.isEmpty((CharSequence)text)) {
            cell.setCellValue("");
            cell.setCellType(CellType.BLANK);
        } else {
            cell.setCellValue(Double.parseDouble(text));
            cell.setCellType(CellType.NUMERIC);
        }
        if (style != null) {
            cell.setCellStyle(style);
        }
        this.addStatisticsData(index, text, entity);
    }

    public void createStringCell(Row row, int index, String text, CellStyle style, ExcelExportEntity entity) {
        Cell cell = row.createCell(index);
        if (style != null && style.getDataFormat() > 0 && style.getDataFormat() < 12) {
            cell.setCellValue(Double.parseDouble(text));
            cell.setCellType(CellType.NUMERIC);
        } else {
            Object Rtext = this.type.equals((Object)ExcelType.HSSF) ? new HSSFRichTextString(text) : new XSSFRichTextString(text);
            cell.setCellValue((RichTextString)Rtext);
        }
        if (style != null) {
            cell.setCellStyle(style);
        }
        this.addStatisticsData(index, text, entity);
    }

    public void addStatisticsRow(CellStyle styles, Sheet sheet) {
        if (this.statistics.size() > 0) {
            Row row = sheet.createRow(sheet.getLastRowNum() + 1);
            Set<Integer> keys = this.statistics.keySet();
            this.createStringCell(row, 0, "\u5408\u8ba1", styles, null);
            for (Integer key : keys) {
                this.createStringCell(row, key, DOUBLE_FORMAT.format(this.statistics.get(key)), styles, null);
            }
            this.statistics.clear();
        }
    }

    private void addStatisticsData(Integer index, String text, ExcelExportEntity entity) {
        if (entity != null && entity.isStatistics()) {
            Double temp = 0.0;
            if (!this.statistics.containsKey(index)) {
                this.statistics.put(index, temp);
            }
            try {
                temp = Double.valueOf(text);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.statistics.put(index, this.statistics.get(index) + temp);
        }
    }

    public int getFieldWidth(List<ExcelExportEntity> excelParams) {
        int length = -1;
        for (ExcelExportEntity entity : excelParams) {
            if (entity.getGroupName() != null) continue;
            if (entity.getSubColumnList() != null && entity.getSubColumnList().size() > 0) {
                length += entity.getSubColumnList().size();
                continue;
            }
            length += entity.getList() != null ? entity.getList().size() : 1;
        }
        return length;
    }

    public int getImageType(byte[] value) {
        String type = PoiPublicUtil.getFileExtendName(value);
        if (type.equalsIgnoreCase("JPG")) {
            return 5;
        }
        if (type.equalsIgnoreCase("PNG")) {
            return 6;
        }
        return 5;
    }

    private Map<Integer, int[]> getMergeDataMap(List<ExcelExportEntity> excelParams) {
        HashMap<Integer, int[]> mergeMap = new HashMap<Integer, int[]>();
        int i = 0;
        for (ExcelExportEntity entity : excelParams) {
            if (entity.isMergeVertical()) {
                mergeMap.put(i, entity.getMergeRely());
            }
            if (entity.getList() != null) {
                for (ExcelExportEntity inner : entity.getList()) {
                    if (inner.isMergeVertical()) {
                        mergeMap.put(i, inner.getMergeRely());
                    }
                    ++i;
                }
                continue;
            }
            ++i;
        }
        return mergeMap;
    }

    public CellStyle getStyles(boolean needOne, ExcelExportEntity entity) {
        return this.excelExportStyler.getStyles(needOne, entity);
    }

    public void mergeCells(Sheet sheet, List<ExcelExportEntity> excelParams, int titleHeight) {
        Map<Integer, int[]> mergeMap = this.getMergeDataMap(excelParams);
        PoiMergeCellUtil.mergeCells(sheet, mergeMap, titleHeight);
    }

    public void setCellWith(List<ExcelExportEntity> excelParams, Sheet sheet) {
        int index = 0;
        for (int i = 0; i < excelParams.size(); ++i) {
            if (excelParams.get(i).getList() != null) {
                List<ExcelExportEntity> list = excelParams.get(i).getList();
                for (int j = 0; j < list.size(); ++j) {
                    sheet.setColumnWidth(index, (int)(256.0 * list.get(j).getWidth()));
                    ++index;
                }
                continue;
            }
            sheet.setColumnWidth(index, (int)(256.0 * excelParams.get(i).getWidth()));
            ++index;
        }
    }

    public void setColumnHidden(List<ExcelExportEntity> excelParams, Sheet sheet) {
        int index = 0;
        for (int i = 0; i < excelParams.size(); ++i) {
            if (excelParams.get(i).getList() != null) {
                List<ExcelExportEntity> list = excelParams.get(i).getList();
                for (int j = 0; j < list.size(); ++j) {
                    sheet.setColumnHidden(index, list.get(j).isColumnHidden());
                    ++index;
                }
                continue;
            }
            sheet.setColumnHidden(index, excelParams.get(i).isColumnHidden());
            ++index;
        }
    }

    public void setCurrentIndex(int currentIndex) {
        this.currentIndex = currentIndex;
    }

    public void setExcelExportStyler(IExcelExportStyler excelExportStyler) {
        this.excelExportStyler = excelExportStyler;
    }

    public IExcelExportStyler getExcelExportStyler() {
        return this.excelExportStyler;
    }

    public int[] createCells(Drawing patriarch, int index, Object t, List<ExcelExportEntity> excelParams, Sheet sheet, Workbook workbook, short rowHeight, int cellNum) {
        try {
            ExcelExportEntity entity;
            int k;
            Row row;
            Row row2 = row = sheet.getRow(index) == null ? sheet.createRow(index) : sheet.getRow(index);
            if (rowHeight != -1) {
                row.setHeight(rowHeight);
            }
            int maxHeight = 1;
            int listMaxHeight = 1;
            int margeCellNum = cellNum;
            int indexKey = 0;
            if (excelParams != null && !excelParams.isEmpty()) {
                indexKey = this.createIndexCell(row, index, excelParams.get(0));
            }
            cellNum += indexKey;
            int paramSize = excelParams.size();
            for (k = indexKey; k < paramSize; ++k) {
                entity = excelParams.get(k);
                if (entity.getList() != null) {
                    Collection<?> list = this.getListCellValue(entity, t);
                    int tmpListHeight = 0;
                    if (list != null && list.size() > 0) {
                        int tempCellNum = 0;
                        for (Object obj : list) {
                            int[] temp = this.createCells(patriarch, index + tmpListHeight, obj, entity.getList(), sheet, workbook, rowHeight, cellNum);
                            tempCellNum = temp[1];
                            tmpListHeight += temp[0];
                        }
                        cellNum = tempCellNum;
                        listMaxHeight = Math.max(listMaxHeight, tmpListHeight);
                        continue;
                    }
                    cellNum += this.getListCellSize(entity.getList());
                    continue;
                }
                Object value = this.getCellValue(entity, t);
                if (entity.getType() == 1) {
                    this.createStringCell(row, cellNum++, value == null ? "" : value.toString(), index % 2 == 0 ? this.getStyles(false, entity) : this.getStyles(true, entity), entity);
                    continue;
                }
                if (entity.getType() == 4) {
                    this.createNumericCell(row, cellNum++, value == null ? "" : value.toString(), index % 2 == 0 ? this.getStyles(false, entity) : this.getStyles(true, entity), entity);
                    continue;
                }
                this.createImageCell(patriarch, entity, row, cellNum++, value == null ? "" : value.toString(), t);
            }
            maxHeight += listMaxHeight - 1;
            if (indexKey == 1 && excelParams.get(1).isNeedMerge()) {
                excelParams.get(0).setNeedMerge(true);
            }
            paramSize = excelParams.size();
            for (k = indexKey; k < paramSize; ++k) {
                entity = excelParams.get(k);
                if (entity.getList() != null) {
                    margeCellNum += entity.getList().size();
                    continue;
                }
                if (!entity.isNeedMerge() || maxHeight <= 1) continue;
                for (int i = index + 1; i < index + maxHeight; ++i) {
                    if (sheet.getRow(i) == null) {
                        sheet.createRow(i);
                    }
                    sheet.getRow(i).createCell(margeCellNum);
                    sheet.getRow(i).getCell(margeCellNum).setCellStyle(this.getStyles(false, entity));
                }
                PoiMergeCellUtil.addMergedRegion(sheet, index, index + maxHeight - 1, margeCellNum, margeCellNum);
                ++margeCellNum;
            }
            return new int[]{maxHeight, cellNum};
        }
        catch (Exception e) {
            LOGGER.error("excel cell export error ,data is :{}", (Object)ReflectionToStringBuilder.toString((Object)t));
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new ExcelExportException(ExcelExportEnum.EXPORT_ERROR, (Throwable)e);
        }
    }

    protected int getListCellSize(List<ExcelExportEntity> list) {
        int cellSize = 0;
        for (ExcelExportEntity ee : list) {
            if (ee.getList() != null) {
                cellSize += this.getListCellSize(ee.getList());
                continue;
            }
            ++cellSize;
        }
        return cellSize;
    }
}

