/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.poi.excel.graph.builder;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.charts.AxisCrosses;
import org.apache.poi.ss.usermodel.charts.AxisPosition;
import org.apache.poi.ss.usermodel.charts.ChartAxis;
import org.apache.poi.ss.usermodel.charts.ChartData;
import org.apache.poi.ss.usermodel.charts.ChartDataSource;
import org.apache.poi.ss.usermodel.charts.ChartLegend;
import org.apache.poi.ss.usermodel.charts.DataSources;
import org.apache.poi.ss.usermodel.charts.LegendPosition;
import org.apache.poi.ss.usermodel.charts.LineChartData;
import org.apache.poi.ss.usermodel.charts.ScatterChartData;
import org.apache.poi.ss.usermodel.charts.ValueAxis;
import org.apache.poi.ss.util.CellRangeAddress;
import org.jeecgframework.poi.excel.graph.constant.ExcelGraphElementType;
import org.jeecgframework.poi.excel.graph.constant.ExcelGraphType;
import org.jeecgframework.poi.excel.graph.entity.ExcelGraph;
import org.jeecgframework.poi.excel.graph.entity.ExcelGraphElement;
import org.jeecgframework.poi.excel.graph.entity.ExcelTitleCell;
import org.jeecgframework.poi.util.PoiCellUtil;
import org.jeecgframework.poi.util.PoiExcelGraphDataUtil;

public class ExcelChartBuildService {
    public static void createExcelChart(Workbook workbook, List<ExcelGraph> graphList, Boolean build, Boolean append) {
        Sheet dataSouce;
        if (workbook != null && graphList != null && (dataSouce = workbook.getSheetAt(0)) != null) {
            ExcelChartBuildService.buildTitle(dataSouce, graphList);
            if (build.booleanValue()) {
                PoiExcelGraphDataUtil.buildGraphData(dataSouce, graphList);
            }
            if (append.booleanValue()) {
                ExcelChartBuildService.buildExcelChart(dataSouce, dataSouce, graphList);
            } else {
                Sheet sheet = workbook.createSheet("\u56fe\u5f62\u754c\u9762");
                ExcelChartBuildService.buildExcelChart(dataSouce, sheet, graphList);
            }
        }
    }

    private static void buildExcelChart(Drawing drawing, ClientAnchor anchor, Sheet dataSourceSheet, ExcelGraph graph) {
        LineChartData data;
        Object chart = null;
        ChartLegend legend = chart.getOrCreateLegend();
        legend.setPosition(LegendPosition.TOP_RIGHT);
        ChartAxis bottomAxis = chart.getChartAxisFactory().createCategoryAxis(AxisPosition.BOTTOM);
        ValueAxis leftAxis = chart.getChartAxisFactory().createValueAxis(AxisPosition.LEFT);
        leftAxis.setCrosses(AxisCrosses.AUTO_ZERO);
        ExcelGraphElement categoryElement = graph.getCategory();
        ChartDataSource categoryChart = categoryElement != null && categoryElement.getElementType().equals(ExcelGraphElementType.STRING_TYPE) ? DataSources.fromStringCellRange((Sheet)dataSourceSheet, (CellRangeAddress)new CellRangeAddress(categoryElement.getStartRowNum().intValue(), categoryElement.getEndRowNum().intValue(), categoryElement.getStartColNum().intValue(), categoryElement.getEndColNum().intValue())) : DataSources.fromNumericCellRange((Sheet)dataSourceSheet, (CellRangeAddress)new CellRangeAddress(categoryElement.getStartRowNum().intValue(), categoryElement.getEndRowNum().intValue(), categoryElement.getStartColNum().intValue(), categoryElement.getEndColNum().intValue()));
        List<ExcelGraphElement> valueList = graph.getValueList();
        ArrayList<ChartDataSource<Number>> chartValueList = new ArrayList<ChartDataSource<Number>>();
        if (valueList != null && valueList.size() > 0) {
            for (ExcelGraphElement ele : valueList) {
                ChartDataSource source = DataSources.fromNumericCellRange((Sheet)dataSourceSheet, (CellRangeAddress)new CellRangeAddress(ele.getStartRowNum().intValue(), ele.getEndRowNum().intValue(), ele.getStartColNum().intValue(), ele.getEndColNum().intValue()));
                chartValueList.add((ChartDataSource<Number>)source);
            }
        }
        if (graph.getGraphType().equals(ExcelGraphType.LINE_CHART)) {
            data = chart.getChartDataFactory().createLineChartData();
            ExcelChartBuildService.buildLineChartData(data, categoryChart, chartValueList, graph.getTitle());
            chart.plot((ChartData)data, new ChartAxis[]{bottomAxis, leftAxis});
        } else {
            data = chart.getChartDataFactory().createScatterChartData();
            ExcelChartBuildService.buildScatterChartData((ScatterChartData)data, categoryChart, chartValueList, graph.getTitle());
            chart.plot((ChartData)data, new ChartAxis[]{bottomAxis, leftAxis});
        }
    }

    private static void buildExcelChart(Sheet dataSourceSheet, Sheet tragetSheet, List<ExcelGraph> graphList) {
        int len = graphList.size();
        if (len == 1) {
            ExcelChartBuildService.buildExcelChart(dataSourceSheet, tragetSheet, graphList.get(0));
        } else {
            int drawStart = 0;
            int drawEnd = 20;
            Drawing drawing = PoiExcelGraphDataUtil.getDrawingPatriarch(tragetSheet);
            for (int i = 0; i < len; ++i) {
                ExcelGraph graph = graphList.get(i);
                ClientAnchor anchor = drawing.createAnchor(0, 0, 0, 0, 0, drawStart, 15, drawEnd);
                ExcelChartBuildService.buildExcelChart(drawing, anchor, dataSourceSheet, graph);
                drawStart += drawEnd;
                drawEnd += drawEnd;
            }
        }
    }

    private static void buildExcelChart(Sheet dataSourceSheet, Sheet tragetSheet, ExcelGraph graph) {
        Drawing drawing = PoiExcelGraphDataUtil.getDrawingPatriarch(tragetSheet);
        ClientAnchor anchor = drawing.createAnchor(0, 0, 0, 0, 0, 0, 15, 20);
        ExcelChartBuildService.buildExcelChart(drawing, anchor, dataSourceSheet, graph);
    }

    private static void buildTitle(Sheet sheet, ExcelGraph graph) {
        int cellTitleLen = graph.getTitleCell().size();
        int titleLen = graph.getTitle().size();
        if (titleLen <= 0) {
            for (int i = 0; i < cellTitleLen; ++i) {
                ExcelTitleCell titleCell = graph.getTitleCell().get(i);
                if (titleCell == null) continue;
                graph.getTitle().add(PoiCellUtil.getCellValue(sheet, titleCell.getRow(), titleCell.getCol()));
            }
        }
    }

    private static void buildTitle(Sheet sheet, List<ExcelGraph> graphList) {
        if (graphList != null && graphList.size() > 0) {
            for (ExcelGraph graph : graphList) {
                if (graph == null) continue;
                ExcelChartBuildService.buildTitle(sheet, graph);
            }
        }
    }

    private static void buildLineChartData(LineChartData data, ChartDataSource categoryChart, List<ChartDataSource<Number>> chartValueList, List<String> title) {
        if (chartValueList.size() == title.size()) {
            int len = title.size();
            for (int i = 0; i < len; ++i) {
            }
        } else {
            int i = 0;
            for (ChartDataSource<Number> source : chartValueList) {
                String temp_title = title.get(i);
                if (!StringUtils.isNotBlank((CharSequence)temp_title)) continue;
            }
        }
    }

    private static void buildScatterChartData(ScatterChartData data, ChartDataSource categoryChart, List<ChartDataSource<Number>> chartValueList, List<String> title) {
        if (chartValueList.size() == title.size()) {
            int len = title.size();
            for (int i = 0; i < len; ++i) {
                data.addSerie(categoryChart, chartValueList.get(i)).setTitle(title.get(i));
            }
        } else {
            int i = 0;
            for (ChartDataSource<Number> source : chartValueList) {
                String temp_title = title.get(i);
                if (StringUtils.isNotBlank((CharSequence)temp_title)) {
                    data.addSerie(categoryChart, source).setTitle(temp_title);
                    continue;
                }
                data.addSerie(categoryChart, source);
            }
        }
    }
}

