/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.Serializable;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.metadata.i18n.Errors;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.geotools.referencing.operation.matrix.Matrix3;
import org.geotools.referencing.operation.matrix.XMatrix;
import org.geotools.referencing.operation.transform.AbstractMathTransform;
import org.geotools.referencing.operation.transform.ConcatenatedTransform1D;
import org.geotools.referencing.operation.transform.ConcatenatedTransform2D;
import org.geotools.referencing.operation.transform.ConcatenatedTransformDirect;
import org.geotools.referencing.operation.transform.ConcatenatedTransformDirect1D;
import org.geotools.referencing.operation.transform.ConcatenatedTransformDirect2D;
import org.geotools.referencing.operation.transform.IdentityTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.util.Classes;
import org.geotools.util.Utilities;
import org.opengis.geometry.DirectPosition;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

public class ConcatenatedTransform
extends AbstractMathTransform
implements Serializable {
    private static final long serialVersionUID = 5772066656987558634L;
    private static final double EPSILON = 1.0E-10;
    private static final int TEMPORARY_ARRAY_LENGTH = 256;
    public final MathTransform transform1;
    public final MathTransform transform2;
    private ConcatenatedTransform inverse;

    protected ConcatenatedTransform(MathTransform transform1, MathTransform transform2) {
        this.transform1 = transform1;
        this.transform2 = transform2;
        if (!this.isValid()) {
            throw new IllegalArgumentException(Errors.format((int)20, (Object)ConcatenatedTransform.getName(transform1), (Object)ConcatenatedTransform.getName(transform2)));
        }
    }

    private static XMatrix getMatrix(MathTransform transform) {
        if (transform instanceof LinearTransform) {
            return ConcatenatedTransform.toXMatrix(((LinearTransform)transform).getMatrix());
        }
        if (transform instanceof AffineTransform) {
            return new Matrix3((AffineTransform)transform);
        }
        return null;
    }

    private static boolean areInverse(MathTransform tr1, MathTransform tr2) {
        if (tr2 instanceof AbstractMathTransform.Inverse) {
            return tr1.equals(((AbstractMathTransform.Inverse)tr2).inverse());
        }
        return false;
    }

    public static MathTransform create(MathTransform tr1, MathTransform tr2) {
        int dim2;
        int dim1 = tr1.getTargetDimensions();
        if (dim1 != (dim2 = tr2.getSourceDimensions())) {
            throw new IllegalArgumentException(Errors.format((int)20, (Object)ConcatenatedTransform.getName(tr1), (Object)ConcatenatedTransform.getName(tr2)) + ' ' + Errors.format((int)93, (Object)dim1, (Object)dim2));
        }
        MathTransform mt = ConcatenatedTransform.createOptimized(tr1, tr2);
        if (mt != null) {
            return mt;
        }
        int stepCount = ConcatenatedTransform.getStepCount(tr1) + ConcatenatedTransform.getStepCount(tr2);
        boolean tryAgain = true;
        int k = 0;
        while (true) {
            MathTransform candidate;
            MathTransform c1 = tr1;
            MathTransform c2 = tr2;
            boolean first = !(k & true);
            MathTransform mathTransform = candidate = first ? c1 : c2;
            while (candidate instanceof ConcatenatedTransform) {
                int c;
                ConcatenatedTransform ctr = (ConcatenatedTransform)candidate;
                if (first) {
                    c1 = candidate = ctr.transform1;
                    c2 = ConcatenatedTransform.create(ctr.transform2, c2);
                } else {
                    c1 = ConcatenatedTransform.create(c1, ctr.transform1);
                    c2 = candidate = ctr.transform2;
                }
                if ((c = ConcatenatedTransform.getStepCount(c1) + ConcatenatedTransform.getStepCount(c2)) >= stepCount) continue;
                tr1 = c1;
                tr2 = c2;
                stepCount = c;
                tryAgain = true;
            }
            if (!tryAgain) break;
            tryAgain = false;
            ++k;
        }
        mt = ConcatenatedTransform.createOptimized(tr1, tr2);
        if (mt != null) {
            return mt;
        }
        return ConcatenatedTransform.createConcatenatedTransform(tr1, tr2);
    }

    private static MathTransform createOptimized(MathTransform tr1, MathTransform tr2) {
        MathTransform optimized;
        XMatrix matrix2;
        if (tr1.isIdentity()) {
            return tr2;
        }
        if (tr2.isIdentity()) {
            return tr1;
        }
        XMatrix matrix1 = ConcatenatedTransform.getMatrix(tr1);
        if (matrix1 != null && (matrix2 = ConcatenatedTransform.getMatrix(tr2)) != null) {
            XMatrix matrix;
            int numRow = matrix2.getNumRow();
            int numCol = matrix1.getNumCol();
            if (numCol == matrix2.getNumCol()) {
                matrix = matrix2;
                matrix2.multiply(matrix1);
            } else {
                GeneralMatrix m = new GeneralMatrix(numRow, numCol);
                m.mul(ConcatenatedTransform.toGMatrix(matrix2), (Matrix)ConcatenatedTransform.toGMatrix(matrix1));
                matrix = m;
            }
            if (matrix.isIdentity(1.0E-10)) {
                matrix.setIdentity();
            }
            return ProjectiveTransform.create(matrix);
        }
        if (ConcatenatedTransform.areInverse(tr1, tr2) || ConcatenatedTransform.areInverse(tr2, tr1)) {
            assert (tr1.getSourceDimensions() == tr2.getTargetDimensions());
            assert (tr1.getTargetDimensions() == tr2.getSourceDimensions());
            return IdentityTransform.create(tr1.getSourceDimensions());
        }
        if (tr1 instanceof AbstractMathTransform && (optimized = ((AbstractMathTransform)tr1).concatenate(tr2, false)) != null) {
            return optimized;
        }
        if (tr2 instanceof AbstractMathTransform && (optimized = ((AbstractMathTransform)tr2).concatenate(tr1, true)) != null) {
            return optimized;
        }
        return null;
    }

    static ConcatenatedTransform createConcatenatedTransform(MathTransform tr1, MathTransform tr2) {
        int dimSource = tr1.getSourceDimensions();
        int dimTarget = tr2.getTargetDimensions();
        if (dimSource == 1 && dimTarget == 1) {
            if (tr1 instanceof MathTransform1D && tr2 instanceof MathTransform1D) {
                return new ConcatenatedTransformDirect1D((MathTransform1D)tr1, (MathTransform1D)tr2);
            }
            return new ConcatenatedTransform1D(tr1, tr2);
        }
        if (dimSource == 2 && dimTarget == 2) {
            if (tr1 instanceof MathTransform2D && tr2 instanceof MathTransform2D) {
                return new ConcatenatedTransformDirect2D((MathTransform2D)tr1, (MathTransform2D)tr2);
            }
            return new ConcatenatedTransform2D(tr1, tr2);
        }
        if (dimSource == tr1.getTargetDimensions() && tr2.getSourceDimensions() == dimTarget) {
            return new ConcatenatedTransformDirect(tr1, tr2);
        }
        return new ConcatenatedTransform(tr1, tr2);
    }

    private static final String getName(MathTransform transform) {
        String name;
        ParameterValueGroup params;
        if (transform instanceof AbstractMathTransform && (params = ((AbstractMathTransform)transform).getParameterValues()) != null && (name = params.getDescriptor().getName().getCode()) != null && (name = name.trim()).length() != 0) {
            return name;
        }
        return Classes.getShortClassName((Object)transform);
    }

    boolean isValid() {
        return this.transform1.getTargetDimensions() == this.transform2.getSourceDimensions();
    }

    @Override
    public final int getSourceDimensions() {
        return this.transform1.getSourceDimensions();
    }

    @Override
    public final int getTargetDimensions() {
        return this.transform2.getTargetDimensions();
    }

    public final int getStepCount() {
        return ConcatenatedTransform.getStepCount(this.transform1) + ConcatenatedTransform.getStepCount(this.transform2);
    }

    private static int getStepCount(MathTransform transform) {
        if (transform.isIdentity()) {
            return 0;
        }
        if (!(transform instanceof ConcatenatedTransform)) {
            return 1;
        }
        return ((ConcatenatedTransform)transform).getStepCount();
    }

    @Override
    public DirectPosition transform(DirectPosition ptSrc, DirectPosition ptDst) throws TransformException {
        assert (this.isValid());
        return this.transform2.transform(this.transform1.transform(ptSrc, null), ptDst);
    }

    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        int targetDim;
        assert (this.isValid());
        int intermDim = this.transform1.getTargetDimensions();
        if (intermDim <= (targetDim = this.getTargetDimensions())) {
            this.transform1.transform(srcPts, srcOff, dstPts, dstOff, numPts);
            this.transform2.transform(dstPts, dstOff, dstPts, dstOff, numPts);
            return;
        }
        if (numPts <= 0) {
            return;
        }
        int numTmp = numPts;
        int length = numTmp * intermDim;
        if (length > 256) {
            numTmp = Math.max(1, 256 / intermDim);
            length = numTmp * intermDim;
        }
        double[] tmp = new double[length];
        int sourceDim = this.getSourceDimensions();
        do {
            if (numTmp > numPts) {
                numTmp = numPts;
            }
            this.transform1.transform(srcPts, srcOff, tmp, 0, numTmp);
            this.transform2.transform(tmp, 0, dstPts, dstOff, numTmp);
            srcOff += numTmp * sourceDim;
            dstOff += numTmp * targetDim;
        } while ((numPts -= numTmp) != 0);
    }

    @Override
    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        assert (this.isValid());
        if (numPts <= 0) {
            return;
        }
        int sourceDim = this.getSourceDimensions();
        int targetDim = this.getTargetDimensions();
        int intermDim = this.transform1.getTargetDimensions();
        int numTmp = numPts;
        int dimension = Math.max(Math.max(sourceDim, targetDim), intermDim);
        int length = numTmp * dimension;
        if (length > 256) {
            numTmp = Math.max(1, 256 / dimension);
            length = numTmp * dimension;
        }
        double[] tmp = new double[length];
        do {
            int i;
            if (numTmp > numPts) {
                numTmp = numPts;
            }
            length = numTmp * sourceDim;
            for (i = 0; i < length; ++i) {
                tmp[i] = srcPts[srcOff++];
            }
            this.transform1.transform(tmp, 0, tmp, 0, numTmp);
            this.transform2.transform(tmp, 0, tmp, 0, numTmp);
            length = numTmp * targetDim;
            for (i = 0; i < length; ++i) {
                dstPts[dstOff++] = (float)tmp[i];
            }
        } while ((numPts -= numTmp) != 0);
    }

    @Override
    public synchronized MathTransform inverse() throws NoninvertibleTransformException {
        assert (this.isValid());
        if (this.inverse == null) {
            this.inverse = ConcatenatedTransform.createConcatenatedTransform(this.transform2.inverse(), this.transform1.inverse());
            this.inverse.inverse = this;
        }
        return this.inverse;
    }

    @Override
    public Matrix derivative(Point2D point) throws TransformException {
        return this.derivative(new GeneralDirectPosition(point));
    }

    @Override
    public Matrix derivative(DirectPosition point) throws TransformException {
        XMatrix matrix;
        Matrix matrix1 = this.transform1.derivative(point);
        Matrix matrix2 = this.transform2.derivative(this.transform1.transform(point, null));
        int numRow = matrix2.getNumRow();
        int numCol = matrix1.getNumCol();
        if (numCol == matrix2.getNumCol()) {
            matrix = ConcatenatedTransform.toXMatrix(matrix2);
            matrix.multiply(matrix1);
        } else {
            GeneralMatrix m = new GeneralMatrix(numRow, numCol);
            m.mul(ConcatenatedTransform.toGMatrix(matrix2), (Matrix)ConcatenatedTransform.toGMatrix(matrix1));
            matrix = m;
        }
        return matrix;
    }

    @Override
    public final boolean isIdentity() {
        return this.transform1.isIdentity() && this.transform2.isIdentity();
    }

    @Override
    public final int hashCode() {
        return this.transform1.hashCode() + 37 * this.transform2.hashCode();
    }

    @Override
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            ConcatenatedTransform that = (ConcatenatedTransform)object;
            return Utilities.equals((Object)this.transform1, (Object)that.transform1) && Utilities.equals((Object)this.transform2, (Object)that.transform2);
        }
        return false;
    }

    @Override
    protected String formatWKT(Formatter formatter) {
        ConcatenatedTransform.addWKT(formatter, this.transform1);
        ConcatenatedTransform.addWKT(formatter, this.transform2);
        return "CONCAT_MT";
    }

    private static void addWKT(Formatter formatter, MathTransform transform) {
        if (transform instanceof ConcatenatedTransform) {
            ConcatenatedTransform concat = (ConcatenatedTransform)transform;
            ConcatenatedTransform.addWKT(formatter, concat.transform1);
            ConcatenatedTransform.addWKT(formatter, concat.transform2);
        } else {
            formatter.append(transform);
        }
    }
}

