/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style.windbarbs;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.renderer.style.MarkFactory;
import org.geotools.renderer.style.windbarbs.SpeedConverter;
import org.geotools.renderer.style.windbarbs.WindBarb;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.filter.expression.Expression;

public class WindBarbsFactory
implements MarkFactory {
    static final int MAX_SPEED = 300;
    private static final int NUMBER_OF_ITEMS_IN_CACHE = 60;
    private static final String WINDBARB_DEFINITION = "windbarbs://.*\\(.{1,}\\)\\[.{1,5}\\]\\??.*";
    public static final AffineTransform SOUTHERN_EMISPHERE_FLIP = new AffineTransform2D(AffineTransform.getScaleInstance(-1.0, 1.0));
    private static final Logger LOGGER = Logging.getLogger(WindBarbsFactory.class);
    public static final String WINDBARBS_PREFIX = "windbarbs://";
    private static final String DEFAULT_NAME = "default";
    private static Pattern SPEED_PATTERN = Pattern.compile("(.*?)\\((.{1,})\\)(.*)");
    private static Pattern WINDBARB_SET_PATTERN = Pattern.compile("(.*?)://(.*)\\((.*)");
    private static Pattern UNIT_PATTERN = Pattern.compile("(.*?)\\[(.*)\\](.*)");
    private static final SoftValueHashMap<WindBarb.WindBarbDefinition, Map<Integer, Shape>> CACHE = new SoftValueHashMap(1);

    @Override
    public Shape getShape(Graphics2D graphics, Expression symbolUrl, Feature feature) {
        int index;
        String wellKnownName;
        if (symbolUrl == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Provided null symbol to the WindBarbs Factory");
            }
            return null;
        }
        if (feature == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Provided null feature to the WindBarbs Factory");
            }
            return null;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Trying to resolve symbol:" + symbolUrl.toString());
        }
        if ((wellKnownName = (String)symbolUrl.evaluate((Object)feature, String.class)) == null || wellKnownName.length() <= 0) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Unable to resolve symbol provided to WindBarbs Factory");
            }
            return null;
        }
        if (!wellKnownName.matches(WINDBARB_DEFINITION)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Unable to resolve symbol: " + wellKnownName);
            }
            return null;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Resolved symbol " + wellKnownName);
        }
        String windBarbName = null;
        Matcher matcher = WINDBARB_SET_PATTERN.matcher(wellKnownName);
        if (matcher.matches()) {
            try {
                windBarbName = matcher.group(2);
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "Unable to parse windbarb set from string: " + wellKnownName, e);
                }
                return null;
            }
        }
        if (windBarbName == null || windBarbName.length() <= 0) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.fine("Unable to parse windBarbName from string: " + wellKnownName);
            }
            return null;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Resolved windBarbName " + windBarbName);
        }
        matcher = SPEED_PATTERN.matcher(wellKnownName);
        double speed = Double.NaN;
        if (matcher.matches()) {
            String speedString = "";
            try {
                speedString = matcher.group(2);
                speed = Double.parseDouble(speedString);
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "Unable to parse speed from string: " + speedString, e);
                }
                return null;
            }
        } else {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.fine("Unable to parse speed from string: " + wellKnownName);
            }
            return null;
        }
        String uom = null;
        matcher = UNIT_PATTERN.matcher(wellKnownName);
        if (matcher.matches()) {
            uom = matcher.group(2);
        }
        if (uom == null || uom.length() <= 0) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Unable to parse UoM from " + wellKnownName);
            }
            return null;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("WindBarbs name " + windBarbName + "with Speed " + speed + "[" + uom + "]");
        }
        if ((index = wellKnownName.indexOf(63)) > 0) {
            HashMap<String, String> params = new HashMap<String, String>();
            String kvp = wellKnownName.substring(index + 1);
            String[] pairs = kvp.split("&");
            if (pairs != null && pairs.length > 0) {
                for (String pair : pairs) {
                    String[] splitPair = pair.split("=");
                    if (splitPair != null && splitPair.length > 0) {
                        params.put(splitPair[0].toLowerCase(), splitPair[1]);
                        continue;
                    }
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    LOGGER.fine("Skipping pair " + pair);
                }
                if (!params.isEmpty()) {
                    return this.getWindBarb(windBarbName, speed, uom, params);
                }
            }
        } else if (!wellKnownName.endsWith("]")) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("The provided symbol may be missing a ? before the KVP part.");
            }
            return null;
        }
        return this.getWindBarb(windBarbName, speed, uom);
    }

    private static Map<Integer, Shape> createWindBarbs(WindBarb.WindBarbDefinition definition) {
        HashMap<Integer, Shape> windBarbsMapping = new HashMap<Integer, Shape>();
        for (int i = 0; i <= 60; ++i) {
            windBarbsMapping.put(i, new WindBarb(definition, i * 5).build());
        }
        windBarbsMapping.put(-1, new WindBarb(definition, -1).build());
        return windBarbsMapping;
    }

    private Shape getWindBarb(String windBarbName, double speed, String units, Map<String, String> params) {
        try {
            double knots = SpeedConverter.toKnots(speed, units);
            return this.getWindBarbForKnots(windBarbName, knots, params);
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, e.getLocalizedMessage(), e);
            }
            return null;
        }
    }

    private Shape getWindBarb(String windBarbName, double speed, String units) {
        return this.getWindBarb(windBarbName, speed, units, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Shape getWindBarbForKnots(String windBarbName, double knots, Map<String, String> params) {
        int index = -1;
        if (!Double.isNaN(knots)) {
            index = knots < 3.0 ? 0 : (int)((knots - 3.0) / 5.0 + 1.0);
        }
        if (windBarbName.equalsIgnoreCase(DEFAULT_NAME)) {
            WindBarb.WindBarbDefinition definition = this.parseWindBarbsDefinition(params);
            Map<Integer, Shape> windbarbs = null;
            SoftValueHashMap<WindBarb.WindBarbDefinition, Map<Integer, Shape>> softValueHashMap = CACHE;
            synchronized (softValueHashMap) {
                windbarbs = (Map<Integer, Shape>)CACHE.get((Object)definition);
                if (windbarbs == null) {
                    windbarbs = WindBarbsFactory.createWindBarbs(definition);
                    CACHE.put((Object)definition, windbarbs);
                }
            }
            Shape shp = windbarbs.get(index);
            if (shp == null) {
                shp = new WindBarb(definition, (int)knots).build();
            }
            if (params == null || params.isEmpty()) {
                return shp;
            }
            if (params.containsKey("emisphere") && params.get("emisphere").equalsIgnoreCase("s")) {
                return SOUTHERN_EMISPHERE_FLIP.createTransformedShape(shp);
            }
            if (params.containsKey("hemisphere") && params.get("hemisphere").equalsIgnoreCase("s")) {
                return SOUTHERN_EMISPHERE_FLIP.createTransformedShape(shp);
            }
            return shp;
        }
        throw new IllegalArgumentException("Wrong windbard name:" + windBarbName);
    }

    private WindBarb.WindBarbDefinition parseWindBarbsDefinition(Map<String, String> params) {
        WindBarb.WindBarbDefinition retValue = WindBarb.DEFAULT_WINDBARB_DEFINITION;
        if (params == null || params.size() <= 0) {
            return retValue;
        }
        String temp = null;
        int vectorLength = retValue.vectorLength;
        if (params.containsKey("vectorlength")) {
            temp = params.get("vectorlength");
            if (temp == null || temp.length() <= 0) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Wrong vectorLength provided: " + temp + " resorting to default wind barb definition");
                }
                return retValue;
            }
            try {
                vectorLength = Integer.parseInt(temp);
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Wrong vectorLength provided: " + temp + " resorting to default wind barb definition");
                }
                return retValue;
            }
            if (vectorLength <= 0) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Wrong vectorLength provided: " + temp + " resorting to default wind barb definition");
                }
                return retValue;
            }
        }
        int basePennantLength = retValue.basePennantLength;
        if (params.containsKey("basepennantlength")) {
            temp = params.get("basepennantlength");
            if (temp == null || temp.length() <= 0) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Wrong basePennantLength provided: " + temp + " resorting to default wind barb definition");
                }
                return retValue;
            }
            try {
                basePennantLength = Integer.parseInt(temp);
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Wrong basePennantLength provided: " + temp + " resorting to default wind barb definition");
                }
                return retValue;
            }
            if (basePennantLength <= 0 || basePennantLength >= vectorLength) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Wrong basePennantLength provided: " + temp + " resorting to default wind barb definition");
                }
                return retValue;
            }
        }
        int elementsSpacing = retValue.elementsSpacing;
        if (params.containsKey("elementsspacing")) {
            temp = params.get("elementsspacing");
            if (temp == null || temp.length() <= 0) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Wrong elementsSpacing provided: " + temp + " resorting to default wind barb definition");
                }
                return retValue;
            }
            try {
                elementsSpacing = Integer.parseInt(temp);
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Wrong elementsSpacing provided: " + temp + " resorting to default wind barb definition");
                }
                return retValue;
            }
            if (elementsSpacing <= 0 || elementsSpacing >= vectorLength || elementsSpacing + basePennantLength >= vectorLength) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Wrong elementsSpacing provided: " + temp + " resorting to default wind barb definition");
                }
                return retValue;
            }
        }
        int longBarbLength = retValue.longBarbLength;
        if (params.containsKey("longbarblength")) {
            temp = params.get("longbarblength");
            if (temp == null || temp.length() <= 0) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Wrong longBarbLength provided: " + temp + " resorting to default wind barb definition");
                }
                return retValue;
            }
            try {
                longBarbLength = Integer.parseInt(temp);
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Wrong longBarbLength provided: " + temp + " resorting to default wind barb definition");
                }
                return retValue;
            }
            if (longBarbLength <= 0) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Wrong longBarbLength provided: " + temp + " resorting to default wind barb definition");
                }
                return retValue;
            }
        }
        int zeroWindRadius = retValue.zeroWindRadius;
        if (params.containsKey("zerowindradius")) {
            temp = params.get("zerowindradius");
            if (temp == null || temp.length() <= 0) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Wrong zeroWindRadius provided: " + temp + " resorting to default wind barb definition");
                }
                return retValue;
            }
            try {
                zeroWindRadius = Integer.parseInt(temp);
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Wrong zeroWindRadius provided: " + temp + " resorting to default wind barb definition");
                }
                return retValue;
            }
            if (zeroWindRadius <= 0) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Wrong zeroWindRadius provided: " + temp + " resorting to default wind barb definition");
                }
                return retValue;
            }
        }
        return new WindBarb.WindBarbDefinition(vectorLength, basePennantLength, elementsSpacing, longBarbLength, zeroWindRadius);
    }

    static {
        CACHE.put((Object)WindBarb.DEFAULT_WINDBARB_DEFINITION, WindBarbsFactory.createWindBarbs(WindBarb.DEFAULT_WINDBARB_DEFINITION));
    }
}

