/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.spatial.BBOX;

public class FixBBOXFilterVisitor
extends DuplicatingFilterVisitor {
    ReferencedEnvelope maxbbox;

    public FixBBOXFilterVisitor(ReferencedEnvelope fsd) {
        this.maxbbox = fsd;
    }

    @Override
    public Object visit(BBOX filter, Object extraData) {
        Envelope bbox = null;
        Expression leftGeometry = filter.getExpression1();
        Expression rightGeometry = filter.getExpression2();
        boolean clipped = false;
        Literal le = null;
        if (leftGeometry != null && leftGeometry instanceof Literal) {
            le = (Literal)leftGeometry;
        } else if (rightGeometry != null && rightGeometry instanceof Literal) {
            le = (Literal)rightGeometry;
        }
        if (le != null && le.getValue() != null && le.getValue() instanceof Geometry) {
            Geometry geometry = (Geometry)le.getValue();
            bbox = geometry.getEnvelopeInternal();
        }
        if (bbox == null) {
            return super.visit(filter, extraData);
        }
        double minx = bbox.getMinX();
        double miny = bbox.getMinY();
        double maxx = bbox.getMaxX();
        double maxy = bbox.getMaxY();
        if (this.maxbbox != null) {
            if (minx < this.maxbbox.getMinX()) {
                minx = this.maxbbox.getMinX();
                clipped = true;
            }
            if (maxx > this.maxbbox.getMaxX()) {
                maxx = this.maxbbox.getMaxX();
                clipped = true;
            }
            if (miny < this.maxbbox.getMinY()) {
                miny = this.maxbbox.getMinY();
                clipped = true;
            }
            if (maxy > this.maxbbox.getMaxY()) {
                maxy = this.maxbbox.getMaxY();
                clipped = true;
            }
        }
        if (clipped) {
            String propertyName = filter.getPropertyName();
            String srs = filter.getSRS();
            return this.getFactory(extraData).bbox(propertyName, minx, miny, maxx, maxy, srs);
        }
        return super.visit(filter, extraData);
    }
}

