/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.rendered.viewer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import javax.swing.JPanel;

class ZoomableImageDisplay
extends JPanel {
    protected RenderedImage image;
    protected double scale = 1.0;
    protected boolean tileGridVisible = true;

    public ZoomableImageDisplay() {
        this.setLayout(null);
    }

    public ZoomableImageDisplay(RenderedImage image) {
        this();
        this.setImage(image);
    }

    public void setScale(double scale) {
        if (scale <= 0.0) {
            throw new IllegalArgumentException("Scale must be a positive number");
        }
        this.scale = scale;
        this.refreshComponent();
    }

    public double getScale() {
        return this.scale;
    }

    public void setImage(RenderedImage image) {
        if (image == null) {
            throw new IllegalArgumentException("Image displayed cannot be null");
        }
        this.image = image;
        this.refreshComponent();
    }

    public RenderedImage getImage() {
        return this.image;
    }

    private void refreshComponent() {
        int w = (int)Math.ceil((double)this.image.getWidth() * this.scale);
        int h = (int)Math.ceil((double)this.image.getHeight() * this.scale);
        int minX = (int)Math.ceil((double)this.image.getMinX() * this.scale);
        int minY = (int)Math.ceil((double)this.image.getMinY() * this.scale);
        Insets insets = this.getInsets();
        Dimension dim = new Dimension(w + insets.left + insets.right + minX, h + insets.top + insets.bottom + minY);
        this.setPreferredSize(dim);
        this.revalidate();
        this.repaint();
    }

    @Override
    public synchronized void paintComponent(Graphics g) {
        if (g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            Rectangle clipBounds = g2d.getClipBounds();
            g2d.setColor(this.getBackground());
            g2d.fillRect(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
            if (this.image == null) {
                return;
            }
            try {
                g2d.drawRenderedImage(this.image, AffineTransform.getScaleInstance(this.scale, this.scale));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            if (this.tileGridVisible) {
                int mintx;
                g2d.setColor(Color.WHITE);
                g2d.setXORMode(Color.BLACK);
                int x = (int)Math.floor((double)this.image.getTileGridXOffset() * this.scale);
                int y = (int)Math.floor((double)this.image.getTileGridYOffset() * this.scale);
                int th = (int)Math.round((double)this.image.getTileHeight() * this.scale);
                int tw = (int)Math.round((double)this.image.getTileWidth() * this.scale);
                int xCount = this.image.getNumXTiles();
                int yCount = this.image.getNumYTiles();
                int minty = this.image.getMinTileY();
                for (int i = mintx = this.image.getMinTileX(); i < xCount + mintx + 1; ++i) {
                    g2d.drawLine(x + tw * i, y + th * minty, x + tw * i, y + th * (yCount + minty));
                }
                for (int j = minty; j < yCount + minty + 1; ++j) {
                    g2d.drawLine(x + mintx * tw, y + th * j, x + tw * (xCount + mintx), y + th * j);
                }
            }
        }
    }

    public boolean isTileGridVisible() {
        return this.tileGridVisible;
    }

    public void setTileGridVisible(boolean visible) {
        this.tileGridVisible = visible;
        this.repaint();
    }
}

