/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import it.geosolutions.jaiext.JAIExt;
import it.geosolutions.jaiext.algebra.AlgebraDescriptor;
import java.awt.image.RenderedImage;
import java.util.Collection;
import java.util.Map;
import javax.media.jai.ParameterBlockJAI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.BaseMathOperationJAI;
import org.geotools.coverage.processing.OperationJAI;
import org.geotools.util.NumberRange;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.util.InternationalString;

public class Absolute
extends BaseMathOperationJAI {
    private static final String ALGEBRIC = "algebric";
    private static final String ABSOLUTE = "Absolute";
    private static final long serialVersionUID = 3723059532452772794L;

    public Absolute() {
        super(ABSOLUTE, Absolute.getOperationDescriptor(JAIExt.getOperationName((String)ABSOLUTE)));
    }

    @Override
    public String getName() {
        return ABSOLUTE;
    }

    @Override
    protected NumberRange deriveRange(NumberRange[] ranges, OperationJAI.Parameters parameters) {
        NumberRange range = ranges[0];
        double min = Math.abs(range.getMinimum());
        double max = Math.abs(range.getMaximum());
        return max < min ? NumberRange.create((double)max, (double)min) : NumberRange.create((double)min, (double)max);
    }

    @Override
    protected void handleJAIEXTParams(ParameterBlockJAI parameters, ParameterValueGroup parameters2) {
        if (JAIExt.isJAIExtOperation((String)ALGEBRIC)) {
            parameters.set((Object)AlgebraDescriptor.Operator.ABSOLUTE, 0);
            Collection sources = (Collection)parameters2.parameter("sources").getValue();
            for (GridCoverage2D source : sources) {
                Absolute.handleROINoDataInternal(parameters, source, ALGEBRIC, 1, 2);
            }
        }
    }

    @Override
    protected Map<String, ?> getProperties(RenderedImage data, CoordinateReferenceSystem crs, InternationalString name, MathTransform gridToCRS, GridCoverage2D[] sources, OperationJAI.Parameters parameters) {
        return Absolute.handleROINoDataProperties(null, parameters.parameters, sources[0], ALGEBRIC, 1, 2, 3);
    }
}

