/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator;

import com.googlecode.aviator.Feature;
import java.math.MathContext;
import java.util.Set;

public enum Options {
    OPTIMIZE_LEVEL,
    MATH_CONTEXT,
    ALWAYS_PARSE_FLOATING_POINT_NUMBER_INTO_DECIMAL,
    ALWAYS_PARSE_INTEGRAL_NUMBER_INTO_DECIMAL,
    TRACE_EVAL,
    PUT_CAPTURING_GROUPS_INTO_ENV,
    CAPTURE_FUNCTION_ARGS,
    ENABLE_PROPERTY_SYNTAX_SUGAR,
    NIL_WHEN_PROPERTY_NOT_FOUND,
    USE_USER_ENV_AS_TOP_ENV_DIRECTLY,
    MAX_LOOP_COUNT,
    FEATURE_SET,
    ALLOWED_CLASS_SET,
    ASSIGNABLE_ALLOWED_CLASS_SET;

    public static final Value FALSE_VALUE;
    public static final Value TRUE_VALUE;
    public static final Value ZERO_VALUE;
    public static final Value DEFAULT_MATH_CONTEXT;
    public static final Value EVAL_VALUE;
    public static final Value COMPILE_VALUE;
    private static final Value FULL_FEATURE_SET;
    private static final boolean TRACE_EVAL_DEFAULT_VAL;
    public static final Value NULL_CLASS_SET;

    public Object intoObject(Value val) {
        if (val == null) {
            return null;
        }
        switch (this) {
            case ALWAYS_PARSE_FLOATING_POINT_NUMBER_INTO_DECIMAL: 
            case ALWAYS_PARSE_INTEGRAL_NUMBER_INTO_DECIMAL: 
            case TRACE_EVAL: 
            case PUT_CAPTURING_GROUPS_INTO_ENV: 
            case ENABLE_PROPERTY_SYNTAX_SUGAR: 
            case NIL_WHEN_PROPERTY_NOT_FOUND: 
            case USE_USER_ENV_AS_TOP_ENV_DIRECTLY: 
            case CAPTURE_FUNCTION_ARGS: {
                return val.bool;
            }
            case MAX_LOOP_COUNT: 
            case OPTIMIZE_LEVEL: {
                return val.number;
            }
            case FEATURE_SET: {
                return val.featureSet;
            }
            case MATH_CONTEXT: {
                return val.mathContext;
            }
            case ALLOWED_CLASS_SET: 
            case ASSIGNABLE_ALLOWED_CLASS_SET: {
                return val.classes;
            }
        }
        throw new IllegalArgumentException("Fail to cast value " + val + " for option " + (Object)((Object)this));
    }

    public Value intoValue(Object val) {
        switch (this) {
            case ALWAYS_PARSE_FLOATING_POINT_NUMBER_INTO_DECIMAL: 
            case ALWAYS_PARSE_INTEGRAL_NUMBER_INTO_DECIMAL: 
            case TRACE_EVAL: 
            case PUT_CAPTURING_GROUPS_INTO_ENV: 
            case ENABLE_PROPERTY_SYNTAX_SUGAR: 
            case NIL_WHEN_PROPERTY_NOT_FOUND: 
            case USE_USER_ENV_AS_TOP_ENV_DIRECTLY: 
            case CAPTURE_FUNCTION_ARGS: {
                return (Boolean)val != false ? TRUE_VALUE : FALSE_VALUE;
            }
            case OPTIMIZE_LEVEL: {
                int level = (Integer)val;
                if (level == 1) {
                    return EVAL_VALUE;
                }
                return COMPILE_VALUE;
            }
            case MAX_LOOP_COUNT: {
                return new Value(((Number)val).intValue());
            }
            case ALLOWED_CLASS_SET: 
            case ASSIGNABLE_ALLOWED_CLASS_SET: {
                return Value.fromClasses((Set)val);
            }
            case FEATURE_SET: {
                return new Value((Set)val);
            }
            case MATH_CONTEXT: {
                return new Value((MathContext)val);
            }
        }
        throw new IllegalArgumentException("Fail to cast value " + val + " for option " + (Object)((Object)this));
    }

    public boolean isValidValue(Object val) {
        switch (this) {
            case ALWAYS_PARSE_FLOATING_POINT_NUMBER_INTO_DECIMAL: 
            case ALWAYS_PARSE_INTEGRAL_NUMBER_INTO_DECIMAL: 
            case TRACE_EVAL: 
            case PUT_CAPTURING_GROUPS_INTO_ENV: 
            case ENABLE_PROPERTY_SYNTAX_SUGAR: 
            case NIL_WHEN_PROPERTY_NOT_FOUND: 
            case USE_USER_ENV_AS_TOP_ENV_DIRECTLY: 
            case CAPTURE_FUNCTION_ARGS: {
                return val instanceof Boolean;
            }
            case FEATURE_SET: 
            case ALLOWED_CLASS_SET: 
            case ASSIGNABLE_ALLOWED_CLASS_SET: {
                return val instanceof Set;
            }
            case OPTIMIZE_LEVEL: {
                return val instanceof Integer && ((Integer)val == 1 || (Integer)val == 0);
            }
            case MAX_LOOP_COUNT: {
                return val instanceof Long || val instanceof Integer;
            }
            case MATH_CONTEXT: {
                return val instanceof MathContext;
            }
        }
        return false;
    }

    public Object getDefaultValue() {
        return this.intoObject(this.getDefaultValueObject());
    }

    public Value getDefaultValueObject() {
        switch (this) {
            case ALWAYS_PARSE_FLOATING_POINT_NUMBER_INTO_DECIMAL: 
            case ALWAYS_PARSE_INTEGRAL_NUMBER_INTO_DECIMAL: {
                return FALSE_VALUE;
            }
            case ENABLE_PROPERTY_SYNTAX_SUGAR: {
                return TRUE_VALUE;
            }
            case NIL_WHEN_PROPERTY_NOT_FOUND: {
                return FALSE_VALUE;
            }
            case OPTIMIZE_LEVEL: {
                return EVAL_VALUE;
            }
            case MATH_CONTEXT: {
                return DEFAULT_MATH_CONTEXT;
            }
            case TRACE_EVAL: {
                return TRACE_EVAL_DEFAULT_VAL ? TRUE_VALUE : FALSE_VALUE;
            }
            case PUT_CAPTURING_GROUPS_INTO_ENV: {
                return TRUE_VALUE;
            }
            case USE_USER_ENV_AS_TOP_ENV_DIRECTLY: {
                return TRUE_VALUE;
            }
            case CAPTURE_FUNCTION_ARGS: {
                return FALSE_VALUE;
            }
            case MAX_LOOP_COUNT: {
                return ZERO_VALUE;
            }
            case FEATURE_SET: {
                return FULL_FEATURE_SET;
            }
            case ALLOWED_CLASS_SET: 
            case ASSIGNABLE_ALLOWED_CLASS_SET: {
                return NULL_CLASS_SET;
            }
        }
        return null;
    }

    static {
        FALSE_VALUE = new Value(false);
        TRUE_VALUE = new Value(true);
        ZERO_VALUE = new Value(0);
        DEFAULT_MATH_CONTEXT = new Value(MathContext.DECIMAL128);
        EVAL_VALUE = new Value(1);
        COMPILE_VALUE = new Value(0);
        FULL_FEATURE_SET = new Value(Feature.getFullFeatures());
        TRACE_EVAL_DEFAULT_VAL = Boolean.parseBoolean(System.getProperty("aviator.trace_eval", "false"));
        NULL_CLASS_SET = Value.fromClasses(null);
    }

    public static class Value {
        public boolean bool;
        public MathContext mathContext;
        public int number;
        public Set<Feature> featureSet;
        public Set<Class<?>> classes;

        public Value() {
        }

        static Value fromClasses(Set<Class<?>> classes) {
            Value v = new Value();
            v.classes = classes;
            return v;
        }

        public Value(Set<Feature> featureSet) {
            this.featureSet = featureSet;
        }

        public Value(boolean bool) {
            this.bool = bool;
        }

        public Value(MathContext mathContext) {
            this.mathContext = mathContext;
        }

        public Value(int n) {
            this.number = n;
        }

        public String toString() {
            return "Value [bool=" + this.bool + ", mathContext=" + this.mathContext + ", number=" + this.number + ", featureSet=" + this.featureSet + ", classes=" + this.classes + "]";
        }
    }
}

