/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid.io;

import java.io.IOException;
import org.geotools.coverage.grid.io.GranuleSource;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.store.ReTypingFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeatureType;

public class RenamingGranuleSource
implements GranuleSource {
    protected final String name;
    protected final GranuleSource delegate;
    protected final SimpleFeatureType schema;
    private final String delegateTypeName;

    public RenamingGranuleSource(String name, GranuleSource delegate) {
        this.name = name;
        this.delegate = delegate;
        SimpleFeatureType schema = null;
        try {
            schema = delegate.getSchema();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.delegateTypeName = schema.getTypeName();
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.init(schema);
        builder.setName(name);
        this.schema = builder.buildFeatureType();
    }

    @Override
    public SimpleFeatureCollection getGranules(Query q) throws IOException {
        Query renamed = this.renameQuery(q);
        SimpleFeatureCollection granules = this.delegate.getGranules(renamed);
        SimpleFeatureType targetSchema = this.schema;
        if (q.getPropertyNames() != Query.ALL_NAMES) {
            targetSchema = SimpleFeatureTypeBuilder.retype((SimpleFeatureType)this.schema, (String[])q.getPropertyNames());
        }
        return new ReTypingFeatureCollection(granules, targetSchema);
    }

    protected Query renameQuery(Query q) {
        Query renamed = new Query(q);
        renamed.setTypeName(this.delegateTypeName);
        return renamed;
    }

    @Override
    public int getCount(Query q) throws IOException {
        return this.delegate.getCount(this.renameQuery(q));
    }

    @Override
    public ReferencedEnvelope getBounds(Query q) throws IOException {
        return this.delegate.getBounds(this.renameQuery(q));
    }

    @Override
    public SimpleFeatureType getSchema() throws IOException {
        return this.schema;
    }

    @Override
    public void dispose() throws IOException {
        this.delegate.dispose();
    }
}

