/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.capability.FunctionNameImpl;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;

public class RecodeFunction
implements Function {
    private static final FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
    private final List<Expression> parameters;
    private boolean staticTable = true;
    private volatile Map fastLookup = null;
    private Class lastKeyType = null;
    private Class lastContextType = null;
    private final Literal fallback;
    public static final FunctionName NAME = new FunctionNameImpl("Recode", "LookupValue", "Data 1", "Value 1", "Data 2", "Value 2");

    public RecodeFunction() {
        this(new ArrayList<Expression>(), null);
    }

    public RecodeFunction(List<Expression> parameters, Literal fallback) {
        this.parameters = parameters;
        this.fallback = fallback;
        if (parameters.size() % 2 != 1 && parameters.size() != 0) {
            throw new IllegalArgumentException("There must be an equal number of lookup data and return values");
        }
        FilterAttributeExtractor extractor = new FilterAttributeExtractor();
        for (int i = 1; i < parameters.size(); ++i) {
            Expression expression = parameters.get(i);
            if (expression == null) continue;
            extractor.clear();
            expression.accept((ExpressionVisitor)extractor, null);
            if (extractor.isConstantExpression()) continue;
            this.staticTable = false;
            break;
        }
    }

    public String getName() {
        return "Recode";
    }

    public FunctionName getFunctionName() {
        return NAME;
    }

    public List<Expression> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public Object accept(ExpressionVisitor visitor, Object extraData) {
        return visitor.visit((Function)this, extraData);
    }

    public Object evaluate(Object object) {
        return this.evaluate(object, Object.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T evaluate(Object object, Class<T> context) {
        Object lookup;
        Expression lookupExp = this.parameters.get(0);
        List<Expression> pairList = this.parameters.subList(1, this.parameters.size());
        if (this.staticTable && (lookup = lookupExp.evaluate(object)) != null) {
            if (this.fastLookup == null) {
                RecodeFunction recodeFunction = this;
                synchronized (recodeFunction) {
                    if (this.fastLookup == null) {
                        this.fastLookup = new HashMap();
                        this.lastKeyType = lookup.getClass();
                        this.lastContextType = context;
                        for (int i = 0; i < pairList.size(); i += 2) {
                            Object key = pairList.get(i).evaluate(object, this.lastKeyType);
                            Object value = pairList.get(i + 1).evaluate(object, context);
                            this.fastLookup.put(key, value);
                        }
                    }
                }
            }
            if (this.fastLookup != null && lookup.getClass() == this.lastKeyType && context == this.lastContextType) {
                Object result = this.fastLookup.get(lookup);
                return (T)result;
            }
        }
        for (int i = 0; i < pairList.size(); i += 2) {
            Expression keyExpr = pairList.get(i);
            Expression valueExpr = pairList.get(i + 1);
            PropertyIsEqualTo compareFilter = ff.equal(lookupExp, keyExpr, false);
            if (!compareFilter.evaluate(object)) continue;
            return (T)valueExpr.evaluate(object, context);
        }
        return null;
    }

    public Literal getFallbackValue() {
        return this.fallback;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append("(");
        List<Expression> params = this.getParameters();
        if (params != null) {
            Iterator<Expression> it = params.iterator();
            while (it.hasNext()) {
                Expression exp = it.next();
                sb.append("[");
                sb.append(exp);
                sb.append("]");
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecodeFunction that = (RecodeFunction)o;
        return this.staticTable == that.staticTable && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.fastLookup, that.fastLookup) && Objects.equals(this.lastKeyType, that.lastKeyType) && Objects.equals(this.lastContextType, that.lastContextType) && Objects.equals(this.fallback, that.fallback);
    }

    public int hashCode() {
        return Objects.hash(this.parameters, this.staticTable, this.fastLookup, this.lastKeyType, this.lastContextType, this.fallback);
    }
}

