/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.config.mybatis;

import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.TenantLineInnerInterceptor;
import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.config.mybatis.TenantContext;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@MapperScan(value={"org.jeecg.modules.**.mapper*"})
public class MybatisPlusSaasConfig {
    private static final String TENANT_FIELD_NAME = "tenant_id";
    private static final List<String> TENANT_TABLE = new ArrayList<String>();

    @Bean
    public MybatisPlusInterceptor mybatisPlusInterceptor() {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        interceptor.addInnerInterceptor((InnerInterceptor)new TenantLineInnerInterceptor(new TenantLineHandler(){

            public Expression getTenantId() {
                String tenantId = oConvertUtils.getString(TenantContext.getTenant(), "0");
                return new LongValue(tenantId);
            }

            public String getTenantIdColumn() {
                return MybatisPlusSaasConfig.TENANT_FIELD_NAME;
            }

            public boolean ignoreTable(String tableName) {
                for (String temp : TENANT_TABLE) {
                    if (!temp.equalsIgnoreCase(tableName)) continue;
                    return false;
                }
                return true;
            }
        }));
        interceptor.addInnerInterceptor((InnerInterceptor)new PaginationInnerInterceptor());
        return interceptor;
    }

    static {
        TENANT_TABLE.add("demo");
    }
}

