/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class JTSFrame
extends JFrame {
    private static final int MARGIN = 2;
    private Canvas canvas;

    public JTSFrame(String title) {
        super(title);
        this.initComponents();
        this.setDefaultCloseOperation(3);
    }

    public void addGeometry(Geometry geom, Color col) {
        this.canvas.elements.add(new Element(geom, col));
    }

    public void addCoordinate(Coordinate c, Color col) {
        this.canvas.elements.add(new Element(c, col));
    }

    private void initComponents() {
        this.canvas = new Canvas();
        this.getContentPane().add(this.canvas);
    }

    private static class Canvas
    extends JPanel {
        AffineTransform tr;
        List<Element> elements = new ArrayList<Element>();
        private static final int POINT_RADIUS = 4;

        private Canvas() {
        }

        protected void paintComponent(Graphics g) {
            if (!this.elements.isEmpty()) {
                this.setTransform();
                Graphics2D g2 = (Graphics2D)g;
                g2.setStroke(new BasicStroke(2.0f));
                for (Element e : this.elements) {
                    g2.setColor(e.color);
                    if (e.geom instanceof Coordinate) {
                        this.drawCoordinate(g2, (Coordinate)e.geom);
                        continue;
                    }
                    if (!(e.geom instanceof Geometry)) continue;
                    this.drawGeometry(g2, (Geometry)e.geom);
                }
            }
        }

        private void drawGeometry(Graphics2D g2, Geometry geom) {
            switch (GeomType.get(geom)) {
                case POINT: 
                case LINESTRING: {
                    this.drawVertices(g2, geom.getCoordinates());
                    break;
                }
                case POLYGON: {
                    this.drawPolygon(g2, (Polygon)geom);
                    break;
                }
                case MULTIPOINT: 
                case MULTILINESTRING: {
                    for (int i = 0; i < geom.getNumGeometries(); ++i) {
                        this.drawVertices(g2, geom.getGeometryN(i).getCoordinates());
                    }
                    break;
                }
                case MULTIPOLYGON: {
                    for (int i = 0; i < geom.getNumGeometries(); ++i) {
                        Polygon px = (Polygon)geom.getGeometryN(i);
                        this.drawPolygon(g2, px);
                    }
                    break;
                }
            }
        }

        private void drawPolygon(Graphics2D g2, Polygon poly) {
            Coordinate[] coords = poly.getExteriorRing().getCoordinates();
            this.drawVertices(g2, coords);
            for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
                coords = poly.getInteriorRingN(i).getCoordinates();
                this.drawVertices(g2, coords);
            }
        }

        private void drawVertices(Graphics2D g2, Coordinate[] coords) {
            for (int i = 1; i < coords.length; ++i) {
                Point2D.Double p0 = new Point2D.Double(coords[i - 1].x, coords[i - 1].y);
                this.tr.transform(p0, p0);
                Point2D.Double p1 = new Point2D.Double(coords[i].x, coords[i].y);
                this.tr.transform(p1, p1);
                g2.drawLine((int)((Point2D)p0).getX(), (int)((Point2D)p0).getY(), (int)((Point2D)p1).getX(), (int)((Point2D)p1).getY());
            }
        }

        private void drawCoordinate(Graphics2D g2, Coordinate coord) {
            Point2D.Double p = new Point2D.Double(coord.x, coord.y);
            this.tr.transform(p, p);
            g2.fillOval((int)((Point2D)p).getX() - 4, (int)((Point2D)p).getY() - 4, 8, 8);
        }

        private void setTransform() {
            Envelope env = new Envelope();
            for (int i = 0; i < this.elements.size(); ++i) {
                Object obj = this.elements.get((int)i).geom;
                if (obj instanceof Geometry) {
                    Geometry g = (Geometry)obj;
                    env.expandToInclude(g.getEnvelopeInternal());
                    continue;
                }
                if (!(obj instanceof Coordinate)) continue;
                Coordinate c = (Coordinate)obj;
                env.expandToInclude(c);
            }
            Rectangle visRect = this.getVisibleRect();
            Rectangle drawingRect = new Rectangle(visRect.x + 2, visRect.y + 2, visRect.width - 4, visRect.height - 4);
            double scale = Math.min(drawingRect.getWidth() / env.getWidth(), drawingRect.getHeight() / env.getHeight());
            double xoff = 2.0 - scale * env.getMinX();
            double yoff = 2.0 + env.getMaxY() * scale;
            this.tr = new AffineTransform(scale, 0.0, 0.0, -scale, xoff, yoff);
        }
    }

    private static class Element {
        Object geom;
        Color color;

        public Element(Object g, Color c) {
            this.geom = g;
            this.color = c;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum GeomType {
        POINT,
        LINESTRING,
        POLYGON,
        MULTIPOINT,
        MULTILINESTRING,
        MULTIPOLYGON;


        static GeomType get(Geometry geom) {
            if (geom == null) {
                throw new IllegalArgumentException("Geometry arg must not be null");
            }
            if (geom instanceof Point) {
                return POINT;
            }
            if (geom instanceof MultiPoint) {
                return MULTIPOINT;
            }
            if (geom instanceof LineString) {
                return LINESTRING;
            }
            if (geom instanceof MultiLineString) {
                return MULTILINESTRING;
            }
            if (geom instanceof Polygon) {
                return POLYGON;
            }
            if (geom instanceof MultiPolygon) {
                return MULTIPOLYGON;
            }
            throw new IllegalArgumentException("Unsupported geometry type: " + geom);
        }
    }
}

