/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.crypto;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.crypto.SdkRuntime;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SdkFilterInputStream
extends FilterInputStream {
    private volatile boolean aborted = false;

    public SdkFilterInputStream(InputStream in) {
        super(in);
    }

    public InputStream getDelegateStream() {
        return this.in;
    }

    protected final void abortIfNeeded() {
        if (SdkRuntime.shouldAbort()) {
            this.abort();
            throw new ClientException("Thread aborted, inputStream aborted...", "InputStreamReadingAborted", null);
        }
    }

    public void abort() {
        if (this.in instanceof SdkFilterInputStream) {
            ((SdkFilterInputStream)this.in).abort();
        }
        this.aborted = true;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    @Override
    public int read() throws IOException {
        this.abortIfNeeded();
        return this.in.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.abortIfNeeded();
        return this.in.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        this.abortIfNeeded();
        return this.in.skip(n);
    }

    @Override
    public int available() throws IOException {
        this.abortIfNeeded();
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.abortIfNeeded();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.abortIfNeeded();
        this.in.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.abortIfNeeded();
        this.in.reset();
    }

    @Override
    public boolean markSupported() {
        this.abortIfNeeded();
        return this.in.markSupported();
    }

    public void release() {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

