/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.poi.excel.export;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.jeecgframework.poi.excel.ExcelExportUtil;
import org.jeecgframework.poi.excel.annotation.ExcelTarget;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.enmus.ExcelType;
import org.jeecgframework.poi.excel.entity.params.ExcelExportEntity;
import org.jeecgframework.poi.excel.export.ExcelExportServer;
import org.jeecgframework.poi.excel.export.styler.IExcelExportStyler;
import org.jeecgframework.poi.exception.excel.ExcelExportException;
import org.jeecgframework.poi.exception.excel.enums.ExcelExportEnum;
import org.jeecgframework.poi.handler.inter.IExcelExportServer;
import org.jeecgframework.poi.handler.inter.IWriter;
import org.jeecgframework.poi.util.PoiExcelGraphDataUtil;
import org.jeecgframework.poi.util.PoiPublicUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelBatchExportServer
extends ExcelExportServer
implements IWriter<Workbook> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelBatchExportServer.class);
    private Workbook workbook;
    private Sheet sheet;
    private List<ExcelExportEntity> excelParams;
    private ExportParams entity;
    private int titleHeight;
    private Drawing patriarch;
    private short rowHeight;
    private int index;

    public void init(ExportParams entity, Class<?> pojoClass) {
        List<ExcelExportEntity> excelParams = this.createExcelExportEntityList(entity, pojoClass);
        this.init(entity, excelParams);
    }

    public void init(ExportParams entity, List<ExcelExportEntity> excelParams) {
        LOGGER.debug("ExcelBatchExportServer only support SXSSFWorkbook");
        entity.setType(ExcelType.XSSF);
        this.workbook = new SXSSFWorkbook();
        this.entity = entity;
        this.excelParams = excelParams;
        this.type = entity.getType();
        this.createSheet(this.workbook, entity, excelParams);
        if (entity.getMaxNum() == 0) {
            entity.setMaxNum(ExcelExportUtil.USE_SXSSF_LIMIT);
        }
        this.insertDataToSheet(this.workbook, entity, excelParams, null, this.sheet);
    }

    public List<ExcelExportEntity> createExcelExportEntityList(ExportParams entity, Class<?> pojoClass) {
        try {
            ArrayList<ExcelExportEntity> excelParams = new ArrayList<ExcelExportEntity>();
            if (entity.isAddIndex()) {
                excelParams.add(this.indexExcelEntity(entity));
            }
            Field[] fileds = PoiPublicUtil.getClassFields(pojoClass);
            ExcelTarget etarget = pojoClass.getAnnotation(ExcelTarget.class);
            String targetId = etarget == null ? null : etarget.value();
            this.getAllExcelField(entity.getExclusions(), targetId, fileds, excelParams, pojoClass, null);
            this.sortAllParams(excelParams);
            return excelParams;
        }
        catch (Exception e) {
            throw new ExcelExportException(ExcelExportEnum.EXPORT_ERROR, (Throwable)e);
        }
    }

    public void createSheet(Workbook workbook, ExportParams entity, List<ExcelExportEntity> excelParams) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Excel export start ,List<ExcelExportEntity> is {}", excelParams);
            LOGGER.debug("Excel version is {}", (Object)(entity.getType().equals((Object)ExcelType.HSSF) ? "03" : "07"));
        }
        if (workbook == null || entity == null || excelParams == null) {
            throw new ExcelExportException(ExcelExportEnum.PARAMETER_ERROR);
        }
        try {
            try {
                this.sheet = workbook.createSheet(entity.getSheetName());
            }
            catch (Exception e) {
                this.sheet = workbook.createSheet();
            }
        }
        catch (Exception e) {
            throw new ExcelExportException(ExcelExportEnum.EXPORT_ERROR, (Throwable)e);
        }
    }

    @Override
    protected void insertDataToSheet(Workbook workbook, ExportParams entity, List<ExcelExportEntity> entityList, Collection<? extends Map<?, ?>> dataSet, Sheet sheet) {
        try {
            this.dataHanlder = entity.getDataHanlder();
            if (this.dataHanlder != null && this.dataHanlder.getNeedHandlerFields() != null) {
                this.needHanlderList = Arrays.asList(this.dataHanlder.getNeedHandlerFields());
            }
            this.setExcelExportStyler((IExcelExportStyler)entity.getStyle().getConstructor(Workbook.class).newInstance(workbook));
            this.patriarch = PoiExcelGraphDataUtil.getDrawingPatriarch(sheet);
            ArrayList<ExcelExportEntity> excelParams = new ArrayList<ExcelExportEntity>();
            if (entity.isAddIndex()) {
                excelParams.add(this.indexExcelEntity(entity));
            }
            excelParams.addAll(entityList);
            this.sortAllParams(excelParams);
            this.titleHeight = this.index = entity.isCreateHeadRows() ? this.createHeaderAndTitle(entity, sheet, workbook, excelParams) : 0;
            this.setCellWith(excelParams, sheet);
            this.setColumnHidden(excelParams, sheet);
            this.rowHeight = this.getRowHeight(excelParams);
            this.setCurrentIndex(1);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new ExcelExportException(ExcelExportEnum.EXPORT_ERROR, e.getCause());
        }
    }

    public Workbook exportBigExcel(IExcelExportServer server, Object queryParams) {
        int page = 1;
        List<Object> list = server.selectListForExcelExport(queryParams, page++);
        while (list != null && list.size() > 0) {
            this.write(list);
            list = server.selectListForExcelExport(queryParams, page++);
        }
        return this.close();
    }

    @Override
    public Workbook get() {
        return this.workbook;
    }

    @Override
    public IWriter<Workbook> write(Collection data) {
        if (this.sheet.getLastRowNum() + data.size() > this.entity.getMaxNum()) {
            this.sheet = this.workbook.createSheet();
            this.index = 0;
        }
        for (Object t : data) {
            try {
                this.index += this.createCells(this.patriarch, this.index, t, this.excelParams, this.sheet, this.workbook, this.rowHeight, 0)[0];
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new ExcelExportException(ExcelExportEnum.EXPORT_ERROR, (Throwable)e);
            }
        }
        return this;
    }

    @Override
    public Workbook close() {
        if (this.entity.getFreezeCol() != 0) {
            this.sheet.createFreezePane(this.entity.getFreezeCol(), this.titleHeight, this.entity.getFreezeCol(), this.titleHeight);
        }
        this.mergeCells(this.sheet, this.excelParams, this.titleHeight);
        this.addStatisticsRow(this.getExcelExportStyler().getStyles(true, null), this.sheet);
        return this.workbook;
    }

    @Override
    public ExcelExportEntity indexExcelEntity(ExportParams entity) {
        ExcelExportEntity exportEntity = new ExcelExportEntity();
        exportEntity.setOrderNum(Integer.MIN_VALUE);
        exportEntity.setNeedMerge(true);
        exportEntity.setName(entity.getIndexName());
        exportEntity.setWidth(10.0);
        exportEntity.setFormat("isAddIndex");
        return exportEntity;
    }
}

