/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.simple;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.geotools.data.Query;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleSchema;
import org.geotools.feature.type.BasicFeatureTypes;
import org.geotools.feature.type.FeatureTypeFactoryImpl;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.FeatureTypeFactory;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.Schema;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.InternationalString;

public class SimpleFeatureTypeBuilder {
    static Logger LOGGER = Logging.getLogger(SimpleFeatureTypeBuilder.class);
    protected FeatureTypeFactory factory;
    protected Map<Class<?>, AttributeType> bindings;
    protected String local;
    protected String uri;
    protected InternationalString description;
    protected List<AttributeDescriptor> attributes;
    protected List<Filter> restrictions;
    protected String defaultGeometry;
    protected boolean defaultCrsSet = false;
    protected CoordinateReferenceSystem defaultCrs;
    protected boolean isAbstract = false;
    protected SimpleFeatureType superType;
    protected AttributeTypeBuilder attributeBuilder;

    public SimpleFeatureTypeBuilder() {
        this(new FeatureTypeFactoryImpl());
    }

    public SimpleFeatureTypeBuilder(FeatureTypeFactory factory) {
        this.factory = factory;
        this.attributeBuilder = new AttributeTypeBuilder(factory);
        this.setBindings(new SimpleSchema());
        this.reset();
    }

    public void setFeatureTypeFactory(FeatureTypeFactory factory) {
        this.factory = factory;
    }

    public FeatureTypeFactory getFeatureTypeFactory() {
        return this.factory;
    }

    public void init(SimpleFeatureType type) {
        this.init();
        if (type == null) {
            return;
        }
        this.uri = type.getName().getNamespaceURI();
        this.local = type.getName().getLocalPart();
        this.description = type.getDescription();
        this.restrictions = null;
        this.restrictions().addAll(type.getRestrictions());
        this.defaultCrs = type.getCoordinateReferenceSystem();
        this.defaultCrsSet = true;
        if (type.getGeometryDescriptor() != null) {
            this.defaultGeometry = type.getGeometryDescriptor().getLocalName();
        }
        this.attributes = null;
        this.attributes().addAll(type.getAttributeDescriptors());
        this.isAbstract = type.isAbstract();
        this.superType = (SimpleFeatureType)type.getSuper();
    }

    protected void init() {
        this.attributes = null;
    }

    protected void reset() {
        this.uri = "http://www.opengis.net/gml";
        this.local = null;
        this.description = null;
        this.restrictions = null;
        this.attributes = null;
        this.defaultCrsSet = false;
        this.defaultCrs = null;
        this.isAbstract = false;
        this.superType = BasicFeatureTypes.FEATURE;
    }

    public void setNamespaceURI(String namespaceURI) {
        this.uri = namespaceURI;
    }

    public void setNamespaceURI(URI namespaceURI) {
        if (namespaceURI != null) {
            this.setNamespaceURI(namespaceURI.toString());
        } else {
            this.setNamespaceURI((String)null);
        }
    }

    public String getNamespaceURI() {
        return this.uri;
    }

    public void setName(String name) {
        this.local = name;
    }

    public String getName() {
        return this.local;
    }

    public void setName(Name name) {
        this.setName(name.getLocalPart());
        this.setNamespaceURI(name.getNamespaceURI());
    }

    public void setDescription(InternationalString description) {
        this.description = description;
    }

    public InternationalString getDescription() {
        return this.description;
    }

    public void setDefaultGeometry(String defaultGeometryName) {
        this.defaultGeometry = defaultGeometryName;
    }

    public String getDefaultGeometry() {
        return this.defaultGeometry;
    }

    public void setCRS(CoordinateReferenceSystem crs) {
        this.defaultCrs = crs;
        this.defaultCrsSet = true;
    }

    public CoordinateReferenceSystem getCRS() {
        return this.defaultCrs;
    }

    public void setSRS(String srs) {
        this.setCRS(this.decode(srs));
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setSuperType(SimpleFeatureType superType) {
        this.superType = superType;
    }

    public SimpleFeatureType getSuperType() {
        return this.superType;
    }

    public void addBinding(AttributeType type) {
        this.bindings().put(type.getBinding(), type);
    }

    public void addBindings(Schema schema) {
        for (AttributeType type : schema.values()) {
            this.addBinding(type);
        }
    }

    public void setBindings(Schema schema) {
        this.bindings().clear();
        this.addBindings(schema);
    }

    public AttributeType getBinding(Class<?> binding) {
        return this.bindings().get(binding);
    }

    public SimpleFeatureTypeBuilder minOccurs(int minOccurs) {
        this.attributeBuilder.setMinOccurs(minOccurs);
        return this;
    }

    public SimpleFeatureTypeBuilder maxOccurs(int maxOccurs) {
        this.attributeBuilder.setMaxOccurs(maxOccurs);
        return this;
    }

    public SimpleFeatureTypeBuilder nillable(boolean isNillable) {
        this.attributeBuilder.setNillable(isNillable);
        return this;
    }

    public SimpleFeatureTypeBuilder length(int length) {
        this.attributeBuilder.setLength(length);
        return this;
    }

    public SimpleFeatureTypeBuilder restriction(Filter filter) {
        this.attributeBuilder.addRestriction(filter);
        return this;
    }

    public SimpleFeatureTypeBuilder restrictions(List<Filter> filters) {
        for (Filter f : filters) {
            this.attributeBuilder.addRestriction(f);
        }
        return this;
    }

    public SimpleFeatureTypeBuilder description(String description) {
        this.attributeBuilder.setDescription(description);
        return this;
    }

    public SimpleFeatureTypeBuilder defaultValue(Object defaultValue) {
        this.attributeBuilder.setDefaultValue(defaultValue);
        return this;
    }

    public SimpleFeatureTypeBuilder crs(CoordinateReferenceSystem crs) {
        this.attributeBuilder.setCRS(crs);
        return this;
    }

    public SimpleFeatureTypeBuilder srs(String srs) {
        if (srs == null) {
            return this.crs(null);
        }
        return this.crs(this.decode(srs));
    }

    public SimpleFeatureTypeBuilder srid(Integer srid) {
        if (srid == null) {
            return this.crs(null);
        }
        return this.crs(this.decode("EPSG:" + srid));
    }

    public SimpleFeatureTypeBuilder userData(Object key, Object value) {
        this.attributeBuilder.addUserData(key, value);
        return this;
    }

    public SimpleFeatureTypeBuilder descriptor(AttributeDescriptor descriptor) {
        this.minOccurs(descriptor.getMinOccurs());
        this.maxOccurs(descriptor.getMaxOccurs());
        this.nillable(descriptor.isNillable());
        this.defaultValue(descriptor.getDefaultValue());
        if (descriptor instanceof GeometryDescriptor) {
            this.crs(((GeometryDescriptor)descriptor).getCoordinateReferenceSystem());
        }
        return this;
    }

    public void add(String name, Class<?> binding) {
        AttributeDescriptor descriptor = null;
        this.attributeBuilder.setBinding(binding);
        this.attributeBuilder.setName(name);
        if (this.defaultGeometry != null && this.defaultGeometry.equals(name) || Geometry.class.isAssignableFrom(binding)) {
            if (!this.attributeBuilder.isCRSSet()) {
                if (this.defaultCrs == null && !this.defaultCrsSet) {
                    LOGGER.fine("Creating " + name + " with null CoordinateReferenceSystem - did you mean to setCRS?");
                }
                this.attributeBuilder.setCRS(this.defaultCrs);
            }
            GeometryType type = this.attributeBuilder.buildGeometryType();
            descriptor = this.attributeBuilder.buildDescriptor(name, type);
        } else {
            AttributeType type = this.attributeBuilder.buildType();
            descriptor = this.attributeBuilder.buildDescriptor(name, type);
        }
        this.attributes().add(descriptor);
    }

    public void add(AttributeDescriptor descriptor) {
        this.attributes().add(descriptor);
    }

    public AttributeDescriptor remove(String attributeName) {
        Iterator<AttributeDescriptor> iterator = this.attributes.iterator();
        while (iterator.hasNext()) {
            AttributeDescriptor descriptor = iterator.next();
            if (!descriptor.getLocalName().equals(attributeName)) continue;
            iterator.remove();
            if (attributeName.equals(this.defaultGeometry)) {
                this.defaultGeometry = null;
            }
            return descriptor;
        }
        throw new IllegalArgumentException(attributeName + " is not an existing attribute descriptor in this builder");
    }

    public void add(int index, AttributeDescriptor descriptor) {
        this.attributes().add(index, descriptor);
    }

    public void addAll(List<AttributeDescriptor> descriptors) {
        if (descriptors != null) {
            for (AttributeDescriptor ad : descriptors) {
                this.add(ad);
            }
        }
    }

    public void addAll(AttributeDescriptor[] descriptors) {
        if (descriptors != null) {
            for (AttributeDescriptor ad : descriptors) {
                this.add(ad);
            }
        }
    }

    public void add(String name, Class<?> binding, CoordinateReferenceSystem crs) {
        this.attributeBuilder.setBinding(binding);
        this.attributeBuilder.setName(name);
        this.attributeBuilder.setCRS(crs);
        GeometryType type = this.attributeBuilder.buildGeometryType();
        GeometryDescriptor descriptor = this.attributeBuilder.buildDescriptor(name, type);
        this.attributes().add((AttributeDescriptor)descriptor);
    }

    public void add(String name, Class<?> binding, String srs) {
        if (srs == null) {
            this.add(name, binding, (CoordinateReferenceSystem)null);
            return;
        }
        this.add(name, binding, this.decode(srs));
    }

    public void add(String name, Class<?> binding, Integer srid) {
        if (srid == null) {
            this.add(name, binding, (CoordinateReferenceSystem)null);
            return;
        }
        this.add(name, binding, this.decode("EPSG:" + srid));
    }

    public AttributeDescriptor get(int index) {
        return this.attributes().get(index);
    }

    public AttributeDescriptor get(String attributeName) {
        for (AttributeDescriptor descriptor : this.attributes) {
            if (!descriptor.getLocalName().equals(attributeName)) continue;
            return descriptor;
        }
        return null;
    }

    public void set(int index, AttributeDescriptor descriptor) {
        this.attributes().set(index, descriptor);
    }

    public void set(AttributeDescriptor descriptor) {
        int index = this.indexOf(descriptor.getLocalName());
        if (index == -1) {
            throw new IllegalArgumentException(descriptor.getLocalName() + " is not an existing attribute descriptor in this builder");
        }
        this.set(index, descriptor);
    }

    public void set(String attributeName, AttributeDescriptor descriptor) {
        int index = this.indexOf(attributeName);
        if (index == -1) {
            throw new IllegalArgumentException(attributeName + " is not an existing attribute descriptor in this builder");
        }
        this.set(index, descriptor);
    }

    private int indexOf(String attributeName) {
        int i = 0;
        for (AttributeDescriptor d : this.attributes) {
            if (d.getLocalName().equals(attributeName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void set(String attributeName, AttributeTypeBuilder attributeBuilder) {
        AttributeDescriptor descriptor = attributeBuilder.buildDescriptor(attributeName);
        this.set(attributeName, descriptor);
    }

    public void setAttributes(List<AttributeDescriptor> attributes) {
        List<AttributeDescriptor> atts = this.attributes();
        atts.clear();
        if (attributes != null) {
            atts.addAll(attributes);
        }
    }

    public void setAttributes(AttributeDescriptor[] attributes) {
        List<AttributeDescriptor> atts = this.attributes();
        atts.clear();
        if (attributes != null) {
            atts.addAll(Arrays.asList(attributes));
        }
    }

    public SimpleFeatureType buildFeatureType() {
        GeometryDescriptor defGeom = null;
        if (this.defaultGeometry != null) {
            List<AttributeDescriptor> atts = this.attributes();
            for (int i = 0; i < atts.size(); ++i) {
                AttributeDescriptor att = (AttributeDescriptor)atts.get(i);
                if (!this.defaultGeometry.equals(att.getName().getLocalPart())) continue;
                if (!(att instanceof GeometryDescriptor)) {
                    LOGGER.warning("Default Geometry " + this.defaultGeometry + " was added as a geoemtry");
                    this.attributeBuilder.init(att);
                    this.attributeBuilder.setCRS(this.defaultCrs);
                    GeometryType type = this.attributeBuilder.buildGeometryType();
                    att = this.attributeBuilder.buildDescriptor(att.getName(), type);
                    atts.set(i, att);
                }
                defGeom = (GeometryDescriptor)att;
                break;
            }
            if (defGeom == null) {
                String msg = "'" + this.defaultGeometry + "' specified as default but could find no such attribute.";
                throw new IllegalArgumentException(msg);
            }
        }
        if (defGeom == null) {
            for (AttributeDescriptor att : this.attributes()) {
                if (!(att instanceof GeometryDescriptor)) continue;
                defGeom = (GeometryDescriptor)att;
                break;
            }
        }
        SimpleFeatureType built = this.factory.createSimpleFeatureType(this.name(), this.attributes(), defGeom, this.isAbstract, this.restrictions(), (AttributeType)this.superType, this.description);
        this.init();
        return built;
    }

    protected Set newSet() {
        return new HashSet();
    }

    protected List newList() {
        return new ArrayList();
    }

    protected Map newMap() {
        return new HashMap();
    }

    protected List newList(List origional) {
        if (origional == null) {
            return this.newList();
        }
        if (origional == Collections.EMPTY_LIST) {
            return this.newList();
        }
        try {
            return (List)origional.getClass().newInstance();
        }
        catch (InstantiationException e) {
            return this.newList();
        }
        catch (IllegalAccessException e) {
            return this.newList();
        }
    }

    protected Name name() {
        if (this.local == null) {
            return null;
        }
        return new NameImpl(this.uri, this.local);
    }

    protected List<AttributeDescriptor> attributes() {
        if (this.attributes == null) {
            this.attributes = this.newList();
        }
        return this.attributes;
    }

    protected List<Filter> restrictions() {
        if (this.restrictions == null) {
            this.restrictions = this.newList();
        }
        return this.restrictions;
    }

    protected Map<Class<?>, AttributeType> bindings() {
        if (this.bindings == null) {
            this.bindings = this.newMap();
        }
        return this.bindings;
    }

    protected CoordinateReferenceSystem decode(String srs) {
        try {
            return CRS.decode((String)srs);
        }
        catch (Exception e) {
            String msg = "SRS '" + srs + "' unknown:" + e.getLocalizedMessage();
            throw (IllegalArgumentException)new IllegalArgumentException(msg).initCause(e);
        }
    }

    public static SimpleFeatureType retype(SimpleFeatureType original, String[] types) {
        return SimpleFeatureTypeBuilder.retype(original, Arrays.asList(types));
    }

    public static SimpleFeatureType retype(SimpleFeatureType original, List<String> types) {
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.init(original);
        b.attributes().clear();
        for (int i = 0; i < types.size(); ++i) {
            b.add(original.getDescriptor(types.get(i)));
        }
        GeometryDescriptor defaultGeometry = original.getGeometryDescriptor();
        if (defaultGeometry != null && types.contains(defaultGeometry.getLocalName())) {
            b.setDefaultGeometry(defaultGeometry.getLocalName());
        } else {
            b.setDefaultGeometry(null);
        }
        return b.buildFeatureType();
    }

    public static SimpleFeatureType retype(SimpleFeatureType original, CoordinateReferenceSystem crs) {
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.init(original);
        b.attributes().clear();
        for (AttributeDescriptor descriptor : original.getAttributeDescriptors()) {
            if (descriptor instanceof GeometryDescriptor) {
                GeometryDescriptor geometryDescriptor = (GeometryDescriptor)descriptor;
                AttributeTypeBuilder adjust = new AttributeTypeBuilder(b.factory);
                adjust.init((AttributeDescriptor)geometryDescriptor);
                adjust.setCRS(crs);
                b.add(adjust.buildDescriptor(geometryDescriptor.getLocalName()));
                continue;
            }
            b.add(descriptor);
        }
        return b.buildFeatureType();
    }

    public static SimpleFeatureType retype(SimpleFeatureType origional, Query query) {
        CoordinateReferenceSystem crs = null;
        if (query.getCoordinateSystem() != null) {
            crs = query.getCoordinateSystem();
        }
        if (query.getCoordinateSystemReproject() != null) {
            crs = query.getCoordinateSystemReproject();
        }
        return SimpleFeatureTypeBuilder.retype(origional, query.getPropertyNames(), crs);
    }

    private static SimpleFeatureType retype(SimpleFeatureType origional, String[] propertyNames, CoordinateReferenceSystem crs) {
        return null;
    }

    public static SimpleFeatureType copy(SimpleFeatureType original) {
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.init(original);
        b.attributes().clear();
        for (AttributeDescriptor descriptor : original.getAttributeDescriptors()) {
            AttributeTypeBuilder ab = new AttributeTypeBuilder(b.factory);
            ab.init(descriptor);
            b.add(ab.buildDescriptor(descriptor.getLocalName()));
        }
        return b.buildFeatureType();
    }
}

