/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.label;

import java.awt.Rectangle;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.geotools.renderer.label.LabelCacheItem;
import org.geotools.renderer.label.LabelIndex;
import org.geotools.renderer.label.LabelPainter;

abstract class GlyphProcessor {
    LabelPainter painter;
    LabelCacheItem labelItem;

    public GlyphProcessor(LabelPainter painter) {
        this.painter = painter;
        this.labelItem = painter.labelItem;
    }

    public abstract boolean process(GlyphVector var1, int var2, AffineTransform var3, char var4);

    public static class IndexAdder
    extends GlyphProcessor {
        LabelIndex index;

        public IndexAdder(LabelPainter painter, LabelIndex index) {
            super(painter);
            this.index = index;
        }

        @Override
        public boolean process(GlyphVector glyphVector, int g, AffineTransform tx, char c) {
            if (Character.isWhitespace(c)) {
                return false;
            }
            Rectangle2D labelEnvelope = tx.createTransformedShape(glyphVector.getGlyphOutline(g)).getBounds2D();
            this.index.addLabel(this.labelItem, labelEnvelope);
            return true;
        }
    }

    public static class ConflictDetector
    extends GlyphProcessor {
        Rectangle displayArea;
        LabelIndex paintedBounds;
        LabelIndex groupLabels;
        int extraSpace;
        double minDistance;

        public ConflictDetector(LabelPainter painter, Rectangle displayArea, LabelIndex paintedBounds, LabelIndex groupLabels) {
            super(painter);
            this.displayArea = displayArea;
            this.paintedBounds = paintedBounds;
            this.groupLabels = groupLabels;
            int space = this.labelItem.getSpaceAround();
            int haloRadius = Math.round(this.labelItem.getTextStyle().getHaloFill() != null ? this.labelItem.getTextStyle().getHaloRadius() : 0.0f);
            this.extraSpace = space + haloRadius;
            this.minDistance = this.labelItem.getMinGroupDistance();
        }

        @Override
        public boolean process(GlyphVector glyphVector, int g, AffineTransform tx, char c) {
            Rectangle2D labelEnvelope = tx.createTransformedShape(glyphVector.getGlyphLogicalBounds(g)).getBounds2D();
            if (Character.isWhitespace(c)) {
                return false;
            }
            return !this.displayArea.contains(labelEnvelope) && !this.labelItem.isPartialsEnabled() || this.labelItem.isConflictResolutionEnabled() && this.paintedBounds.labelsWithinDistance(labelEnvelope, this.extraSpace) || this.groupLabels.labelsWithinDistance(labelEnvelope, this.minDistance);
        }
    }

    public static class BoundsPainter
    extends GlyphProcessor {
        public BoundsPainter(LabelPainter painter) {
            super(painter);
        }

        @Override
        public boolean process(GlyphVector glyphVector, int g, AffineTransform tx, char c) {
            if (Character.isWhitespace(c)) {
                return false;
            }
            this.painter.graphics.draw(tx.createTransformedShape(glyphVector.getGlyphOutline(g)).getBounds2D());
            return true;
        }
    }
}

