/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureWriter;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileFeatureReader;
import org.geotools.data.shapefile.ShapefileSizeException;
import org.geotools.data.shapefile.dbf.DbaseFileHeader;
import org.geotools.data.shapefile.dbf.DbaseFileWriter;
import org.geotools.data.shapefile.files.ShpFileType;
import org.geotools.data.shapefile.files.ShpFiles;
import org.geotools.data.shapefile.files.StorageFile;
import org.geotools.data.shapefile.shp.JTSUtilities;
import org.geotools.data.shapefile.shp.ShapeHandler;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileException;
import org.geotools.data.shapefile.shp.ShapefileWriter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;

class ShapefileFeatureWriter
implements FeatureWriter<SimpleFeatureType, SimpleFeature> {
    static final long DEFAULT_MAX_SHAPE_SIZE = Integer.MAX_VALUE;
    static final long DEFAULT_MAX_DBF_SIZE = Integer.MAX_VALUE;
    protected ShapefileFeatureReader featureReader;
    protected SimpleFeature currentFeature;
    protected SimpleFeatureType featureType;
    protected Object[] emptyAtts;
    protected Object[] transferCache;
    protected ShapeType shapeType;
    protected ShapeHandler handler;
    protected int shapefileLength = 100;
    protected int records = 0;
    protected byte[] writeFlags;
    protected ShapefileWriter shpWriter;
    protected DbaseFileWriter dbfWriter;
    private DbaseFileHeader dbfHeader;
    protected Map<ShpFileType, StorageFile> storageFiles = new HashMap<ShpFileType, StorageFile>();
    protected Envelope bounds = new Envelope();
    protected ShpFiles shpFiles;
    private FileChannel dbfChannel;
    private Charset dbfCharset;
    private TimeZone dbfTimeZone;
    private GeometryFactory gf = new GeometryFactory();
    private boolean guessShapeType;
    private long maxShpSize = Integer.MAX_VALUE;
    private long maxDbfSize = Integer.MAX_VALUE;

    public ShapefileFeatureWriter(ShpFiles shpFiles, ShapefileFeatureReader featureReader, Charset charset, TimeZone timezone) throws IOException {
        this.shpFiles = shpFiles;
        this.dbfCharset = charset;
        this.dbfTimeZone = timezone;
        this.featureReader = featureReader;
        this.storageFiles.put(ShpFileType.SHP, shpFiles.getStorageFile(ShpFileType.SHP));
        this.storageFiles.put(ShpFileType.SHX, shpFiles.getStorageFile(ShpFileType.SHX));
        this.storageFiles.put(ShpFileType.DBF, shpFiles.getStorageFile(ShpFileType.DBF));
        this.featureType = featureReader.getFeatureType();
        this.emptyAtts = new Object[this.featureType.getAttributeCount()];
        this.writeFlags = new byte[this.featureType.getAttributeCount()];
        int cnt = 0;
        int ii = this.featureType.getAttributeCount();
        for (int i = 0; i < ii; ++i) {
            if (this.featureType.getDescriptor(i) instanceof GeometryDescriptor) continue;
            ++cnt;
            this.writeFlags[i] = 1;
        }
        this.transferCache = new Object[cnt];
        FileChannel shpChannel = this.storageFiles.get((Object)ShpFileType.SHP).getWriteChannel();
        FileChannel shxChannel = this.storageFiles.get((Object)ShpFileType.SHX).getWriteChannel();
        this.shpWriter = new ShapefileWriter(shpChannel, shxChannel);
        this.dbfHeader = ShapefileDataStore.createDbaseHeader(this.featureType);
        this.dbfChannel = this.storageFiles.get((Object)ShpFileType.DBF).getWriteChannel();
        this.dbfWriter = new DbaseFileWriter(this.dbfHeader, this.dbfChannel, this.dbfCharset, this.dbfTimeZone);
        featureReader.disableShxUsage();
        this.guessShapeType = !featureReader.hasNext();
        this.shapeType = featureReader.getShapeType();
        this.handler = this.shapeType.getShapeHandler(new GeometryFactory());
        this.shpWriter.writeHeaders(this.bounds, this.shapeType, this.records, this.shapefileLength);
    }

    void setMaxShpSize(long maxShapeSize) {
        this.maxShpSize = maxShapeSize;
    }

    void setMaxDbfSize(long maxDbfSize) {
        this.maxDbfSize = maxDbfSize;
    }

    protected void flush() throws IOException {
        if (this.records <= 0 && this.shapeType == null) {
            GeometryDescriptor geometryDescriptor = this.featureType.getGeometryDescriptor();
            this.shapeType = JTSUtilities.getShapeType(geometryDescriptor);
        }
        this.shpWriter.writeHeaders(this.bounds, this.shapeType, this.records, this.shapefileLength);
        this.dbfHeader.setNumRecords(this.records);
        this.dbfChannel.position(0L);
        this.dbfHeader.writeHeader(this.dbfChannel);
    }

    protected void finalize() throws Throwable {
        if (this.featureReader != null) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void clean() throws IOException {
        StorageFile.replaceOriginals(this.storageFiles.values().toArray(new StorageFile[0]));
    }

    public void close() throws IOException {
        if (this.featureReader == null) {
            return;
        }
        try {
            if (this.currentFeature != null) {
                this.write();
            }
            if (this.featureReader.nextFeature != null) {
                this.currentFeature = this.featureReader.nextFeature;
                this.write();
            }
            if (this.featureReader != null) {
                this.handler = this.shapeType.getShapeHandler(this.gf);
                if (this.records == 0) {
                    this.shpWriter.writeHeaders(this.bounds, this.shapeType, 0, 0);
                }
                double[] env = new double[4];
                while (this.featureReader.filesHaveMore()) {
                    this.shapefileLength += this.featureReader.shp.transferTo(this.shpWriter, ++this.records, env);
                    this.bounds.expandToInclude(env[0], env[1]);
                    this.bounds.expandToInclude(env[2], env[3]);
                    this.featureReader.dbf.transferTo(this.dbfWriter);
                }
            }
        }
        finally {
            this.doClose();
            this.clean();
        }
    }

    protected void doClose() throws IOException {
        try {
            this.featureReader.close();
        }
        finally {
            try {
                this.flush();
            }
            finally {
                this.shpWriter.close();
                this.dbfWriter.close();
            }
            this.featureReader = null;
            this.shpWriter = null;
            this.dbfWriter = null;
        }
    }

    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    public boolean hasNext() throws IOException {
        if (this.featureReader == null) {
            return false;
        }
        return this.featureReader.hasNext();
    }

    public SimpleFeature next() throws IOException {
        if (this.featureReader == null) {
            throw new IOException("Writer closed");
        }
        if (this.currentFeature != null) {
            this.write();
        }
        if (this.featureReader.hasNext()) {
            this.currentFeature = this.featureReader.next();
            return this.currentFeature;
        }
        String featureID = this.getFeatureType().getTypeName() + "." + (this.records + 1);
        this.currentFeature = DataUtilities.template((SimpleFeatureType)this.getFeatureType(), (String)featureID, (Object[])this.emptyAtts);
        return this.currentFeature;
    }

    protected String nextFeatureId() {
        return this.getFeatureType().getTypeName() + "." + (this.records + 1);
    }

    public void remove() throws IOException {
        if (this.featureReader == null) {
            throw new IOException("Writer closed");
        }
        if (this.currentFeature == null) {
            throw new IOException("Current feature is null");
        }
        this.currentFeature = null;
    }

    public void write() throws IOException {
        Envelope b;
        if (this.currentFeature == null) {
            throw new IOException("Current feature is null");
        }
        if (this.featureReader == null) {
            throw new IOException("Writer closed");
        }
        Geometry g = (Geometry)this.currentFeature.getDefaultGeometry();
        if (this.guessShapeType) {
            try {
                if (g != null) {
                    int dims = JTSUtilities.guessCoorinateDims(g.getCoordinates());
                    this.shapeType = JTSUtilities.getShapeType(g, dims);
                } else {
                    this.shapeType = JTSUtilities.getShapeType(this.currentFeature.getType().getGeometryDescriptor());
                }
                this.shpWriter.writeHeaders(new Envelope(), this.shapeType, 0, 0);
                this.handler = this.shapeType.getShapeHandler(this.gf);
                this.guessShapeType = false;
            }
            catch (ShapefileException se) {
                throw new RuntimeException("Unexpected Error", (Throwable)((Object)se));
            }
        }
        if ((g = JTSUtilities.convertToCollection(g, this.shapeType)) != null && !(b = g.getEnvelopeInternal()).isNull()) {
            this.bounds.expandToInclude(b);
        }
        this.shapefileLength = g != null ? (this.shapefileLength += this.handler.getLength(g) + 8) : (this.shapefileLength += 12);
        if ((long)this.shapefileLength > this.maxShpSize) {
            this.currentFeature = null;
            throw new ShapefileSizeException("Writing this feature will make the shapefile exceed the maximum size of " + this.maxShpSize + " bytes");
        }
        if (this.dbfWriter.getHeader().getLengthForRecords(this.records + 1) > this.maxDbfSize) {
            this.currentFeature = null;
            throw new ShapefileSizeException("Writing this feature will make the DBF exceed the maximum size of " + this.maxDbfSize + " bytes");
        }
        this.shpWriter.writeGeometry(g);
        int idx = 0;
        int ii = this.featureType.getAttributeCount();
        for (int i = 0; i < ii; ++i) {
            if (this.writeFlags[i] <= 0) continue;
            this.transferCache[idx++] = this.currentFeature.getAttribute(i);
        }
        this.dbfWriter.write(this.transferCache);
        ++this.records;
        this.currentFeature = null;
    }
}

