/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.weibo.api;

import com.alibaba.fastjson.JSONObject;
import com.jeecg.weibo.dto.WeiBoMentionsDto;
import com.jeecg.weibo.exception.BusinessException;
import com.jeecg.weibo.util.HttpUtil;
import com.jeecg.weibo.util.WeiboCommentsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeiboCommentsApi {
    private static final Logger logger = LoggerFactory.getLogger(WeiboCommentsApi.class);
    private static final String by_me_url = "https://api.weibo.com/2/comments/by_me.json?1=1";
    private static final String to_me_url = "https://api.weibo.com/2/comments/to_me.json?1=1";

    public static JSONObject getByme(WeiBoMentionsDto mentions) {
        JSONObject j = null;
        try {
            logger.info("\u6211\u53d1\u51fa\u7684\u8bc4\u8bba\u5217\u8868\u7684\u53c2\u6570\u4e3a:" + mentions.toString());
            WeiboCommentsUtil.getBymeParmValidate(mentions);
            String requestUrl = WeiboCommentsUtil.getTomeUrl(by_me_url, mentions);
            logger.info("\u6211\u53d1\u51fa\u7684\u8bc4\u8bba\u5217\u8868\u7684\u8def\u5f84\u4e3a:" + requestUrl);
            j = HttpUtil.httpRequest(requestUrl, "GET", null);
            if (j != null) {
                logger.info("\u6211\u53d1\u51fa\u7684\u8bc4\u8bba\u5217\u8868\u7684\u7ed3\u679c\u4e3a:" + j.toString());
            } else {
                logger.info("\u6211\u53d1\u51fa\u7684\u8bc4\u8bba\u5217\u8868\u7684\u7ed3\u679c\u4e3a:null");
            }
        }
        catch (BusinessException e) {
            logger.info(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return j;
    }

    public static JSONObject getTome(WeiBoMentionsDto mentions) {
        JSONObject j = null;
        try {
            logger.info("\u6211\u6536\u5230\u7684\u8bc4\u8bba\u5217\u8868\u7684\u53c2\u6570\u4e3a:" + mentions.toString());
            WeiboCommentsUtil.getBymeParmValidate(mentions);
            String requestUrl = WeiboCommentsUtil.getBymeUrl(to_me_url, mentions);
            logger.info("\u6211\u6536\u5230\u7684\u8bc4\u8bba\u5217\u8868\u7684\u8def\u5f84\u4e3a:" + requestUrl);
            j = HttpUtil.httpRequest(requestUrl, "GET", null);
            if (j != null) {
                logger.info("\u6211\u6536\u5230\u7684\u8bc4\u8bba\u5217\u8868\u7684\u7ed3\u679c\u4e3a:" + j.toString());
            } else {
                logger.info("\u6211\u6536\u5230\u7684\u8bc4\u8bba\u5217\u8868\u7684\u7ed3\u679c\u4e3a:null");
            }
        }
        catch (BusinessException e) {
            logger.info(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return j;
    }

    public static void main(String[] args) {
    }
}

