/*
 * Decompiled with CFR 0.152.
 */
package org.jeewx.api.core.handler.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Map;
import org.jeewx.api.core.annotation.ReqType;
import org.jeewx.api.core.exception.WexinReqException;
import org.jeewx.api.core.handler.WeiXinReqHandler;
import org.jeewx.api.core.req.model.WeixinReqConfig;
import org.jeewx.api.core.req.model.WeixinReqParam;
import org.jeewx.api.core.util.HttpRequestProxy;
import org.jeewx.api.core.util.WeiXinReqUtil;
import org.jeewx.api.coupon.location.model.LocationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeixinReqLogoUploadHandler
implements WeiXinReqHandler {
    private static Logger logger = LoggerFactory.getLogger(WeixinReqLogoUploadHandler.class);

    @Override
    public String doRequest(WeixinReqParam weixinReqParam) throws WexinReqException {
        String strReturnInfo = "";
        if (weixinReqParam instanceof LocationInfo) {
            LocationInfo uploadMedia = (LocationInfo)weixinReqParam;
            ReqType reqType = uploadMedia.getClass().getAnnotation(ReqType.class);
            WeixinReqConfig objConfig = WeiXinReqUtil.getWeixinReqConfig(reqType.value());
            if (objConfig != null) {
                String reqUrl = objConfig.getUrl();
                String fileName = uploadMedia.getFilePathName();
                File file = new File(fileName);
                FileInputStream fileIn = null;
                try {
                    fileIn = new FileInputStream(file);
                    String extName = fileName.substring(fileName.lastIndexOf(".") + 1);
                    String contentType = WeiXinReqUtil.getFileContentType(extName);
                    if (contentType == null) {
                        logger.error("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6587\u4ef6\u7c7b\u578b");
                    }
                    Map parameters = WeiXinReqUtil.getWeixinReqParam(weixinReqParam);
                    parameters.remove("filePathName");
                    strReturnInfo = HttpRequestProxy.uploadMedia(reqUrl, parameters, "UTF-8", fileIn, file.getName(), contentType);
                }
                catch (FileNotFoundException e) {
                    throw new WexinReqException(e);
                }
            }
        } else if (weixinReqParam instanceof LocationInfo) {
            LocationInfo uploadMedia = (LocationInfo)weixinReqParam;
            ReqType reqType = uploadMedia.getClass().getAnnotation(ReqType.class);
            WeixinReqConfig objConfig = WeiXinReqUtil.getWeixinReqConfig(reqType.value());
            if (objConfig != null) {
                String reqUrl = objConfig.getUrl();
                String fileName = uploadMedia.getFilePathName();
                File file = new File(fileName);
                FileInputStream fileIn = null;
                try {
                    fileIn = new FileInputStream(file);
                    String extName = fileName.substring(fileName.lastIndexOf(".") + 1);
                    String contentType = WeiXinReqUtil.getFileContentType(extName);
                    if (contentType == null || !contentType.equals("image/jpeg")) {
                        throw new WexinReqException("\u4e0a\u4f20LOGO \u5927\u5c0f\u9650\u52361MB\uff0c\u50cf\u7d20\u4e3a300*300\uff0c\u652f\u6301JPG\u683c\u5f0f\u4ee5\u8fbe\u5230\u6700\u4f73\u6548\u679c");
                    }
                    Map parameters = WeiXinReqUtil.getWeixinReqParam(weixinReqParam);
                    parameters.remove("filePathName");
                    strReturnInfo = HttpRequestProxy.uploadMedia(reqUrl, parameters, "UTF-8", fileIn, file.getName(), contentType);
                }
                catch (FileNotFoundException e) {
                    throw new WexinReqException(e);
                }
            }
        } else {
            logger.info("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u914d\u7f6e\u4fe1\u606f");
        }
        return strReturnInfo;
    }
}

