/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.rlookup;

import com.sun.media.jai.opimage.RIFUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.rlookup.RangeLookupOpImage;
import it.geosolutions.jaiext.rlookup.RangeLookupTable;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import java.util.List;
import javax.media.jai.ImageLayout;
import javax.media.jai.ROI;
import javax.media.jai.RasterFactory;

public class RangeLookupRIF
implements RenderedImageFactory {
    @Override
    public RenderedImage create(ParameterBlock paramBlock, RenderingHints renderHints) {
        boolean isDataTypeChanged;
        int dataType;
        Class destClazz;
        RenderedImage src = paramBlock.getRenderedSource(0);
        ImageLayout layout = RIFUtil.getImageLayoutHint((RenderingHints)renderHints);
        RangeLookupTable table = (RangeLookupTable)paramBlock.getObjectParameter(0);
        Number defaultValue = (Number)paramBlock.getObjectParameter(1);
        ROI roi = (ROI)paramBlock.getObjectParameter(2);
        List items = table.getItems();
        if (items.size() > 0) {
            destClazz = items.get(0).getValue().getClass();
        } else if (defaultValue != null) {
            destClazz = defaultValue.getClass();
        } else {
            dataType = paramBlock.getRenderedSource(0).getSampleModel().getDataType();
            destClazz = Range.DataType.classFromType((int)dataType);
        }
        dataType = -1;
        if (destClazz.equals(Short.class)) {
            for (int i = items.size() - 1; i >= 0; --i) {
                if (((Number)items.get(i).getValue()).shortValue() >= 0) continue;
                dataType = 2;
                break;
            }
            if (dataType == -1) {
                dataType = 1;
            }
        } else {
            try {
                dataType = Range.DataType.dataTypeFromClass((Class)destClazz);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("Illegal destination class for this rangelookuptable:" + destClazz.toString());
            }
        }
        if (isDataTypeChanged = src.getSampleModel().getDataType() != dataType) {
            layout = layout == null ? new ImageLayout(src) : (ImageLayout)layout.clone();
            SampleModel sampleModel = layout.getSampleModel(src);
            int tileWidth = layout.getTileWidth(src);
            int tileHeight = layout.getTileHeight(src);
            int numBands = src.getSampleModel().getNumBands();
            SampleModel csm = RasterFactory.createComponentSampleModel((SampleModel)sampleModel, (int)dataType, (int)tileWidth, (int)tileHeight, (int)numBands);
            layout.setSampleModel(csm);
            ColorModel colorModel = layout.getColorModel(null);
            if (colorModel != null && !JDKWorkarounds.areCompatibleDataModels((SampleModel)layout.getSampleModel(null), (ColorModel)colorModel)) {
                layout.unsetValid(512);
            }
        }
        return new RangeLookupOpImage(src, renderHints, layout, table, defaultValue, roi);
    }
}

