/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.stats;

import it.geosolutions.jaiext.stats.Statistics;

public class MeanSum
extends Statistics {
    private boolean simpleSum;
    private double sumValues;
    private long samples;

    MeanSum(boolean simpleSum) {
        this.simpleSum = simpleSum;
        this.sumValues = 0.0;
        this.samples = 0L;
        this.type = simpleSum ? Statistics.StatsType.SUM : Statistics.StatsType.MEAN;
    }

    private double getSumValues() {
        return this.sumValues;
    }

    @Override
    public void addSample(double sample) {
        this.sumValues += sample;
        ++this.samples;
    }

    @Override
    protected synchronized void accumulateStats(Statistics stats) {
        this.checkSameStats(stats);
        MeanSum msum = (MeanSum)stats;
        this.samples += msum.getNumSamples().longValue();
        this.sumValues += msum.getSumValues();
    }

    @Override
    public Object getResult() {
        if (this.simpleSum) {
            return this.sumValues;
        }
        if (this.samples == 1L || this.sumValues == 0.0) {
            return this.sumValues;
        }
        return this.sumValues / (double)this.samples;
    }

    @Override
    public Long getNumSamples() {
        return this.samples;
    }

    @Override
    protected void clearStats() {
        this.sumValues = 0.0;
        this.samples = 0L;
    }
}

