/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.minidao.auto;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jeecgframework.minidao.factory.MiniDaoBeanScannerConfigurer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Repository;

@Configuration
public class MinidaoAutoConfiguration {
    private static final Log logger = LogFactory.getLog(MinidaoAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(value={MiniDaoBeanScannerConfigurer.class})
    public static MiniDaoBeanScannerConfigurer miniDaoBeanScannerConfigurer(Environment env, ApplicationContext applicationContext) {
        logger.info((Object)" ******************* init miniDao config [ begin ] *********************** ");
        logger.info((Object)(" ------ minidao.base-package ------- " + env.getProperty("minidao.base-package", "*")));
        logger.debug((Object)(" ------ minidao.format-sql --------- " + env.getProperty("minidao.format-sql", "false")));
        logger.debug((Object)(" ------ minidao.key-type ----------- " + env.getProperty("minidao.key-type", "origin")));
        logger.debug((Object)(" ------ minidao.show-sql ----------- " + env.getProperty("minidao.show-sql", "false")));
        MiniDaoBeanScannerConfigurer miniDaoBeanScannerConfigurer = new MiniDaoBeanScannerConfigurer();
        miniDaoBeanScannerConfigurer.setBasePackage(env.getProperty("minidao.base-package", "*"));
        miniDaoBeanScannerConfigurer.setApplicationContext(applicationContext);
        miniDaoBeanScannerConfigurer.setFormatSql(((Boolean)env.getProperty("minidao.format-sql", Boolean.class, (Object)false)).booleanValue());
        miniDaoBeanScannerConfigurer.setKeyType(env.getProperty("minidao.key-type", "origin"));
        miniDaoBeanScannerConfigurer.setShowSql(((Boolean)env.getProperty("minidao.show-sql", Boolean.class, (Object)false)).booleanValue());
        miniDaoBeanScannerConfigurer.setAnnotation(Repository.class);
        logger.info((Object)" *******************  init miniDao config  [ end ] *********************** ");
        return miniDaoBeanScannerConfigurer;
    }
}

