/*
 * Decompiled with CFR 0.152.
 */
package io.minio;

import com.google.common.base.Objects;
import io.minio.BucketArgs;
import io.minio.ServerSideEncryption;
import okhttp3.HttpUrl;

public abstract class ObjectArgs
extends BucketArgs {
    protected String objectName;

    public String object() {
        return this.objectName;
    }

    protected void checkSse(ServerSideEncryption sse, HttpUrl url) {
        if (sse == null) {
            return;
        }
        if (sse.tlsRequired() && !url.isHttps()) {
            throw new IllegalArgumentException(sse + " operations must be performed over a secure connection.");
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ObjectArgs)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ObjectArgs that = (ObjectArgs)o;
        return Objects.equal((Object)this.objectName, (Object)that.objectName);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.objectName});
    }

    public static abstract class Builder<B extends Builder<B, A>, A extends ObjectArgs>
    extends BucketArgs.Builder<B, A> {
        protected void validateObjectName(String name) {
            this.validateNotEmptyString(name, "object name");
            for (String token : name.split("/")) {
                if (!token.equals(".") && !token.equals("..")) continue;
                throw new IllegalArgumentException("object name with '.' or '..' path segment is not supported");
            }
        }

        @Override
        protected void validate(A args) {
            super.validate(args);
            this.validateObjectName(((ObjectArgs)args).objectName);
        }

        public B object(String name) {
            this.validateObjectName(name);
            this.operations.add(args -> {
                args.objectName = name;
            });
            return (B)this;
        }
    }
}

