/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.resManager.roleRescatalog.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.resManager.roleRescatalog.entity.RoleRescatalog;
import org.jeecg.modules.resManager.roleRescatalog.mapper.RoleRescatalogMapper;
import org.jeecg.modules.resManager.roleRescatalog.service.IRoleRescatalogService;
import org.springframework.stereotype.Service;

@Service
public class RoleRescatalogServiceImpl
extends ServiceImpl<RoleRescatalogMapper, RoleRescatalog>
implements IRoleRescatalogService {
    @Override
    public void saveRolePermission(String roleId, String rescatalogIds) {
        String[] arr;
        LambdaQueryWrapper query = (LambdaQueryWrapper)new QueryWrapper().lambda().eq(RoleRescatalog::getRoleId, (Object)roleId);
        this.remove((Wrapper)query);
        ArrayList<RoleRescatalog> list = new ArrayList<RoleRescatalog>();
        for (String resId : arr = rescatalogIds.split(",")) {
            if (!oConvertUtils.isNotEmpty((Object)resId)) continue;
            RoleRescatalog roleRescatalog = new RoleRescatalog();
            roleRescatalog.setRoleId(roleId);
            roleRescatalog.setRescatalogId(resId);
            this.save(roleRescatalog);
            list.add(roleRescatalog);
        }
        this.saveBatch(list);
    }

    @Override
    public void saveRolePermission(String roleId, String rescatalogIds, String lastRescatalogIds) {
        List<String> delete;
        List<String> addList = this.getDiff(lastRescatalogIds, rescatalogIds);
        if (addList != null && addList.size() > 0) {
            ArrayList<RoleRescatalog> list = new ArrayList<RoleRescatalog>();
            for (String resId : addList) {
                if (!oConvertUtils.isNotEmpty((Object)resId)) continue;
                RoleRescatalog roleRescatalog = new RoleRescatalog();
                roleRescatalog.setRoleId(roleId);
                roleRescatalog.setRescatalogId(resId);
                list.add(roleRescatalog);
            }
            this.saveBatch(list);
        }
        if ((delete = this.getDiff(rescatalogIds, lastRescatalogIds)) != null && delete.size() > 0) {
            for (String catalogId : delete) {
                this.remove((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(RoleRescatalog::getRoleId, (Object)roleId)).eq(RoleRescatalog::getRescatalogId, (Object)catalogId));
            }
        }
    }

    private List<String> getDiff(String main, String diff) {
        if (oConvertUtils.isEmpty((Object)diff)) {
            return null;
        }
        if (oConvertUtils.isEmpty((Object)main)) {
            return Arrays.asList(diff.split(","));
        }
        String[] mainArr = main.split(",");
        String[] diffArr = diff.split(",");
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (String string : mainArr) {
            map.put(string, 1);
        }
        ArrayList<String> res = new ArrayList<String>();
        for (String key : diffArr) {
            if (!oConvertUtils.isNotEmpty((Object)key) || map.containsKey(key)) continue;
            res.add(key);
        }
        return res;
    }
}

