/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.topicManage.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.modules.topicManage.entity.TopicsConfig;
import org.jeecg.modules.topicManage.service.ITopicsConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u4e13\u9898\u56fe\u914d\u7f6e"})
@RestController
@RequestMapping(value={"/topicManage/topicsConfig"})
public class TopicsConfigController
extends JeecgController<TopicsConfig, ITopicsConfigService> {
    private static final Logger log = LoggerFactory.getLogger(TopicsConfigController.class);
    @Autowired
    private ITopicsConfigService topicsConfigService;

    @ApiOperation(value="\u4e13\u9898\u56fe\u914d\u7f6e-\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u4e13\u9898\u56fe\u914d\u7f6e-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<IPage<TopicsConfig>> queryPageList(TopicsConfig topicsConfig, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)topicsConfig, (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.topicsConfigService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.OK((Object)pageList);
    }

    @AutoLog(value="\u4e13\u9898\u56fe\u914d\u7f6e-\u6dfb\u52a0")
    @ApiOperation(value="\u4e13\u9898\u56fe\u914d\u7f6e-\u6dfb\u52a0", notes="\u4e13\u9898\u56fe\u914d\u7f6e-\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<String> add(@RequestBody TopicsConfig topicsConfig) {
        this.topicsConfigService.save(topicsConfig);
        return Result.OK((String)"\u6dfb\u52a0\u6210\u529f\uff01");
    }

    @AutoLog(value="\u4e13\u9898\u56fe\u914d\u7f6e-\u7f16\u8f91")
    @ApiOperation(value="\u4e13\u9898\u56fe\u914d\u7f6e-\u7f16\u8f91", notes="\u4e13\u9898\u56fe\u914d\u7f6e-\u7f16\u8f91")
    @RequestMapping(value={"/edit"}, method={RequestMethod.PUT, RequestMethod.POST})
    public Result<String> edit(@RequestBody TopicsConfig topicsConfig) {
        this.topicsConfigService.updateById(topicsConfig);
        return Result.OK((String)"\u7f16\u8f91\u6210\u529f!");
    }

    @AutoLog(value="\u4e13\u9898\u56fe\u914d\u7f6e-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u4e13\u9898\u56fe\u914d\u7f6e-\u901a\u8fc7id\u5220\u9664", notes="\u4e13\u9898\u56fe\u914d\u7f6e-\u901a\u8fc7id\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public Result<String> delete(@RequestParam(name="id", required=true) String id) {
        this.topicsConfigService.removeById((Serializable)((Object)id));
        return Result.OK((String)"\u5220\u9664\u6210\u529f!");
    }

    @AutoLog(value="\u4e13\u9898\u56fe\u914d\u7f6e-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u4e13\u9898\u56fe\u914d\u7f6e-\u6279\u91cf\u5220\u9664", notes="\u4e13\u9898\u56fe\u914d\u7f6e-\u6279\u91cf\u5220\u9664")
    @DeleteMapping(value={"/deleteBatch"})
    public Result<String> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.topicsConfigService.removeByIds(Arrays.asList(ids.split(",")));
        return Result.OK((String)"\u6279\u91cf\u5220\u9664\u6210\u529f!");
    }

    @ApiOperation(value="\u4e13\u9898\u56fe\u914d\u7f6e-\u901a\u8fc7id\u67e5\u8be2", notes="\u4e13\u9898\u56fe\u914d\u7f6e-\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<TopicsConfig> queryById(@RequestParam(name="id", required=true) String id) {
        TopicsConfig topicsConfig = (TopicsConfig)this.topicsConfigService.getById((Serializable)((Object)id));
        if (topicsConfig == null) {
            return Result.error((String)"\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e");
        }
        return Result.OK((Object)topicsConfig);
    }

    @RequestMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, TopicsConfig topicsConfig) {
        return super.exportXls(request, (Object)topicsConfig, TopicsConfig.class, "\u4e13\u9898\u56fe\u914d\u7f6e");
    }

    @RequestMapping(value={"/importExcel"}, method={RequestMethod.POST})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, TopicsConfig.class);
    }
}

