/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.web;

import io.swagger.models.Swagger;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.plugin.core.PluginRegistry;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;
import springfox.documentation.service.Documentation;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.DocumentationCache;
import springfox.documentation.spring.web.OnServletBasedWebApplication;
import springfox.documentation.spring.web.json.Json;
import springfox.documentation.spring.web.json.JsonSerializer;
import springfox.documentation.swagger2.mappers.ServiceModelToSwagger2Mapper;
import springfox.documentation.swagger2.web.SwaggerTransformationContext;
import springfox.documentation.swagger2.web.WebMvcSwaggerTransformationFilter;

@ApiIgnore
@RestController
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@RequestMapping(value={"${springfox.documentation.swagger.v2.path:/v2/api-docs}"})
@Conditional(value={OnServletBasedWebApplication.class})
@Order(value=-2147483648)
public class Swagger2ControllerWebMvc {
    public static final String SWAGGER2_SPECIFICATION_PATH = "${springfox.documentation.swagger.v2.path:/v2/api-docs}";
    private static final Logger LOGGER = LoggerFactory.getLogger(Swagger2ControllerWebMvc.class);
    private static final String HAL_MEDIA_TYPE = "application/hal+json";
    private final DocumentationCache documentationCache;
    private final ServiceModelToSwagger2Mapper mapper;
    private final JsonSerializer jsonSerializer;
    private final PluginRegistry<WebMvcSwaggerTransformationFilter, DocumentationType> transformations;

    @Autowired
    public Swagger2ControllerWebMvc(DocumentationCache documentationCache, ServiceModelToSwagger2Mapper mapper, JsonSerializer jsonSerializer, @Qualifier(value="webMvcSwaggerTransformationFilterRegistry") PluginRegistry<WebMvcSwaggerTransformationFilter, DocumentationType> transformations) {
        this.documentationCache = documentationCache;
        this.mapper = mapper;
        this.jsonSerializer = jsonSerializer;
        this.transformations = transformations;
    }

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json", "application/hal+json"})
    public ResponseEntity<Json> getDocumentation(@RequestParam(value="group", required=false) String swaggerGroup, HttpServletRequest servletRequest) {
        String groupName = Optional.ofNullable(swaggerGroup).orElse("default");
        Documentation documentation = this.documentationCache.documentationByGroup(groupName);
        if (documentation == null) {
            LOGGER.warn("Unable to find specification for group {}", (Object)groupName);
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        Swagger swagger = this.mapper.mapDocumentation(documentation);
        SwaggerTransformationContext<HttpServletRequest> context = new SwaggerTransformationContext<HttpServletRequest>(swagger, servletRequest);
        List filters = this.transformations.getPluginsFor((Object)DocumentationType.SWAGGER_2);
        for (WebMvcSwaggerTransformationFilter each : filters) {
            context = context.next(each.transform(context));
        }
        return new ResponseEntity((Object)this.jsonSerializer.toJson((Object)context.getSpecification()), HttpStatus.OK);
    }
}

