/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.commonQueryConfig.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.jeecg.common.api.CommonAPI;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.system.vo.DictModel;
import org.jeecg.modules.bussMapQuery.controller.QueryRecord;
import org.jeecg.modules.bussMapQuery.controller.QueryResult;
import org.jeecg.modules.commonQueryConfig.entity.CommonQueryConfig;
import org.jeecg.modules.commonQueryConfig.service.ICommonQueryConfigService;
import org.jeecg.modules.resManager.catalog.entity.Rescatalog;
import org.jeecg.modules.resManager.catalog.service.IRescatalogService;
import org.jeecg.modules.topicManage.entity.TopicsConfig;
import org.jeecg.modules.topicManage.service.ITopicsConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u901a\u7528\u67e5\u8be2\u914d\u7f6e\u8868"})
@RestController
@RequestMapping(value={"/commonQueryConfig/commonQueryConfig"})
public class CommonQueryConfigController
extends JeecgController<CommonQueryConfig, ICommonQueryConfigService> {
    private static final Logger log = LoggerFactory.getLogger(CommonQueryConfigController.class);
    @Autowired
    private ICommonQueryConfigService commonQueryConfigService;
    @Autowired
    private IRescatalogService rescatalogService;
    @Autowired
    private CommonAPI commonApi;
    @Autowired
    private ITopicsConfigService topicsConfigService;

    @GetMapping(value={"/queryListByUser"})
    public Result<?> queryListByUser(@RequestParam(value="username") String username, @RequestParam(value="topicId") String topicId) {
        ArrayList<JSONObject> queryList = new ArrayList<JSONObject>();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(Rescatalog::getQueryable, (Object)"true");
        List resCatalogs = this.rescatalogService.list((Wrapper)queryWrapper);
        if (resCatalogs.size() > 0) {
            String querytypes = "";
            if (!"null".equals(topicId) && !topicId.isEmpty()) {
                LambdaQueryWrapper topicsConfigLambdaQueryWrapper = new LambdaQueryWrapper();
                topicsConfigLambdaQueryWrapper.eq(TopicsConfig::getTopicid, (Object)topicId);
                TopicsConfig topicsConfig = (TopicsConfig)this.topicsConfigService.getOne((Wrapper)topicsConfigLambdaQueryWrapper);
                querytypes = topicsConfig.getQuerytypes();
            }
            for (int i = 0; i < resCatalogs.size(); ++i) {
                Rescatalog rescatalog = (Rescatalog)resCatalogs.get(i);
                String res_id = rescatalog.getId();
                int resCount = this.rescatalogService.queryCountByUsername(username, res_id);
                if (resCount == 0 || !querytypes.isEmpty() && querytypes.indexOf(res_id) == -1) continue;
                String tablename = rescatalog.getTablename();
                JSONObject jsonObject = new JSONObject();
                ArrayList list = new ArrayList();
                String queryfield = rescatalog.getQueryname();
                String chinesename = rescatalog.getChinesename();
                if (StringUtils.isNotBlank((CharSequence)queryfield) && StringUtils.isNotBlank((CharSequence)chinesename) && queryfield.contains(",") && chinesename.contains(",")) {
                    List<String> queryfieldList = Arrays.asList(queryfield.split(","));
                    List<String> chinesenameList = Arrays.asList(chinesename.split(","));
                    for (int j = 0; j < queryfieldList.size(); ++j) {
                        HashMap<String, String> querylisyMap = new HashMap<String, String>();
                        querylisyMap.put("queryname", queryfieldList.get(j));
                        querylisyMap.put("chinesename", chinesenameList.get(j));
                        list.add(querylisyMap);
                    }
                } else if (StringUtils.isNotBlank((CharSequence)queryfield) && StringUtils.isNotBlank((CharSequence)chinesename) && !queryfield.contains(",") && !chinesename.contains(",")) {
                    HashMap<String, String> querylisyMap = new HashMap<String, String>();
                    querylisyMap.put("queryname", queryfield);
                    querylisyMap.put("chinesename", chinesename);
                    list.add(querylisyMap);
                }
                jsonObject.put("id", (Object)res_id);
                jsonObject.put("tablename", (Object)tablename);
                jsonObject.put("inputTip", (Object)rescatalog.getLyrhint());
                jsonObject.put("returntree", (Object)rescatalog.getReturntree());
                jsonObject.put("queryList", list);
                LambdaQueryWrapper queryConfigQueryWrapper = new LambdaQueryWrapper();
                queryConfigQueryWrapper.eq(CommonQueryConfig::getTablename, (Object)rescatalog.getTablename());
                long count = this.commonQueryConfigService.count((Wrapper)queryConfigQueryWrapper);
                if (count < 1L) continue;
                CommonQueryConfig commonQueryConfig = (CommonQueryConfig)this.commonQueryConfigService.getOne((Wrapper)queryConfigQueryWrapper, false);
                jsonObject.put("tablealias", (Object)commonQueryConfig.getTablealias());
                queryList.add(jsonObject);
            }
        }
        return Result.OK(queryList);
    }

    @ApiOperation(value="\u901a\u7528\u67e5\u8be2\u914d\u7f6e\u8868-\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u901a\u7528\u67e5\u8be2\u914d\u7f6e\u8868-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<IPage<CommonQueryConfig>> queryPageList(CommonQueryConfig commonQueryConfig, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)commonQueryConfig, (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.commonQueryConfigService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.OK((Object)pageList);
    }

    @AutoLog(value="\u901a\u7528\u67e5\u8be2\u914d\u7f6e\u8868-\u6dfb\u52a0")
    @ApiOperation(value="\u901a\u7528\u67e5\u8be2\u914d\u7f6e\u8868-\u6dfb\u52a0", notes="\u901a\u7528\u67e5\u8be2\u914d\u7f6e\u8868-\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<String> add(@RequestBody CommonQueryConfig commonQueryConfig) {
        this.commonQueryConfigService.save(commonQueryConfig);
        return Result.OK((String)"\u6dfb\u52a0\u6210\u529f\uff01");
    }

    @AutoLog(value="\u901a\u7528\u67e5\u8be2\u914d\u7f6e\u8868-\u7f16\u8f91")
    @ApiOperation(value="\u901a\u7528\u67e5\u8be2\u914d\u7f6e\u8868-\u7f16\u8f91", notes="\u901a\u7528\u67e5\u8be2\u914d\u7f6e\u8868-\u7f16\u8f91")
    @RequestMapping(value={"/edit"}, method={RequestMethod.PUT, RequestMethod.POST})
    public Result<String> edit(@RequestBody CommonQueryConfig commonQueryConfig) {
        this.commonQueryConfigService.updateById(commonQueryConfig);
        return Result.OK((String)"\u7f16\u8f91\u6210\u529f!");
    }

    @AutoLog(value="\u901a\u7528\u67e5\u8be2\u914d\u7f6e\u8868-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u7528\u67e5\u8be2\u914d\u7f6e\u8868-\u901a\u8fc7id\u5220\u9664", notes="\u901a\u7528\u67e5\u8be2\u914d\u7f6e\u8868-\u901a\u8fc7id\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public Result<String> delete(@RequestParam(name="id", required=true) String id) {
        this.commonQueryConfigService.removeById((Serializable)((Object)id));
        return Result.OK((String)"\u5220\u9664\u6210\u529f!");
    }

    @AutoLog(value="\u901a\u7528\u67e5\u8be2\u914d\u7f6e\u8868-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u901a\u7528\u67e5\u8be2\u914d\u7f6e\u8868-\u6279\u91cf\u5220\u9664", notes="\u901a\u7528\u67e5\u8be2\u914d\u7f6e\u8868-\u6279\u91cf\u5220\u9664")
    @DeleteMapping(value={"/deleteBatch"})
    public Result<String> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.commonQueryConfigService.removeByIds(Arrays.asList(ids.split(",")));
        return Result.OK((String)"\u6279\u91cf\u5220\u9664\u6210\u529f!");
    }

    @ApiOperation(value="\u901a\u7528\u67e5\u8be2\u914d\u7f6e\u8868-\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u7528\u67e5\u8be2\u914d\u7f6e\u8868-\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<CommonQueryConfig> queryById(@RequestParam(name="id", required=true) String id) {
        CommonQueryConfig commonQueryConfig = (CommonQueryConfig)this.commonQueryConfigService.getById((Serializable)((Object)id));
        if (commonQueryConfig == null) {
            return Result.error((String)"\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e");
        }
        return Result.OK((Object)commonQueryConfig);
    }

    @RequestMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, CommonQueryConfig commonQueryConfig) {
        return super.exportXls(request, (Object)commonQueryConfig, CommonQueryConfig.class, "\u901a\u7528\u67e5\u8be2\u914d\u7f6e\u8868");
    }

    @RequestMapping(value={"/importExcel"}, method={RequestMethod.POST})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, CommonQueryConfig.class);
    }

    @GetMapping(value={"/identifyQuery"})
    public Result<?> identifyQuery(@RequestParam(name="layerName", required=true) String layerName, @RequestParam(name="objectId") String objectId) {
        JSONObject result = new JSONObject();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(Rescatalog::getName, (Object)layerName);
        Rescatalog resCatalog = (Rescatalog)this.rescatalogService.getOne((Wrapper)queryWrapper);
        String tableName = resCatalog.getTablename();
        LambdaQueryWrapper configLambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)configLambdaQueryWrapper.eq(CommonQueryConfig::getTablename, (Object)tableName)).orderByAsc(CommonQueryConfig::getShoworder);
        List commonQueryConfigs = this.commonQueryConfigService.list((Wrapper)configLambdaQueryWrapper);
        if (commonQueryConfigs.size() > 0) {
            CommonQueryConfig temp = (CommonQueryConfig)commonQueryConfigs.get(0);
            String reltablename = temp.getReltablename();
            HashMap<String, Object> queryParams = new HashMap<String, Object>();
            queryParams.put("tablename", tableName);
            queryParams.put("objectid", objectId);
            List<Object> queryList = new ArrayList();
            if (layerName.equals(reltablename)) {
                queryList = this.commonQueryConfigService.identifyQuery(queryParams);
            } else {
                String fromfldname = temp.getFromfldname();
                String tofldname = temp.getTofldname();
                queryParams.put("reltablename", reltablename);
                queryParams.put("fromfldname", fromfldname);
                queryParams.put("tofldname", tofldname);
                queryList = this.commonQueryConfigService.identifyQuery2(queryParams);
            }
            if (queryList.size() > 0) {
                Map queryItem = (Map)queryList.get(0);
                for (int j = 0; j < commonQueryConfigs.size(); ++j) {
                    Object fldValue;
                    CommonQueryConfig configItem = (CommonQueryConfig)commonQueryConfigs.get(j);
                    String unit = configItem.getUnit();
                    String fieldType = configItem.getType();
                    String dictName = configItem.getDictname();
                    Integer pre = configItem.getPre();
                    String fldName = configItem.getFldname();
                    String fldAlias = configItem.getFldalias();
                    if (unit != null) {
                        fldAlias = fldAlias + "(" + unit + ")";
                    }
                    if ((fldValue = queryItem.get(fldName)) == null) {
                        result.put(fldAlias, (Object)"");
                        continue;
                    }
                    if (fieldType != null && fieldType == "N") {
                        double value = Double.parseDouble(fldValue.toString());
                        if (pre != null && pre > 0) {
                            BigDecimal bg = new BigDecimal(value);
                            value = bg.setScale((int)pre, 4).doubleValue();
                        }
                        result.put(fldAlias, (Object)value);
                        continue;
                    }
                    if (dictName != null) {
                        String val = fldValue.toString();
                        List dictItems = this.commonApi.queryEnableDictItemsByCode(dictName);
                        if (dictItems.size() > 0) {
                            for (int k = 0; k < dictItems.size(); ++k) {
                                DictModel dictItem = (DictModel)dictItems.get(k);
                                if (dictItem.getValue().indexOf(fldValue.toString()) <= -1) continue;
                                val = dictItem.getText();
                                break;
                            }
                        }
                        result.put(fldAlias, (Object)val);
                        continue;
                    }
                    result.put(fldAlias, (Object)fldValue.toString());
                }
            }
        }
        return Result.OK((Object)result);
    }

    @AutoLog(value="\u901a\u7528\u5c5e\u6027\u4fe1\u606f\u67e5\u8be2")
    @ApiOperation(value="\u901a\u7528\u5c5e\u6027\u4fe1\u606f\u67e5\u8be2", notes="\u901a\u7528\u5c5e\u6027\u4fe1\u606f\u67e5\u8be2")
    @GetMapping(value={"/commonQuery"})
    public Result<?> commonQuery(@RequestParam(name="queryType", required=true) String queryType, @RequestParam(name="queryList", required=true) String queryList, @RequestParam(name="queryInfo", required=true) String queryInfo, @RequestParam(name="returntree") Boolean returntree, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) throws SQLException {
        QueryResult queryResult = new QueryResult();
        queryResult = returntree != false ? this.doCommonQuery2(queryType, queryInfo, pageNo, pageSize) : this.doCommonQuery(queryType, queryList, queryInfo, pageNo, pageSize);
        return Result.OK((Object)queryResult);
    }

    private QueryResult doCommonQuery2(String queryType, String queryInfo, Integer pageNo, Integer pageSize) throws SQLException {
        QueryResult queryResult = new QueryResult();
        ArrayList<QueryRecord> queryRecords = new ArrayList<QueryRecord>();
        Integer total = 0;
        LambdaQueryWrapper configLambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)configLambdaQueryWrapper.eq(CommonQueryConfig::getTablename, (Object)queryType)).orderByAsc(CommonQueryConfig::getShoworder);
        List commonQueryConfigs = this.commonQueryConfigService.list((Wrapper)configLambdaQueryWrapper);
        if (commonQueryConfigs.size() > 0) {
            CommonQueryConfig temp = (CommonQueryConfig)commonQueryConfigs.get(0);
            String queryField = temp.getQfldname();
            String reltablename = temp.getReltablename();
            String otherfield = temp.getOtherfield();
            String returnArea = temp.getReturnarea();
            String fromfldname = temp.getFromfldname();
            String tofldname = temp.getTofldname();
            HashMap<String, Object> queryParams = new HashMap<String, Object>();
            queryParams.put("tablename", queryType);
            queryParams.put("queryfield", queryField);
            queryParams.put("queryinfo", queryInfo);
            queryParams.put("pageno", pageNo);
            queryParams.put("pagesize", pageSize);
            queryParams.put("reltablename", reltablename);
            queryParams.put("fromfldname", fromfldname);
            queryParams.put("tofldname", tofldname);
            queryParams.put("otherfield", otherfield);
            List<Object> queryList = new ArrayList();
            List queryList_curPage = new ArrayList();
            queryList = this.commonQueryConfigService.commonQuery4(queryParams);
            if (queryList.size() > 0) {
                total = queryList.size();
                queryList_curPage = CommonQueryConfigController.getListpaging(queryList, pageNo, pageSize);
                for (int i = 0; i < queryList_curPage.size(); ++i) {
                    QueryRecord queryRecord = new QueryRecord();
                    Map queryItem = (Map)queryList_curPage.get(i);
                    queryRecord.setId(queryItem.get(fromfldname).toString());
                    queryRecord.setName(queryItem.get(queryField).toString());
                    queryRecord.setLayerName(queryType);
                    JSONObject attribute = new JSONObject();
                    List<Object> queryList2 = new ArrayList();
                    String fromfldvalue = queryItem.get(fromfldname).toString();
                    queryParams.put("fromfldvalue", fromfldvalue);
                    queryList2 = this.commonQueryConfigService.commonQuery5(queryParams);
                    if (queryList2.size() <= 0) continue;
                    Map attrItem = (Map)queryList2.get(0);
                    for (int j = 0; j < commonQueryConfigs.size(); ++j) {
                        Object fldValue;
                        CommonQueryConfig configItem = (CommonQueryConfig)commonQueryConfigs.get(j);
                        String unit = configItem.getUnit();
                        String fieldType = configItem.getType();
                        String dictName = configItem.getDictname();
                        Integer pre = configItem.getPre();
                        String fldName = configItem.getFldname();
                        String fldAlias = configItem.getFldalias();
                        if (unit != null) {
                            fldAlias = fldAlias + "(" + unit + ")";
                        }
                        if ((fldValue = attrItem.get(fldName)) == null) {
                            attribute.put(fldAlias, (Object)"");
                            continue;
                        }
                        if (fieldType != null && fieldType == "N") {
                            double value = Double.parseDouble(fldValue.toString());
                            if (pre != null && pre > 0) {
                                BigDecimal bg = new BigDecimal(value);
                                value = bg.setScale((int)pre, 4).doubleValue();
                            }
                            attribute.put(fldAlias, (Object)value);
                            continue;
                        }
                        if (dictName != null) {
                            String val = fldValue.toString();
                            List dictItems = this.commonApi.queryEnableDictItemsByCode(dictName);
                            if (dictItems.size() > 0) {
                                for (int k = 0; k < dictItems.size(); ++k) {
                                    DictModel dictItem = (DictModel)dictItems.get(k);
                                    if (dictItem.getValue().indexOf(fldValue.toString()) <= -1) continue;
                                    val = dictItem.getText();
                                    break;
                                }
                            }
                            attribute.put(fldAlias, (Object)val);
                            continue;
                        }
                        attribute.put(fldAlias, (Object)fldValue.toString());
                    }
                    queryRecord.setAttributes(attribute);
                    JSONObject[] subInfos = new JSONObject[queryList2.size()];
                    for (int m = 0; m < queryList2.size(); ++m) {
                        Map subItem = (Map)queryList2.get(m);
                        JSONObject subInfo = new JSONObject();
                        subInfo.put("OBJECTID", (Object)subItem.get("OBJECTID").toString());
                        subInfo.put("mainInfo", (Object)subItem.get(otherfield).toString());
                        if (subItem.get("WKT") instanceof Clob) {
                            Clob clob = (Clob)subItem.get("WKT");
                            String wkt = clob.getSubString(1L, (int)clob.length());
                            subInfo.put("geoinfo", (Object)wkt);
                        } else {
                            subInfo.put("geoinfo", (Object)subItem.get("WKT").toString());
                        }
                        if ("true".equals(returnArea)) {
                            double shapeArea = Double.parseDouble(subItem.get("SHAPEAREA").toString());
                            subInfo.put("shapeArea", (Object)(String.format("%.2f", shapeArea) + "\u33a1"));
                        }
                        subInfos[m] = subInfo;
                    }
                    queryRecord.setSubInfos(subInfos);
                    queryRecords.add(queryRecord);
                }
            }
        }
        queryResult.setRecords(queryRecords);
        queryResult.setCurrent(pageNo);
        queryResult.setSize(pageSize);
        queryResult.setTotal(total);
        return queryResult;
    }

    private QueryResult doCommonQuery(String queryType, String query, String queryInfo, Integer pageNo, Integer pageSize) throws SQLException {
        QueryResult queryResult = new QueryResult();
        ArrayList<QueryRecord> queryRecords = new ArrayList<QueryRecord>();
        Integer total = 0;
        LambdaQueryWrapper configLambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)configLambdaQueryWrapper.eq(CommonQueryConfig::getTablename, (Object)queryType)).orderByAsc(CommonQueryConfig::getShoworder);
        List commonQueryConfigs = this.commonQueryConfigService.list((Wrapper)configLambdaQueryWrapper);
        if (commonQueryConfigs.size() > 0) {
            CommonQueryConfig temp = (CommonQueryConfig)commonQueryConfigs.get(0);
            String queryField = temp.getQfldname();
            String reltablename = temp.getReltablename();
            String otherfield = temp.getOtherfield();
            String returnArea = temp.getReturnarea();
            HashMap<String, Object> queryParams = new HashMap<String, Object>();
            queryParams.put("tablename", queryType);
            queryParams.put("queryfield", query);
            queryParams.put("queryinfo", queryInfo);
            queryParams.put("pageno", pageNo);
            queryParams.put("pagesize", pageSize);
            List<Object> queryList = new ArrayList();
            List queryList_curPage = new ArrayList();
            if (queryType.equals(reltablename)) {
                queryList = this.commonQueryConfigService.commonQuery(queryParams);
            } else {
                String fromfldname = temp.getFromfldname();
                String tofldname = temp.getTofldname();
                queryParams.put("reltablename", reltablename);
                queryParams.put("fromfldname", fromfldname);
                queryParams.put("tofldname", tofldname);
                if (otherfield != null) {
                    queryParams.put("otherfield", otherfield);
                    queryList = this.commonQueryConfigService.commonQuery3(queryParams);
                } else {
                    queryList = this.commonQueryConfigService.commonQuery2(queryParams);
                }
            }
            if (queryList.size() > 0) {
                total = queryList.size();
                queryList_curPage = CommonQueryConfigController.getListpaging(queryList, pageNo, pageSize);
                for (int i = 0; i < queryList_curPage.size(); ++i) {
                    QueryRecord queryRecord = new QueryRecord();
                    Map queryItem = (Map)queryList_curPage.get(i);
                    queryRecord.setId(queryItem.get("OBJECTID").toString());
                    if (queryItem.get(query) == null) continue;
                    queryRecord.setName(queryItem.get(query).toString());
                    if (queryItem.get("WKT") instanceof Clob) {
                        Clob clob = (Clob)queryItem.get("WKT");
                        String wkt = clob.getSubString(1L, (int)clob.length());
                        queryRecord.setGeoinfo(wkt);
                    } else {
                        queryRecord.setGeoinfo(queryItem.get("WKT").toString());
                    }
                    String otherInfo = "";
                    if (queryItem.get("DK") != null) {
                        queryRecord.setOtherInfo(queryItem.get("DK").toString());
                    }
                    if ("true".equals(returnArea)) {
                        double shapeArea = Double.parseDouble(queryItem.get("SHAPEAREA").toString());
                        otherInfo = otherInfo + " \u2014 " + String.format("%.2f", shapeArea) + "\u33a1";
                    }
                    queryRecord.setLayerName(queryType);
                    JSONObject attribute = new JSONObject();
                    for (int j = 0; j < commonQueryConfigs.size(); ++j) {
                        Object fldValue;
                        CommonQueryConfig configItem = (CommonQueryConfig)commonQueryConfigs.get(j);
                        String unit = configItem.getUnit();
                        String fieldType = configItem.getType();
                        String dictName = configItem.getDictname();
                        Integer pre = configItem.getPre();
                        String fldName = configItem.getFldname();
                        String fldAlias = configItem.getFldalias();
                        if (unit != null) {
                            fldAlias = fldAlias + "(" + unit + ")";
                        }
                        if ((fldValue = queryItem.get(fldName)) == null) {
                            attribute.put(fldAlias, (Object)"");
                            continue;
                        }
                        if (fieldType != null && fieldType == "N") {
                            double value = Double.parseDouble(fldValue.toString());
                            if (pre != null && pre > 0) {
                                BigDecimal bg = new BigDecimal(value);
                                value = bg.setScale((int)pre, 4).doubleValue();
                            }
                            attribute.put(fldAlias, (Object)value);
                            continue;
                        }
                        if (dictName != null) {
                            String val = fldValue.toString();
                            List dictItems = this.commonApi.queryEnableDictItemsByCode(dictName);
                            if (dictItems.size() > 0) {
                                for (int k = 0; k < dictItems.size(); ++k) {
                                    DictModel dictItem = (DictModel)dictItems.get(k);
                                    if (dictItem.getValue().indexOf(fldValue.toString()) <= -1) continue;
                                    val = dictItem.getText();
                                    break;
                                }
                            }
                            attribute.put(fldAlias, (Object)val);
                            continue;
                        }
                        attribute.put(fldAlias, (Object)fldValue.toString());
                    }
                    queryRecord.setAttributes(attribute);
                    queryRecords.add(queryRecord);
                }
            }
        }
        queryResult.setRecords(queryRecords);
        queryResult.setCurrent(pageNo);
        queryResult.setSize(pageSize);
        queryResult.setTotal(total);
        return queryResult;
    }

    private static List getListpaging(List list, int pageNo, int pageSize) {
        if (list == null || list.size() <= 0) {
            return new ArrayList(0);
        }
        int startIndex = (pageNo - 1) * pageSize;
        int endIndex = pageNo * pageSize;
        int total = list.size();
        int pageCount = 0;
        int num = total % pageSize;
        pageCount = num == 0 ? total / pageSize : total / pageSize + 1;
        if (pageNo == pageCount) {
            endIndex = total;
        }
        return list.subList(startIndex, endIndex);
    }

    @ApiOperation(value="\u901a\u8fc7\u6587\u4ef6\u7c7b\u578b\u67e5\u8be2\u5730\u5757\u4fe1\u606f-\u901a\u8fc7\u6587\u4ef6\u7c7b\u578b\u67e5\u8be2", notes="\u901a\u8fc7\u6587\u4ef6\u7c7b\u578b\u67e5\u8be2\u5730\u5757\u4fe1\u606f-\u901a\u8fc7\u6587\u4ef6\u7c7b\u578b\u67e5\u8be2")
    @GetMapping(value={"/queryByWjbh"})
    public Result<CommonQueryConfig> queryByWjbh(@RequestParam(name="wjbh", required=true) String wjbh) {
        CommonQueryConfig commonQueryConfig = (CommonQueryConfig)this.commonQueryConfigService.getById((Serializable)((Object)wjbh));
        if (commonQueryConfig == null) {
            return Result.error((String)"\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e");
        }
        return Result.OK((Object)commonQueryConfig);
    }
}

