/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.toolManage.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.system.vo.SelectTreeModel;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.base.model.TreeModel;
import org.jeecg.modules.toolManage.entity.Toolmanage;
import org.jeecg.modules.toolManage.service.IToolmanageService;
import org.jeecg.modules.topicManage.entity.TopicsConfig;
import org.jeecg.modules.topicManage.service.ITopicsConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u5730\u56fe\u5de5\u5177\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/toolManage/toolmanage"})
public class ToolmanageController
extends JeecgController<Toolmanage, IToolmanageService> {
    private static final Logger log = LoggerFactory.getLogger(ToolmanageController.class);
    @Autowired
    private IToolmanageService toolmanageService;
    @Autowired
    private ITopicsConfigService topicsConfigService;

    @AutoLog(value="\u5730\u56fe\u5de5\u5177-\u5730\u56fe\u5de5\u5177\u67e5\u8be2")
    @ApiOperation(value="\u5730\u56fe\u5de5\u5177-\u5730\u56fe\u5de5\u5177\u67e5\u8be2", notes="\u5730\u56fe\u5de5\u5177-\u5730\u56fe\u5de5\u5177\u67e5\u8be2")
    @GetMapping(value={"/toolListByUser"})
    public Result<?> getToolListByUserName(@RequestParam(value="username") String username, @RequestParam(value="topicId") String topicId) {
        List<Toolmanage> toolmanageList = this.toolmanageService.queryByUser(username);
        String disptools = "";
        if (!"null".equals(topicId) && !topicId.isEmpty()) {
            LambdaQueryWrapper topicsConfigLambdaQueryWrapper = new LambdaQueryWrapper();
            topicsConfigLambdaQueryWrapper.eq(TopicsConfig::getTopicid, (Object)topicId);
            TopicsConfig topicsConfig = (TopicsConfig)this.topicsConfigService.getOne((Wrapper)topicsConfigLambdaQueryWrapper);
            disptools = topicsConfig.getDisptools();
        }
        ArrayList<String> toolList = new ArrayList<String>();
        if (toolmanageList.size() > 0) {
            for (int i = 0; i < toolmanageList.size(); ++i) {
                Toolmanage toolmanage = toolmanageList.get(i);
                String registcode = toolmanage.getRegistcode();
                if (!disptools.isEmpty() && disptools.indexOf(registcode) == -1) continue;
                toolList.add(registcode);
            }
        }
        String[] tools = toolList.toArray(new String[toolList.size()]);
        return Result.OK((Object)tools);
    }

    @ApiOperation(value="\u5730\u56fe\u5de5\u5177\u7ba1\u7406-\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5730\u56fe\u5de5\u5177\u7ba1\u7406-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/rootList"})
    public Result<IPage<Toolmanage>> queryPageList(Toolmanage toolmanage, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        String hasQuery = req.getParameter("hasQuery");
        if (hasQuery != null && "true".equals(hasQuery)) {
            QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)toolmanage, (Map)req.getParameterMap());
            List<Toolmanage> list = this.toolmanageService.queryTreeListNoPage((QueryWrapper<Toolmanage>)queryWrapper);
            Page pageList = new Page(1L, 10L, (long)list.size());
            pageList.setRecords(list);
            return Result.OK((Object)pageList);
        }
        String parentId = toolmanage.getPid();
        if (oConvertUtils.isEmpty((Object)parentId)) {
            parentId = "0";
        }
        toolmanage.setPid(null);
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)toolmanage, (Map)req.getParameterMap());
        queryWrapper.eq((Object)"pid", (Object)parentId);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.toolmanageService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.OK((Object)pageList);
    }

    @RequestMapping(value={"/loadTreeChildren"}, method={RequestMethod.GET})
    public Result<List<SelectTreeModel>> loadTreeChildren(@RequestParam(name="pid") String pid) {
        Result result = new Result();
        try {
            List<SelectTreeModel> ls = this.toolmanageService.queryListByPid(pid);
            result.setResult(ls);
            result.setSuccess(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            result.setMessage(e.getMessage());
            result.setSuccess(false);
        }
        return result;
    }

    @RequestMapping(value={"/loadTreeRoot"}, method={RequestMethod.GET})
    public Result<List<SelectTreeModel>> loadTreeRoot(@RequestParam(name="async") Boolean async, @RequestParam(name="pcode") String pcode) {
        Result result = new Result();
        try {
            List<SelectTreeModel> ls = this.toolmanageService.queryListByCode(pcode);
            if (!async.booleanValue()) {
                this.loadAllChildren(ls);
            }
            result.setResult(ls);
            result.setSuccess(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            result.setMessage(e.getMessage());
            result.setSuccess(false);
        }
        return result;
    }

    private void loadAllChildren(List<SelectTreeModel> ls) {
        for (SelectTreeModel tsm : ls) {
            List<SelectTreeModel> temp = this.toolmanageService.queryListByPid(tsm.getKey());
            if (temp == null || temp.size() <= 0) continue;
            tsm.setChildren(temp);
            this.loadAllChildren(temp);
        }
    }

    @ApiOperation(value="\u5730\u56fe\u5de5\u5177\u7ba1\u7406-\u83b7\u53d6\u5b50\u6570\u636e", notes="\u5730\u56fe\u5de5\u5177\u7ba1\u7406-\u83b7\u53d6\u5b50\u6570\u636e")
    @GetMapping(value={"/childList"})
    public Result<IPage<Toolmanage>> queryPageList(Toolmanage toolmanage, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)toolmanage, (Map)req.getParameterMap());
        List list = this.toolmanageService.list((Wrapper)queryWrapper);
        Page pageList = new Page(1L, 10L, (long)list.size());
        pageList.setRecords(list);
        return Result.OK((Object)pageList);
    }

    @ApiOperation(value="\u5730\u56fe\u5de5\u5177\u7ba1\u7406-\u6279\u91cf\u83b7\u53d6\u5b50\u6570\u636e", notes="\u5730\u56fe\u5de5\u5177\u7ba1\u7406-\u6279\u91cf\u83b7\u53d6\u5b50\u6570\u636e")
    @GetMapping(value={"/getChildListBatch"})
    public Result getChildListBatch(@RequestParam(value="parentIds") String parentIds) {
        try {
            QueryWrapper queryWrapper = new QueryWrapper();
            List<String> parentIdList = Arrays.asList(parentIds.split(","));
            queryWrapper.in((Object)"pid", parentIdList);
            List list = this.toolmanageService.list((Wrapper)queryWrapper);
            Page pageList = new Page(1L, 10L, (long)list.size());
            pageList.setRecords(list);
            return Result.OK((Object)pageList);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)("\u6279\u91cf\u67e5\u8be2\u5b50\u8282\u70b9\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @AutoLog(value="\u5730\u56fe\u5de5\u5177\u7ba1\u7406-\u6dfb\u52a0")
    @ApiOperation(value="\u5730\u56fe\u5de5\u5177\u7ba1\u7406-\u6dfb\u52a0", notes="\u5730\u56fe\u5de5\u5177\u7ba1\u7406-\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<String> add(@RequestBody Toolmanage toolmanage) {
        this.toolmanageService.addToolmanage(toolmanage);
        return Result.OK((String)"\u6dfb\u52a0\u6210\u529f\uff01");
    }

    @AutoLog(value="\u5730\u56fe\u5de5\u5177\u7ba1\u7406-\u7f16\u8f91")
    @ApiOperation(value="\u5730\u56fe\u5de5\u5177\u7ba1\u7406-\u7f16\u8f91", notes="\u5730\u56fe\u5de5\u5177\u7ba1\u7406-\u7f16\u8f91")
    @RequestMapping(value={"/edit"}, method={RequestMethod.PUT, RequestMethod.POST})
    public Result<String> edit(@RequestBody Toolmanage toolmanage) {
        this.toolmanageService.updateToolmanage(toolmanage);
        return Result.OK((String)"\u7f16\u8f91\u6210\u529f!");
    }

    @AutoLog(value="\u5730\u56fe\u5de5\u5177\u7ba1\u7406-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u5730\u56fe\u5de5\u5177\u7ba1\u7406-\u901a\u8fc7id\u5220\u9664", notes="\u5730\u56fe\u5de5\u5177\u7ba1\u7406-\u901a\u8fc7id\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public Result<String> delete(@RequestParam(name="id", required=true) String id) {
        this.toolmanageService.deleteToolmanage(id);
        return Result.OK((String)"\u5220\u9664\u6210\u529f!");
    }

    @AutoLog(value="\u5730\u56fe\u5de5\u5177\u7ba1\u7406-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u5730\u56fe\u5de5\u5177\u7ba1\u7406-\u6279\u91cf\u5220\u9664", notes="\u5730\u56fe\u5de5\u5177\u7ba1\u7406-\u6279\u91cf\u5220\u9664")
    @DeleteMapping(value={"/deleteBatch"})
    public Result<String> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.toolmanageService.removeByIds(Arrays.asList(ids.split(",")));
        return Result.OK((String)"\u6279\u91cf\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u5730\u56fe\u5de5\u5177\u7ba1\u7406-\u901a\u8fc7id\u67e5\u8be2", notes="\u5730\u56fe\u5de5\u5177\u7ba1\u7406-\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<Toolmanage> queryById(@RequestParam(name="id", required=true) String id) {
        Toolmanage toolmanage = (Toolmanage)this.toolmanageService.getById((Serializable)((Object)id));
        if (toolmanage == null) {
            return Result.error((String)"\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e");
        }
        return Result.OK((Object)toolmanage);
    }

    @RequestMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, Toolmanage toolmanage) {
        return super.exportXls(request, (Object)toolmanage, Toolmanage.class, "\u5730\u56fe\u5de5\u5177\u7ba1\u7406");
    }

    @RequestMapping(value={"/importExcel"}, method={RequestMethod.POST})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, Toolmanage.class);
    }

    @RequestMapping(value={"/queryTreeList"}, method={RequestMethod.GET})
    public Result<Map<String, Object>> queryTreeList(HttpServletRequest request) {
        Result result = new Result();
        ArrayList<String> ids = new ArrayList<String>();
        try {
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            List list = this.toolmanageService.list((Wrapper)query);
            for (Toolmanage toolmanage : list) {
                ids.add(toolmanage.getId());
            }
            ArrayList<TreeModel> treeList = new ArrayList<TreeModel>();
            this.getTreeModelList(treeList, list, null);
            HashMap<String, ArrayList<Object>> toolMap = new HashMap<String, ArrayList<Object>>();
            toolMap.put("treeList", treeList);
            toolMap.put("ids", ids);
            result.setResult(toolMap);
            result.setSuccess(true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private void getTreeModelList(List<TreeModel> treeList, List<Toolmanage> toolmanageList, TreeModel temp) {
        for (Toolmanage toolmanage : toolmanageList) {
            String tempPid = toolmanage.getPid();
            Integer ruleFlag = 0;
            Boolean isLeaf = toolmanage.getHasChild().equals("0");
            TreeModel tree = new TreeModel(toolmanage.getId(), tempPid, toolmanage.getName(), ruleFlag, isLeaf);
            if (temp == null && "0".equals(tempPid)) {
                treeList.add(tree);
                if (tree.getIsLeaf()) continue;
                this.getTreeModelList(treeList, toolmanageList, tree);
                continue;
            }
            if (temp == null || tempPid == null || !tempPid.equals(temp.getKey())) continue;
            temp.getChildren().add(tree);
            if (tree.getIsLeaf()) continue;
            this.getTreeModelList(treeList, toolmanageList, tree);
        }
    }
}

