/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.demo.mock.vxe.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.MatchTypeEnum;
import org.jeecg.common.system.query.QueryCondition;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.modules.demo.mock.vxe.entity.MockEntity;
import org.jeecg.modules.demo.mock.vxe.websocket.VxeSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mock/vxe"})
public class VxeMockController {
    private static final Logger log = LoggerFactory.getLogger(VxeMockController.class);

    @GetMapping(value={"/change1"})
    public Result mockChange1(@RequestParam(value="id") String id, @RequestParam(value="status") String status) {
        JSONObject rowData = new JSONObject();
        rowData.put("id", (Object)id);
        rowData.put("status", (Object)status);
        this.mockChange(rowData);
        return Result.ok();
    }

    @Deprecated
    @GetMapping(value={"/change2"})
    public Result mockChange2(@RequestParam(value="id") String id, @RequestParam(value="tug_status") String tugStatus) {
        JSONObject rowData = new JSONObject();
        rowData.put("id", (Object)id);
        JSONObject status = JSON.parseObject((String)tugStatus);
        rowData.put("tug_status", (Object)status);
        this.mockChange(rowData);
        return Result.ok();
    }

    @GetMapping(value={"/change3"})
    public Result mockChange3(@RequestParam(value="id") String id, @RequestParam(value="progress") String progress) {
        JSONObject rowData = new JSONObject();
        rowData.put("id", (Object)id);
        rowData.put("progress", (Object)progress);
        this.mockChange(rowData);
        return Result.ok();
    }

    private void mockChange(JSONObject rowData) {
        JSONObject socketData = new JSONObject();
        socketData.put("socketKey", (Object)"page-dispatch");
        socketData.put("args", (Object)new Object[]{rowData, ""});
        String message = VxeSocket.packageMessage("update_vxe_table", socketData);
        VxeSocket.sendMessageToAll(message);
    }

    @GetMapping(value={"/change4"})
    public Result mockChange4(@RequestParam(value="status") String status) {
        JSONObject socketData = new JSONObject();
        socketData.put("key", (Object)"dispatch-dcds-status");
        socketData.put("args", (Object)new Object[]{status});
        String message = VxeSocket.packageMessage("common_send_date", socketData);
        VxeSocket.sendMessageToAll(message);
        return Result.ok();
    }

    @PutMapping(value={"/immediateSaveRow"})
    public Result mockImmediateSaveRow(@RequestBody JSONObject rowData) throws Exception {
        System.out.println("\u5373\u65f6\u4fdd\u5b58.rowData\uff1a" + rowData.toJSONString());
        Thread.sleep(500L);
        return Result.ok();
    }

    @PostMapping(value={"/immediateSaveAll"})
    public Result mockImmediateSaveAll(@RequestBody JSONArray tableData) throws Exception {
        System.out.println("\u5373\u65f6\u4fdd\u5b58.tableData\uff1a" + tableData.toJSONString());
        Thread.sleep(1000L);
        return Result.ok();
    }

    @GetMapping(value={"/getData"})
    public Result getMockData(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="parentId", required=false) String parentId) {
        String path = "classpath:org/jeecg/modules/demo/mock/vxe/json/dlglong.json";
        JSONArray dataList = this.readJsonData(path);
        if (dataList == null) {
            return Result.error((String)"\u8bfb\u53d6\u6570\u636e\u5931\u8d25\uff01");
        }
        IPage<JSONObject> page = this.queryDataPage(dataList, parentId, pageNo, pageSize);
        return Result.ok(page);
    }

    @GetMapping(value={"/getDdjhData"})
    public Result getMockDdjhData(MockEntity mockEntity, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="parentId", required=false) String parentId, @RequestParam(name="status", required=false) String status, @RequestParam(name="superQueryParams", required=false) String superQueryParams, @RequestParam(name="superQueryMatchType", required=false) String superQueryMatchType, HttpServletRequest request) {
        JSONArray dataList;
        Map parameterMap = request.getParameterMap();
        System.out.println("\ngetDdjhData - \u666e\u901a\u67e5\u8be2\u6761\u4ef6\uff1a");
        for (String key : parameterMap.keySet()) {
            System.out.println("-- " + key + ": " + JSON.toJSONString(parameterMap.get(key)));
        }
        try {
            System.out.println("\ngetDdjhData - \u9ad8\u7ea7\u67e5\u8be2\u6761\u4ef6\uff1a");
            MatchTypeEnum matchType = MatchTypeEnum.getByValue((String)superQueryMatchType);
            if (matchType == null) {
                System.out.println("-- \u9ad8\u7ea7\u67e5\u8be2\u6a21\u5f0f\uff1a\u4e0d\u8bc6\u522b\uff08" + superQueryMatchType + "\uff09");
            } else {
                System.out.println("-- \u9ad8\u7ea7\u67e5\u8be2\u6a21\u5f0f\uff1a" + matchType.getValue());
            }
            superQueryParams = URLDecoder.decode(superQueryParams, "UTF-8");
            List conditions = JSON.parseArray((String)superQueryParams, QueryCondition.class);
            if (conditions != null) {
                for (QueryCondition condition : conditions) {
                    System.out.println("-- " + JSON.toJSONString((Object)condition));
                }
            } else {
                System.out.println("-- \u6ca1\u6709\u4f20\u9012\u4efb\u4f55\u9ad8\u7ea7\u67e5\u8be2\u6761\u4ef6");
            }
            System.out.println();
        }
        catch (Exception e) {
            log.error("-- \u9ad8\u7ea7\u67e5\u8be2\u64cd\u4f5c\u5931\u8d25\uff1a" + superQueryParams, (Throwable)e);
            e.printStackTrace();
        }
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)mockEntity, (Map)parameterMap);
        System.out.println("queryWrapper\uff1a " + queryWrapper.getCustomSqlSegment());
        String path = "classpath:org/jeecg/modules/demo/mock/vxe/json/ddjh.json";
        String statusValue = "8";
        if (statusValue.equals(status)) {
            path = "classpath:org/jeecg/modules/demo/mock/vxe/json/ddjh_s8.json";
        }
        if ((dataList = this.readJsonData(path)) == null) {
            return Result.error((String)"\u8bfb\u53d6\u6570\u636e\u5931\u8d25\uff01");
        }
        IPage<JSONObject> page = this.queryDataPage(dataList, parentId, pageNo, pageSize);
        List records = page.getRecords();
        for (JSONObject record : records) {
            HashMap<String, Integer> tugStatusMap = new HashMap<String, Integer>(5);
            String id = record.getString("id");
            String tugMain = record.getString("tug");
            if (StringUtils.isNotBlank((CharSequence)tugMain)) {
                String[] tugs = tugMain.split(";");
                List subRecords = this.queryDataPage(dataList, id, null, null).getRecords();
                block5: for (JSONObject subData : subRecords) {
                    String subTug = subData.getString("tug");
                    if (!StringUtils.isNotBlank((CharSequence)subTug)) continue;
                    for (String tug : tugs) {
                        String returnTime;
                        String workEndTime;
                        String workBeginTime;
                        if (!tug.equals(subTug)) continue;
                        int statusCode = 0;
                        String departureTime = subData.getString("departure_time");
                        if (StringUtils.isNotBlank((CharSequence)departureTime)) {
                            ++statusCode;
                        }
                        if (StringUtils.isNotBlank((CharSequence)(workBeginTime = subData.getString("work_begin_time")))) {
                            ++statusCode;
                        }
                        if (StringUtils.isNotBlank((CharSequence)(workEndTime = subData.getString("work_end_time")))) {
                            ++statusCode;
                        }
                        if (StringUtils.isNotBlank((CharSequence)(returnTime = subData.getString("return_time")))) {
                            ++statusCode;
                        }
                        tugStatusMap.put(tug, statusCode);
                        continue block5;
                    }
                }
            }
            record.put("tug_status", tugStatusMap);
        }
        page.setRecords(records);
        return Result.ok(page);
    }

    private IPage<JSONObject> queryDataPage(JSONArray dataList, String parentId, Integer pageNo, Integer pageSize) {
        long endIndex;
        long beginIndex;
        Page page;
        JSONArray dataDb = dataList;
        if (StringUtils.isNotBlank((CharSequence)parentId)) {
            JSONArray results = new JSONArray();
            List<String> parentIds = Arrays.asList(parentId.split(","));
            this.queryByParentId(dataDb, parentIds, results);
            dataDb = results;
        }
        ArrayList<JSONObject> records = new ArrayList<JSONObject>();
        if (pageNo == null || pageSize == null) {
            page = new Page(0L, (long)dataDb.size());
            beginIndex = 0L;
            endIndex = dataDb.size();
        } else {
            page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
            beginIndex = page.offset();
            endIndex = page.offset() + page.getSize();
        }
        for (long i = beginIndex; i < endIndex && i < (long)dataDb.size(); ++i) {
            JSONObject data = dataDb.getJSONObject((int)i);
            data = JSON.parseObject((String)data.toJSONString());
            data.remove((Object)"children");
            records.add(data);
        }
        page.setRecords(records);
        page.setTotal((long)dataDb.size());
        return page;
    }

    private void queryByParentId(JSONArray dataList, List<String> parentIds, JSONArray results) {
        for (int i = 0; i < dataList.size(); ++i) {
            JSONObject data = dataList.getJSONObject(i);
            JSONArray children = data.getJSONArray("children");
            if (parentIds.contains(data.getString("id"))) {
                if (children == null) continue;
                results.addAll((Collection)children);
                continue;
            }
            if (children == null) continue;
            this.queryByParentId(children, parentIds, results);
        }
        results.addAll((Collection)new JSONArray());
    }

    private JSONArray readJsonData(String path) {
        try {
            InputStream stream = this.getClass().getClassLoader().getResourceAsStream(path.replace("classpath:", ""));
            if (stream != null) {
                String json = IOUtils.toString((InputStream)stream, (String)"UTF-8");
                return JSON.parseArray((String)json);
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

