/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.geoAnalysis.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.modules.commonQueryConfig.entity.CommonQueryConfig;
import org.jeecg.modules.geoAnalysis.entity.DetailsResult;
import org.jeecg.modules.geoAnalysis.entity.GeoAnalysis;
import org.jeecg.modules.geoAnalysis.entity.ZYFXPZB;
import org.jeecg.modules.geoAnalysis.service.IGeoAnlysisService;
import org.jeecg.modules.geoAnalysis.service.impl.GeoAnalysisServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5206\u6790"})
@RestController
@RequestMapping(value={"/geoAnalysis/Analysis"})
public class GeoAnalysisController
extends JeecgController<GeoAnalysis, IGeoAnlysisService> {
    private static final Logger log = LoggerFactory.getLogger(GeoAnalysisController.class);
    @Autowired
    GeoAnalysisServiceImpl geoAnalysisService;

    @AutoLog(value="")
    @ApiOperation(value=" \u901a\u8fc7\u83b7\u53d6\u5750\u6807\u4e32\u8fdb\u884c\u5206\u6790", notes=" \u901a\u8fc7\u83b7\u53d6\u5750\u6807\u4e32\u8fdb\u884c\u5206\u6790")
    @GetMapping(value={"/DrawMap"})
    public Result<?> DrawMapByzb(@RequestParam(name="jwd", required=false) String jwd, @RequestParam(name="table", required=false) String table, @RequestParam(name="atableename", required=false) String atableename) {
        String[] split = atableename.split(",");
        String[] shape = jwd.split(",");
        ArrayList<ZYFXPZB> yj_kszlq = new ArrayList<ZYFXPZB>();
        if (atableename.contains(",")) {
            for (String s : split) {
                ZYFXPZB zyfxpzb = this.geoAnalysisService.SelectByTbs(table, s);
                yj_kszlq.add(zyfxpzb);
            }
        } else {
            ZYFXPZB zyfxpzb = this.geoAnalysisService.SelectByTbs(table, atableename);
            yj_kszlq.add(zyfxpzb);
        }
        ArrayList<GeoAnalysis> geoAnalyses = this.geoAnalysisService.DrawMap(yj_kszlq, shape);
        System.out.println(geoAnalyses);
        return Result.OK((String)"\u6210\u529f", geoAnalyses);
    }

    @AutoLog(value="")
    @ApiOperation(value=" \u901a\u8fc7\u83b7\u53d6\u8868\u540d\u548c\u5750\u6807\u5206\u6790", notes=" \u901a\u8fc7\u83b7\u53d6\u8868\u540d\u548c\u5750\u6807\u5206\u6790")
    @GetMapping(value={"/DrawMapByid"})
    public Result<?> DrawMapByid(@RequestParam(name="table", required=false) String table, @RequestParam(name="jwd", required=false) String jwd, @RequestParam(name="atableename", required=false) String atableename) {
        ArrayList<ZYFXPZB> yj_kszlq = new ArrayList<ZYFXPZB>();
        String[] shape = jwd.split(",");
        if (atableename.contains(",")) {
            String[] split;
            for (String s : split = atableename.split(",")) {
                ZYFXPZB zyfxpzb = this.geoAnalysisService.SelectByTbs(table, s);
                yj_kszlq.add(zyfxpzb);
            }
        } else {
            ZYFXPZB zyfxpzb = this.geoAnalysisService.SelectByTbs(table, atableename);
            yj_kszlq.add(zyfxpzb);
        }
        ArrayList<GeoAnalysis> geoAnalyses = this.geoAnalysisService.DrawMapByShape(yj_kszlq, shape, table);
        System.out.println(geoAnalyses);
        return Result.OK((String)"\u6210\u529f", geoAnalyses);
    }

    @AutoLog(value="")
    @ApiOperation(value=" \u901a\u8fc7\u83b7\u53d6\u8868\u540d\u67e5\u8be2\u5206\u6790\u56fe\u5c42", notes=" \u901a\u8fc7\u83b7\u53d6\u8868\u540d\u67e5\u8be2\u5206\u6790\u56fe\u5c42")
    @GetMapping(value={"/SelectByTb"})
    public Result<?> SelectByTb(@RequestParam(name="table", required=false) String table) {
        List<ZYFXPZB> zyfxpzbs = this.geoAnalysisService.SelectByTb(table);
        return Result.OK((String)"\u6210\u529f", zyfxpzbs);
    }

    @AutoLog(value="")
    @ApiOperation(value=" \u5bfc\u51fashape\u6587\u4ef6", notes=" \u5bfc\u51fashape\u6587\u4ef6")
    @GetMapping(value={"/exportShapes"})
    public Result<?> exportShapes(HttpServletResponse response, @RequestParam(name="id", required=false) String id) {
        Boolean aBoolean = this.geoAnalysisService.exportShps(response, id);
        return Result.OK((String)"\u6210\u529f", (Object)aBoolean);
    }

    @AutoLog(value="")
    @ApiOperation(value=" \u5206\u6790\u67e5\u770b\u8be6\u60c5\u4fe1\u606f", notes=" \u5206\u6790\u67e5\u770b\u8be6\u60c5\u4fe1\u606f")
    @GetMapping(value={"/SelectDetails"})
    public Result<?> SelectDetails(@RequestParam(name="table", required=false) String table, @RequestParam(name="objectid", required=false) String objectid) {
        LinkedHashMap<String, String> maps = new LinkedHashMap<String, String>();
        String[] split = null;
        Object objectids = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        String tables = null;
        split = objectid.contains(",") ? objectid.split(",") : new String[]{objectid};
        ArrayList<String> arr = new ArrayList<String>();
        ArrayList<DetailsResult> arrayList = new ArrayList<DetailsResult>();
        ArrayList<CommonQueryConfig> list = this.geoAnalysisService.SelectByTable(table);
        for (CommonQueryConfig commonQueryConfig : list) {
            String fldalias = commonQueryConfig.getFldalias();
            String unit = commonQueryConfig.getUnit();
            String fldname = commonQueryConfig.getFldname();
            Integer pre = commonQueryConfig.getPre();
            StringBuilder filed = new StringBuilder();
            if (commonQueryConfig.getUnit() != null) {
                filed.append(fldalias);
                filed.append("\uff08" + unit + "\uff09");
            } else {
                filed.append(fldalias);
            }
            maps.put(commonQueryConfig.getFldname(), filed.toString());
            if (commonQueryConfig.getPre() != null) {
                commonQueryConfig.setFldname("round(" + fldname + "," + pre + ") as " + fldname);
            }
            arr.add(commonQueryConfig.getFldname());
            tables = commonQueryConfig.getAnalysistablename();
        }
        for (String s : split) {
            DetailsResult result1 = new DetailsResult();
            result1.setFldalia(maps);
            map.put("table", tables);
            map.put("shape", arr);
            map.put("id", s);
            HashMap<String, Object> hashMaps = this.geoAnalysisService.SelectDetails(map);
            for (String s1 : hashMaps.keySet()) {
                if (!(hashMaps.get(s1) instanceof Clob)) continue;
                Clob clob = (Clob)hashMaps.get(s1);
                try {
                    hashMaps.put(s1, clob.getSubString(1L, (int)clob.length()));
                }
                catch (SQLException throwables) {
                    throwables.printStackTrace();
                }
            }
            result1.setResult(hashMaps);
            arrayList.add(result1);
        }
        System.out.println(arrayList);
        return Result.OK((String)"\u6210\u529f", arrayList);
    }
}

