/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.common.comm.io;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.common.comm.io.BoundedInputStream;
import com.aliyun.oss.common.utils.LogUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;

public class RepeatableBoundedFileInputStream
extends InputStream {
    private BoundedInputStream bis = null;
    private FileChannel fileChannel = null;
    private long markPos = 0L;

    public RepeatableBoundedFileInputStream(BoundedInputStream bis) throws IOException {
        FileInputStream fin = (FileInputStream)bis.getWrappedInputStream();
        this.bis = bis;
        this.fileChannel = fin.getChannel();
        this.markPos = this.fileChannel.position();
    }

    @Override
    public void reset() throws IOException {
        this.bis.backoff(this.fileChannel.position() - this.markPos);
        this.fileChannel.position(this.markPos);
        LogUtils.getLog().trace((Object)("Reset to position " + this.markPos));
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readlimit) {
        try {
            this.markPos = this.fileChannel.position();
        }
        catch (IOException e) {
            throw new ClientException("Failed to mark file position", e);
        }
        LogUtils.getLog().trace((Object)("File input stream marked at position " + this.markPos));
    }

    @Override
    public int available() throws IOException {
        return this.bis.available();
    }

    @Override
    public void close() throws IOException {
        this.bis.close();
    }

    @Override
    public int read() throws IOException {
        return this.bis.read();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.bis.skip(n);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.bis.read(b, off, len);
    }

    public InputStream getWrappedInputStream() {
        return this.bis;
    }
}

