/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator;

import com.googlecode.aviator.AviatorEvaluatorInstance;
import com.googlecode.aviator.BaseExpression;
import com.googlecode.aviator.exception.ExpressionNotFoundException;
import com.googlecode.aviator.exception.ExpressionRuntimeException;
import com.googlecode.aviator.lexer.SymbolTable;
import com.googlecode.aviator.parser.VariableMeta;
import com.googlecode.aviator.runtime.LambdaFunctionBootstrap;
import com.googlecode.aviator.runtime.RuntimeUtils;
import com.googlecode.aviator.runtime.function.LambdaFunction;
import com.googlecode.aviator.utils.Env;
import com.googlecode.aviator.utils.Reflector;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ClassExpression
extends BaseExpression {
    protected Map<String, LambdaFunctionBootstrap> lambdaBootstraps;

    public Map<String, LambdaFunctionBootstrap> getLambdaBootstraps() {
        return this.lambdaBootstraps;
    }

    public void setLambdaBootstraps(Map<String, LambdaFunctionBootstrap> lambdaBootstraps) {
        this.lambdaBootstraps = lambdaBootstraps;
    }

    public ClassExpression(AviatorEvaluatorInstance instance, List<VariableMeta> vars, SymbolTable symbolTable) {
        super(instance, vars, symbolTable);
    }

    public LambdaFunction newLambda(Env env, String name) {
        LambdaFunctionBootstrap bootstrap = this.lambdaBootstraps.get(name);
        if (bootstrap == null) {
            throw new ExpressionNotFoundException("Lambda " + name + " not found");
        }
        return bootstrap.newInstance(env);
    }

    @Override
    public Object executeDirectly(Map<String, Object> env) {
        try {
            Object result = this.execute0((Env)env);
            if (RuntimeUtils.isTracedEval(env)) {
                RuntimeUtils.printlnTrace(env, "Result : " + result);
            }
            return result;
        }
        catch (ExpressionRuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Reflector.sneakyThrow(t);
        }
    }

    @Override
    protected void afterPopulateFullNames(Map<String, VariableMeta> fullNames, Set<String> parentVars) {
        if (this.lambdaBootstraps != null) {
            for (LambdaFunctionBootstrap bootstrap : this.lambdaBootstraps.values()) {
                for (VariableMeta meta : bootstrap.getClosureOverFullVarNames()) {
                    VariableMeta existsMeta = fullNames.get(meta.getName());
                    if (existsMeta == null) {
                        if (parentVars.contains(meta.getName())) continue;
                        fullNames.put(meta.getName(), meta);
                        continue;
                    }
                    if (existsMeta.getFirstIndex() <= meta.getFirstIndex()) continue;
                    fullNames.put(meta.getName(), meta);
                }
            }
        }
    }

    public abstract Object execute0(Env var1);

    public Class<?> getJavaClass() {
        return this.getClass();
    }
}

