/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime;

import com.googlecode.aviator.BaseExpression;
import com.googlecode.aviator.Expression;
import com.googlecode.aviator.parser.VariableMeta;
import com.googlecode.aviator.runtime.FunctionParam;
import com.googlecode.aviator.runtime.function.LambdaFunction;
import com.googlecode.aviator.utils.Env;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LambdaFunctionBootstrap {
    private final String name;
    private final BaseExpression expression;
    private final List<FunctionParam> params;
    private final boolean inheritEnv;
    private final ThreadLocal<LambdaFunction> fnLocal = new ThreadLocal();

    public String getName() {
        return this.name;
    }

    public LambdaFunctionBootstrap(String name, Expression expression, List<FunctionParam> arguments, boolean inheritEnv) {
        this.name = name;
        this.expression = (BaseExpression)expression;
        this.params = arguments;
        this.inheritEnv = inheritEnv;
    }

    public Collection<VariableMeta> getClosureOverFullVarNames() {
        Map<String, VariableMeta> fullNames = this.expression.getFullNameMetas();
        for (FunctionParam param : this.params) {
            fullNames.remove(param.getName());
        }
        Iterator<Map.Entry<String, VariableMeta>> it = fullNames.entrySet().iterator();
        block1: while (it.hasNext()) {
            Map.Entry<String, VariableMeta> fullName = it.next();
            for (FunctionParam param : this.params) {
                if (!fullName.getKey().startsWith(param.getName() + ".")) continue;
                it.remove();
                continue block1;
            }
        }
        return fullNames.values();
    }

    public Expression getExpression() {
        return this.expression;
    }

    public LambdaFunction newInstance(Env env) {
        LambdaFunction fn = null;
        if (this.inheritEnv && (fn = this.fnLocal.get()) != null) {
            fn.setContext(env);
            return fn;
        }
        fn = new LambdaFunction(this.name, this.params, this.expression, env);
        fn.setInheritEnv(this.inheritEnv);
        if (this.inheritEnv) {
            this.fnLocal.set(fn);
        }
        return fn;
    }
}

