/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.function.math;

import com.googlecode.aviator.runtime.RuntimeUtils;
import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.function.FunctionUtils;
import com.googlecode.aviator.runtime.type.AviatorBigInt;
import com.googlecode.aviator.runtime.type.AviatorDecimal;
import com.googlecode.aviator.runtime.type.AviatorDouble;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.utils.TypeUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;

public class MathPowFunction
extends AbstractFunction {
    private static final long serialVersionUID = 5909888819672336251L;

    @Override
    public AviatorObject call(Map<String, Object> env, AviatorObject arg1, AviatorObject arg2) {
        Number left = FunctionUtils.getNumberValue(arg1, env);
        Number right = FunctionUtils.getNumberValue(arg2, env);
        if (TypeUtils.isBigInt(left)) {
            return new AviatorBigInt(((BigInteger)left).pow(right.intValue()));
        }
        if (TypeUtils.isDecimal(left)) {
            return new AviatorDecimal(((BigDecimal)left).pow(right.intValue(), RuntimeUtils.getMathContext(env)));
        }
        return new AviatorDouble(Math.pow(left.doubleValue(), right.doubleValue()));
    }

    @Override
    public String getName() {
        return "math.pow";
    }
}

