/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.aop;

import com.baomidou.dynamic.datasource.processor.DsProcessor;
import com.baomidou.dynamic.datasource.support.DataSourceClassResolver;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class DynamicDataSourceAnnotationInterceptor
implements MethodInterceptor {
    private static final String DYNAMIC_PREFIX = "#";
    private static final DataSourceClassResolver RESOLVER = new DataSourceClassResolver();
    private DsProcessor dsProcessor;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        try {
            DynamicDataSourceContextHolder.push(this.determineDatasource(invocation));
            Object object = invocation.proceed();
            return object;
        }
        finally {
            DynamicDataSourceContextHolder.poll();
        }
    }

    private String determineDatasource(MethodInvocation invocation) {
        String key = RESOLVER.findDSKey(invocation.getMethod(), invocation.getThis());
        return !key.isEmpty() && key.startsWith(DYNAMIC_PREFIX) ? this.dsProcessor.determineDatasource(invocation, key) : key;
    }

    public void setDsProcessor(DsProcessor dsProcessor) {
        this.dsProcessor = dsProcessor;
    }
}

