/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg.hsql;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.geotools.referencing.factory.epsg.hsql.SqlScriptReader;
import org.geotools.referencing.factory.epsg.hsql.ThreadedHsqlEpsgFactory;
import org.hsqldb.jdbc.JDBCDataSource;

public class DatabaseCreationScript {
    public static void main(String[] args) throws Exception {
        File[] files;
        String inputDirectory = "./src/main/resources/org/geotools/referencing/factory/epsg/";
        File directory = new File(inputDirectory);
        File propertyFile = new File(directory, "EPSG.properties");
        File databaseFile = new File(directory, "EPSG.data");
        File backupFile = new File(directory, "EPSG.backup");
        File scriptFile = new File(directory, "EPSG.script");
        File zipFile = new File(directory, "EPSG.zip");
        propertyFile.delete();
        databaseFile.delete();
        backupFile.delete();
        scriptFile.delete();
        zipFile.delete();
        JDBCDataSource source = new JDBCDataSource();
        StringBuilder url = new StringBuilder("jdbc:hsqldb:file:");
        String path = directory.getAbsolutePath().replace(File.separatorChar, '/');
        if (path.length() == 0 || path.charAt(0) != '/') {
            url.append('/');
        }
        url.append(path);
        if (url.charAt(url.length() - 1) != '/') {
            url.append('/');
        }
        url.append("EPSG");
        source.setDatabase(url.toString());
        source.setUser("SA");
        Connection connection = source.getConnection();
        System.out.println("Creating the EPSG database");
        Statement statement = connection.createStatement();
        try {
            DatabaseCreationScript.executeScript(new File(directory, "EPSG_Tables.sql"), statement);
            DatabaseCreationScript.executeScript(new File(directory, "EPSG_Data.sql"), statement);
            statement.execute("UPDATE EPSG_DATUM SET REALIZATION_EPOCH = NULL WHERE REALIZATION_EPOCH = ''");
            statement.execute("ALTER TABLE EPSG_DATUM ALTER COLUMN REALIZATION_EPOCH INTEGER");
            DatabaseCreationScript.executeScript(new File(directory, "EPSG_FKeys.sql"), statement);
            DatabaseCreationScript.executeScript(new File(directory, "EPSG_Indexes.sql"), statement);
            statement.execute("SHUTDOWN COMPACT");
        }
        catch (IOException exception) {
            SQLException e = new SQLException("Error occurred while executing the EPSG database creation scripts");
            e.initCause(exception);
            throw e;
        }
        finally {
            statement.close();
            connection.close();
        }
        System.out.println("EPSG database created");
        FileInputStream propertyIn = new FileInputStream(propertyFile);
        Properties properties = new Properties();
        properties.load(propertyIn);
        ((InputStream)propertyIn).close();
        properties.put("epsg.version", ThreadedHsqlEpsgFactory.VERSION.toString());
        properties.put("readonly", "true");
        FileOutputStream out = new FileOutputStream(propertyFile);
        properties.store(out, "EPSG database on HSQL");
        ((OutputStream)out).close();
        System.out.println("Creating the zipped database");
        byte[] buf = new byte[1024];
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipFile));
        for (File file : files = new File[]{databaseFile, propertyFile, scriptFile}) {
            int len;
            FileInputStream in = new FileInputStream(file);
            zos.putNextEntry(new ZipEntry(file.getName()));
            while ((len = in.read(buf)) > 0) {
                zos.write(buf, 0, len);
            }
            zos.closeEntry();
            in.close();
        }
        zos.close();
        System.out.println("Cleaning up the unzipped database files");
        propertyFile.delete();
        databaseFile.delete();
        backupFile.delete();
        scriptFile.delete();
        System.out.println("Done. The zipped database file is available at " + zipFile.getAbsolutePath());
    }

    static void executeScript(File scriptFile, Statement statement) throws IOException, SQLException {
        System.out.println("Executing script " + scriptFile.getPath());
        SqlScriptReader reader = null;
        try {
            reader = new SqlScriptReader(new InputStreamReader((InputStream)new FileInputStream(scriptFile), "ISO-8859-15"));
            while (reader.hasNext()) {
                statement.execute(reader.next());
            }
        }
        finally {
            if (reader != null) {
                reader.dispose();
            }
        }
    }
}

