/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.util.Converters;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;

public class CategorizeFunction
implements Function {
    public static final String SUCCEEDING = "succeeding";
    public static final String PRECEDING = "preceding";
    public static final String RASTER_DATA = "Rasterdata";
    private final List<Expression> parameters;
    private final Literal fallback;
    private boolean staticTable = true;
    double[] thresholds;
    Expression[] values;
    volatile Object[] convertedValues;
    private Class convertedValuesContext;
    private String belongsTo;
    public static final FunctionName NAME = new FunctionNameImpl("Categorize", "LookupValue", "Value", "Threshold 1", "Value 1", "Threshold 2", "Value 2", "succeeding or preceding");

    public CategorizeFunction() {
        this(new ArrayList<Expression>(), null);
    }

    public CategorizeFunction(List<Expression> parameters, Literal fallback) {
        this.parameters = parameters;
        this.fallback = fallback;
        if (parameters.size() % 2 != 0) {
            Expression lastParameter = parameters.get(parameters.size() - 1);
            String lastValue = (String)lastParameter.evaluate(null, String.class);
            if (PRECEDING.equalsIgnoreCase(lastValue)) {
                this.belongsTo = PRECEDING;
            } else if (SUCCEEDING.equalsIgnoreCase(lastValue)) {
                this.belongsTo = SUCCEEDING;
            } else {
                throw new IllegalArgumentException("The valid structure of a categorize function call is \"lookup, value, [threshold, value]*, [succeeding|preceding]\", yet there is a odd number of parameters and the last value is not succeeding nor preceeding");
            }
        }
        FilterAttributeExtractor extractor = new FilterAttributeExtractor();
        this.thresholds = new double[(parameters.size() - 1) / 2];
        this.values = new Expression[this.thresholds.length + 1];
        for (int i = 1; i < parameters.size(); ++i) {
            Expression expression = parameters.get(i);
            if (expression == null) continue;
            extractor.clear();
            expression.accept((ExpressionVisitor)extractor, null);
            if (!extractor.isConstantExpression()) {
                this.staticTable = false;
                this.thresholds = null;
                break;
            }
            if (i % 2 == 0) {
                Double threshold = (Double)expression.evaluate(null, Double.class);
                if (threshold == null) {
                    this.staticTable = false;
                    this.thresholds = null;
                    break;
                }
                this.thresholds[i / 2 - 1] = threshold;
                continue;
            }
            this.values[i / 2] = expression;
        }
        if (this.thresholds != null) {
            Arrays.sort(this.thresholds);
        }
    }

    public String getName() {
        return NAME.getName();
    }

    public FunctionName getFunctionName() {
        return NAME;
    }

    public List<Expression> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public Object accept(ExpressionVisitor visitor, Object extraData) {
        return visitor.visit((Function)this, extraData);
    }

    public Object evaluate(Object object) {
        return this.evaluate(object, Object.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T evaluate(Object object, Class<T> context) {
        Expression lookupExp = this.parameters.get(0);
        Double value = (Double)lookupExp.evaluate(object, Double.class);
        if (value == null) {
            value = (Double)Converters.convert((Object)object, Double.class);
        }
        if (value != null && this.staticTable) {
            int expIdx = Arrays.binarySearch(this.thresholds, value);
            int valIdx = expIdx >= 0 ? (PRECEDING.equals(this.belongsTo) ? expIdx : expIdx + 1) : -expIdx - 1;
            if (this.convertedValues == null) {
                CategorizeFunction categorizeFunction = this;
                synchronized (categorizeFunction) {
                    if (this.convertedValues == null) {
                        this.convertedValues = new Object[this.values.length];
                        for (int i = 0; i < this.convertedValues.length; ++i) {
                            this.convertedValues[i] = this.values[i].evaluate(object, context);
                        }
                        this.convertedValuesContext = context;
                    }
                }
            }
            if (this.convertedValuesContext == context) {
                return (T)this.convertedValues[valIdx];
            }
            return (T)this.values[valIdx].evaluate(object, context);
        }
        Expression currentExp = this.parameters.get(1);
        if (this.parameters.size() == 2) {
            return (T)currentExp.evaluate(object, context);
        }
        List<Expression> splits = this.parameters.size() % 2 == 0 ? this.parameters.subList(2, this.parameters.size()) : this.parameters.subList(2, this.parameters.size() - 1);
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
        for (int i = 0; i < splits.size(); i += 2) {
            Expression threshholdExp = splits.get(i);
            Expression rangedExp = splits.get(i + 1);
            Object isIncludedInThreshold = PRECEDING.equals(this.belongsTo) ? ff.greater(lookupExp, threshholdExp) : ff.greaterOrEqual(lookupExp, threshholdExp);
            if (!isIncludedInThreshold.evaluate(object)) break;
            currentExp = rangedExp;
        }
        return (T)currentExp.evaluate(object, context);
    }

    public Literal getFallbackValue() {
        return this.fallback;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append("(");
        List<Expression> params = this.getParameters();
        if (params != null) {
            Iterator<Expression> it = params.iterator();
            while (it.hasNext()) {
                Expression exp = it.next();
                sb.append("[");
                sb.append(exp);
                sb.append("]");
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CategorizeFunction that = (CategorizeFunction)o;
        return this.staticTable == that.staticTable && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.fallback, that.fallback) && Arrays.equals(this.thresholds, that.thresholds) && Arrays.equals(this.values, that.values) && Arrays.equals(this.convertedValues, that.convertedValues) && Objects.equals(this.convertedValuesContext, that.convertedValuesContext) && Objects.equals(this.belongsTo, that.belongsTo);
    }

    public int hashCode() {
        int result = Objects.hash(this.parameters, this.fallback, this.staticTable, this.convertedValuesContext, this.belongsTo);
        result = 31 * result + Arrays.hashCode(this.thresholds);
        result = 31 * result + Arrays.hashCode(this.values);
        result = 31 * result + Arrays.hashCode(this.convertedValues);
        return result;
    }
}

