/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import it.geosolutions.jaiext.range.NoDataContainer;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.TypeMap;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.image.ImageWorker;
import org.geotools.renderer.i18n.Errors;
import org.geotools.renderer.i18n.Vocabulary;
import org.geotools.renderer.lite.gridcoverage2d.BaseCoverageProcessingNode;
import org.geotools.renderer.lite.gridcoverage2d.CoverageProcessingNode;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.factory.Hints;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.util.InternationalString;

class BandMergeNode
extends BaseCoverageProcessingNode
implements CoverageProcessingNode {
    private Stack<RenderedImage> intermediateOps = new Stack();
    private RenderedImage alpha;

    @Override
    public InternationalString getName() {
        return Vocabulary.formatInternational(1);
    }

    @Override
    public void dispose(boolean force) {
        Iterator it = this.intermediateOps.iterator();
        while (it.hasNext()) {
            PlanarImage image = PlanarImage.wrapRenderedImage((RenderedImage)((RenderedImage)it.next()));
            image.dispose();
        }
        super.dispose(force);
    }

    public BandMergeNode(Hints hints) {
        super(3, hints, (InternationalString)SimpleInternationalString.wrap((CharSequence)"BandMergeNode"), (InternationalString)SimpleInternationalString.wrap((CharSequence)"Node which applies a BandMergeNode following SLD 1.0 spec."));
    }

    @Override
    protected GridCoverage execute() {
        assert (this.getSources().size() <= 3);
        List<CoverageProcessingNode> sources = this.getSources();
        if (sources != null && !sources.isEmpty()) {
            boolean hasAlpha;
            int size = sources.size();
            boolean bl = hasAlpha = this.alpha != null;
            if (size == 1 && !hasAlpha) {
                return this.getSource(0).getOutput();
            }
            if (size != 3 && size != 1) {
                throw new IllegalArgumentException(Errors.format(1, size));
            }
            Iterator<CoverageProcessingNode> it = sources.iterator();
            RenderedImage op = null;
            GridGeometry2D gridGeometry = null;
            ImageLayout layout = null;
            Hints hints = this.getHints();
            ArrayList<GridCoverage2D> sourceGridCoverages = new ArrayList<GridCoverage2D>();
            ImageWorker w = new ImageWorker();
            do {
                CoverageProcessingNode currentSourceNode = it.next();
                GridCoverage2D currentSourceCoverage = (GridCoverage2D)currentSourceNode.getOutput();
                sourceGridCoverages.add(currentSourceCoverage);
                GridGeometry2D gg = currentSourceCoverage.getGridGeometry();
                if (gridGeometry == null) {
                    gridGeometry = gg;
                    ColorSpace colorSpace = size == 1 && hasAlpha ? ColorSpace.getInstance(1003) : ColorSpace.getInstance(1004);
                    int transparency = hasAlpha ? 3 : 1;
                    ComponentColorModel cm = new ComponentColorModel(colorSpace, hasAlpha, false, transparency, currentSourceCoverage.getRenderedImage().getSampleModel().getDataType());
                    layout = new ImageLayout();
                    layout.setColorModel((ColorModel)cm);
                } else if (!gg.equals((Object)gridGeometry)) {
                    throw new IllegalArgumentException(Errors.format(6, "BandMerge"));
                }
                if (op == null) {
                    op = currentSourceCoverage.getRenderedImage();
                    w.setImage(op);
                    w.setROI(CoverageUtilities.getROIProperty((GridCoverage2D)currentSourceCoverage));
                    NoDataContainer container = CoverageUtilities.getNoDataProperty((GridCoverage2D)currentSourceCoverage);
                    w.setNoData(container != null ? container.getAsRange() : null);
                    continue;
                }
                w.setRenderingHints((RenderingHints)hints);
                ROI roi = w.getROI();
                ROI roiProperty = CoverageUtilities.getROIProperty((GridCoverage2D)currentSourceCoverage);
                if (roi != null) {
                    if (roiProperty != null) {
                        roi = roi.intersect(roiProperty);
                    }
                } else if (roiProperty != null) {
                    roi = roiProperty;
                }
                w.setROI(roi);
                NoDataContainer container = CoverageUtilities.getNoDataProperty((GridCoverage2D)currentSourceCoverage);
                w.addBand(currentSourceCoverage.getRenderedImage(), false, false, container != null ? container.getAsRange() : null);
                op = w.getRenderedImage();
                this.intermediateOps.add(op);
            } while (it.hasNext());
            if (layout != null) {
                hints.add(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout));
            }
            if (hasAlpha && !op.getColorModel().hasAlpha()) {
                w.addBand(this.alpha, false, true, null);
                op = w.getRenderedImage();
                this.intermediateOps.add(op);
            }
            op = w.format(op.getSampleModel().getDataType()).getRenderedImage();
            GridSampleDimension[] sd = new GridSampleDimension[op.getSampleModel().getNumBands()];
            for (int i = 0; i < sd.length; ++i) {
                sd[i] = new GridSampleDimension((CharSequence)TypeMap.getColorInterpretation((ColorModel)op.getColorModel(), (int)i).name());
            }
            HashMap properties = new HashMap();
            CoverageUtilities.setNoDataProperty(properties, (Object)w.getNoData());
            CoverageUtilities.setROIProperty(properties, (ROI)w.getROI());
            return this.getCoverageFactory().create((CharSequence)"BandMerge", op, gridGeometry, sd, sourceGridCoverages.toArray(new GridCoverage[sourceGridCoverages.size()]), properties);
        }
        throw new IllegalStateException(Errors.format(3, "BandMergeNode"));
    }

    public void setAlpha(RenderedImage alpha) {
        this.alpha = alpha;
    }
}

