/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import it.geosolutions.jaiext.range.NoDataContainer;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.util.HashMap;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.ConstantDescriptor;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.renderer.lite.gridcoverage2d.BaseCoverageProcessingNode;
import org.geotools.renderer.lite.gridcoverage2d.CoverageProcessingNode;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.factory.Hints;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.util.InternationalString;

public class ZeroImageNode
extends BaseCoverageProcessingNode {
    public ZeroImageNode(Hints hints) {
        super(1, hints, (InternationalString)SimpleInternationalString.wrap((CharSequence)"ZeroImageNode"), (InternationalString)SimpleInternationalString.wrap((CharSequence)"Returns a static black image"));
    }

    @Override
    protected GridCoverage execute() {
        CoverageProcessingNode source = this.getSource(0);
        GridCoverage2D sourceCoverage = (GridCoverage2D)source.getOutput();
        RenderedImage sourceImage = sourceCoverage.getRenderedImage();
        Number[] bandValues = new Byte[]{(byte)0};
        Hints hints = new Hints((RenderingHints)this.getHints());
        ImageLayout layout = new ImageLayout(sourceImage);
        layout.unsetValid(512).unsetValid(256);
        hints.put((Object)JAI.KEY_IMAGE_LAYOUT, (Object)layout);
        RenderedOp constant = ConstantDescriptor.create((Float)Float.valueOf(sourceImage.getWidth()), (Float)Float.valueOf(sourceImage.getHeight()), (Number[])bandValues, (RenderingHints)hints);
        GridCoverageFactory factory = this.getCoverageFactory();
        HashMap<String, NoDataContainer> properties = null;
        NoDataContainer noDataProperty = CoverageUtilities.getNoDataProperty((GridCoverage2D)sourceCoverage);
        if (noDataProperty != null) {
            properties = new HashMap<String, NoDataContainer>();
            properties.put("GC_NODATA", new NoDataContainer(255.0));
        }
        return factory.create((CharSequence)"zero", (RenderedImage)constant, sourceCoverage.getGridGeometry(), null, null, properties);
    }
}

