/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.menu;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.CRS;
import org.geotools.swing.MapPane;
import org.geotools.swing.dialog.JCRSChooser;
import org.geotools.swing.dialog.JExceptionReporter;
import org.geotools.swing.dialog.JTextReporter;
import org.geotools.swing.locale.LocaleUtils;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class JCRSPopupMenu
extends JPopupMenu {
    private static final String SET_CRS_STRING = LocaleUtils.getValue("Menu", "CRS_Set");
    private static final String SHOW_CRS_STRING = LocaleUtils.getValue("Menu", "CRS_Show");
    private MapPane mapPane;

    public JCRSPopupMenu() {
        this((MapPane)null);
    }

    public JCRSPopupMenu(MapPane mapPane) {
        super("CRS options");
        this.mapPane = mapPane;
        JMenuItem setCRSItem = new JMenuItem(SET_CRS_STRING);
        setCRSItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCRSPopupMenu.this.setCRS();
            }
        });
        this.add(setCRSItem);
        JMenuItem showCRSItem = new JMenuItem(SHOW_CRS_STRING);
        showCRSItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCRSPopupMenu.this.showCRS();
            }
        });
        this.add(showCRSItem);
    }

    public void setMapPane(MapPane mapPane) {
        this.mapPane = mapPane;
    }

    @Override
    public void show(Component invoker, int x, int y) {
        boolean enabled = this.mapPane != null && this.mapPane.getMapContent() != null;
        for (Component c : this.getComponents()) {
            if (!(c instanceof JMenuItem)) continue;
            c.setEnabled(enabled);
        }
        super.show(invoker, x, y);
    }

    private void setCRS() {
        if (this.mapPane != null && this.mapPane.getMapContent() != null) {
            CoordinateReferenceSystem newCRS;
            String initial = null;
            CoordinateReferenceSystem crs = this.mapPane.getMapContent().getCoordinateReferenceSystem();
            if (crs != null) {
                try {
                    initial = CRS.lookupIdentifier((Citation)Citations.EPSG, (CoordinateReferenceSystem)crs, (boolean)false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!((newCRS = JCRSChooser.showDialog(null, initial, "EPSG")) == null || crs != null && CRS.equalsIgnoreMetadata((Object)crs, (Object)newCRS))) {
                try {
                    this.mapPane.getMapContent().getViewport().setCoordinateReferenceSystem(newCRS);
                }
                catch (Exception ex) {
                    JExceptionReporter.showDialog(ex, "Failed to set the requested CRS");
                }
            }
        }
    }

    private void showCRS() {
        if (this.mapPane != null && this.mapPane.getMapContent() != null) {
            CoordinateReferenceSystem crs = this.mapPane.getMapContent().getCoordinateReferenceSystem();
            JTextReporter.showDialog("Coordinate reference system", crs.toWKT(), 1);
        }
    }
}

