/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.tool;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.geotools.map.Layer;
import org.geotools.swing.tool.InfoToolHelper;

class InfoToolHelperLookup {
    private static List<InfoToolHelper> cachedInstances;

    InfoToolHelperLookup() {
    }

    public static InfoToolHelper getHelper(Layer layer) {
        InfoToolHelperLookup.loadProviders();
        for (InfoToolHelper helper : cachedInstances) {
            try {
                if (!helper.isSupportedLayer(layer)) continue;
                return (InfoToolHelper)helper.getClass().newInstance();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return null;
    }

    private static void loadProviders() {
        if (cachedInstances == null) {
            cachedInstances = new ArrayList<InfoToolHelper>();
            ServiceLoader<InfoToolHelper> loader = ServiceLoader.load(InfoToolHelper.class);
            Iterator<InfoToolHelper> iter = loader.iterator();
            while (iter.hasNext()) {
                cachedInstances.add(iter.next());
            }
        }
    }
}

