/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.wizard;

import java.io.File;
import java.net.URL;
import javax.swing.JComponent;
import org.geotools.data.Parameter;
import org.geotools.swing.wizard.JDoubleField;
import org.geotools.swing.wizard.JField;
import org.geotools.swing.wizard.JFileField;
import org.geotools.swing.wizard.JGeometryField;
import org.geotools.swing.wizard.JURLField;
import org.geotools.swing.wizard.JWizard;
import org.locationtech.jts.geom.Geometry;

public abstract class ParamField {
    protected final Parameter<?> parameter;

    ParamField(Parameter<?> parameter) {
        this.parameter = parameter;
    }

    public abstract JComponent doLayout();

    public abstract boolean validate();

    public abstract void setValue(Object var1);

    public abstract void addListener(JWizard.Controller var1);

    public abstract void removeListener(JWizard.Controller var1);

    public abstract Object getValue();

    public static ParamField create(Parameter<?> parameter) {
        if (Double.class.isAssignableFrom(parameter.type)) {
            return new JDoubleField(parameter);
        }
        if (URL.class.isAssignableFrom(parameter.type)) {
            if (parameter.metadata != null && parameter.metadata.get("ext") != null) {
                return new JURLField(parameter);
            }
            JField field = new JField(parameter);
            field.setSingleLine(true);
            return field;
        }
        if (Boolean.class.isAssignableFrom(parameter.type)) {
            JField field = new JField(parameter);
            field.setSingleLine(true);
            return field;
        }
        if (Number.class.isAssignableFrom(parameter.type)) {
            JField field = new JField(parameter);
            field.setSingleLine(true);
            return field;
        }
        if (File.class.isAssignableFrom(parameter.type)) {
            return new JFileField(parameter);
        }
        if (Geometry.class.isAssignableFrom(parameter.type)) {
            return new JGeometryField(parameter);
        }
        return new JField(parameter);
    }
}

