/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.util.dynamic.db;

import com.baomidou.mybatisplus.annotation.DbType;
import java.util.HashMap;
import java.util.Map;

public class DbTypeUtils {
    public static Map<String, String> dialectMap = new HashMap<String, String>();

    public static boolean dbTypeIsMySql(DbType dbType) {
        return DbTypeUtils.dbTypeIf(dbType, DbType.MYSQL, DbType.MARIADB, DbType.CLICK_HOUSE, DbType.SQLITE);
    }

    public static boolean dbTypeIsOracle(DbType dbType) {
        return DbTypeUtils.dbTypeIf(dbType, DbType.ORACLE, DbType.ORACLE_12C, DbType.DM);
    }

    public static boolean dbTypeIsSqlServer(DbType dbType) {
        return DbTypeUtils.dbTypeIf(dbType, DbType.SQL_SERVER, DbType.SQL_SERVER2005);
    }

    public static boolean dbTypeIsPostgre(DbType dbType) {
        return DbTypeUtils.dbTypeIf(dbType, DbType.POSTGRE_SQL, DbType.KINGBASE_ES, DbType.GAUSS);
    }

    public static String getDbTypeString(DbType dbType) {
        if (DbType.DB2.equals((Object)dbType)) {
            return "DB2";
        }
        if (DbType.HSQL.equals((Object)dbType)) {
            return "HSQL";
        }
        if (DbTypeUtils.dbTypeIsOracle(dbType)) {
            return "ORACLE";
        }
        if (DbTypeUtils.dbTypeIsSqlServer(dbType)) {
            return "SQLSERVER";
        }
        if (DbTypeUtils.dbTypeIsPostgre(dbType)) {
            return "POSTGRESQL";
        }
        return "MYSQL";
    }

    public static String getDbDialect(DbType dbType) {
        return dialectMap.get(dbType.getDb());
    }

    public static boolean dbTypeIf(DbType dbType, DbType ... correctTypes) {
        for (DbType type : correctTypes) {
            if (!type.equals((Object)dbType)) continue;
            return true;
        }
        return false;
    }

    static {
        dialectMap.put("mysql", "org.hibernate.dialect.MySQL5InnoDBDialect");
        dialectMap.put("mariadb", "org.hibernate.dialect.MariaDBDialect");
        dialectMap.put("oracle", "org.hibernate.dialect.OracleDialect");
        dialectMap.put("oracle12c", "org.hibernate.dialect.OracleDialect");
        dialectMap.put("db2", "org.hibernate.dialect.DB2390Dialect");
        dialectMap.put("h2", "org.hibernate.dialect.HSQLDialect");
        dialectMap.put("hsql", "org.hibernate.dialect.HSQLDialect");
        dialectMap.put("sqlite", "org.jeecg.modules.online.config.dialect.SQLiteDialect");
        dialectMap.put("postgresql", "org.hibernate.dialect.PostgreSQLDialect");
        dialectMap.put("sqlserver2005", "org.hibernate.dialect.SQLServer2005Dialect");
        dialectMap.put("sqlserver", "org.hibernate.dialect.SQLServerDialect");
        dialectMap.put("dm", "org.hibernate.dialect.DmDialect");
        dialectMap.put("xugu", "org.hibernate.dialect.HSQLDialect");
        dialectMap.put("kingbasees", "org.hibernate.dialect.PostgreSQLDialect");
        dialectMap.put("phoenix", "org.hibernate.dialect.HSQLDialect");
        dialectMap.put("zenith", "org.hibernate.dialect.PostgreSQLDialect");
        dialectMap.put("clickhouse", "org.hibernate.dialect.MySQLDialect");
        dialectMap.put("gbase", "org.hibernate.dialect.PostgreSQLDialect");
        dialectMap.put("oscar", "org.hibernate.dialect.PostgreSQLDialect");
        dialectMap.put("sybase", "org.hibernate.dialect.SybaseDialect");
        dialectMap.put("oceanbase", "org.hibernate.dialect.PostgreSQLDialect");
        dialectMap.put("Firebird", "org.hibernate.dialect.FirebirdDialect");
        dialectMap.put("highgo", "org.hibernate.dialect.HSQLDialect");
        dialectMap.put("other", "org.hibernate.dialect.PostgreSQLDialect");
    }
}

